// Your code goes here.
$(document).ready(function(){

//======== LOCAL SCROLL =============//
$('.navigation li').localScroll({ duration: 1000 });
$('.button1').localScroll({ duration: 1000 });

//=========== MOBILE NAV =============//
$('.navigation').mobileMenu({
	defaultText: 'Navigation',
	className: 'select-menu',
	subMenuDash: '&ndash;'
});

//========= SCROLL NAV ==============//
$('.navigation').onePageNav({filter: ':not(.external)'});    

//======== STICKY HEADER =============//
$("#header-wrap").sticky({topSpacing:0});

//============ PARALLAX =============//

$('.inner-wrap').parallax("50%", 0.1);
$('.inner-wrap2').parallax("50%", 0.1);
$('.inner-wrap3').parallax("50%", 0.1);
$('.inner-wrap4').parallax("50%", 0.1);

//=========== LIGHTBOX =============//
$("a[class^='prettyPhoto']").prettyPhoto({theme:'pp_default'});

//======== CAMERA SLIDER ============//
jQuery('#camera_wrap_1').camera({
	height: '58%',
	pagination: false,
	hover: false,
	loader: 'none',
	thumbnails: false
});

//======== TOP CONTENT LAZYLOAD ============//
$(window).load(function() {
	jQuery(".top-inner").show();
});

//=========== ISOTOPE =============//
$(function(){
	var $container = $('#folio');
	$container.isotope({
		itemSelector : '.folio-item'
	});
	var $optionSets = $('#portfolio .folio-filter'),
		$optionLinks = $optionSets.find('a');
	$optionLinks.click(function(){
		var $this = $(this);
		// don't proceed if already selected
		if ( $this.hasClass('selected') ) {
			return false;
		}
		var $optionSet = $this.parents('.folio-filter');
		$optionSet.find('.selected').removeClass('selected');
		$this.addClass('selected');
	// make option object dynamically, i.e. { filter: '.my-filter-class' }
	var options = {},
		key = $optionSet.attr('data-option-key'),
		value = $this.attr('data-option-value');
		
	// parse 'false' as false boolean
	value = value === 'false' ? false : value;
	options[ key ] = value;
		if ( key === 'layoutMode' && typeof changeLayoutMode === 'function' ) {
		changeLayoutMode( $this, options );
	} else {
		// otherwise, apply new options
		$container.isotope( options );
	}    
	return false;
	});
});
  
//============= GMAP ===============//

$('#map_addresses').gMap({
	address: "Estadio San Martin de Porres",
	zoom: 15,
	arrowStyle: 2,
	controls: {
       panControl: true,
        zoomControl: true,
        mapTypeControl: false,
        scaleControl: false,
        streetViewControl: true,
        overviewMapControl: false
    },

		markers:[
		{
			address: "Estadio San Martin de Porres",
			html: " 12 Some street, Country NJ 12345",
			popup: false,
			icon: {
				image: "images/gmarker.png",
				iconsize: [34, 47],
				iconanchor: [12,46]
			}
		}
		]
	});

//============= FORM PLACEHOLDER PLUGIN ===============//

$('input, textarea').placeholder();


});