(function($) {
	
	$.royaleContact = function(data) {
		
		// IF DATA IS DECLARED
		if(data) {
			
			var err = data.emptyTextMessage + " ", 
			emailErr = data.emailErrorMessage,
			submitUrl = data.contactPhpFile,
			message = data.successMessage;
			
		}
		
		// GLOBAL VARS
		var contact = $(".royale-form"),
		shown = false,
		successMes,
		typed;
		
		// IF CONTACT FORM IS FOUND
		if(contact.length) {
			
			contact.find("input").each(function() {
				
				if($(this).attr("type")) {
					
					typed = $(this).attr("type");
					
					if(typed !== "hidden" && typed !== "image") {
						
						if($(this).attr("value")) {
							
							$(this).data("original", $(this).attr("value")).focus(inFocus).blur(outFocus);
							
						}
							
					}
					
				}
				
			});
			
			contact.find("textarea").each(function() {
					
				$(this).data("original", $(this).text()).focus(inFocus).blur(outFocus);
					
			});
			
			if(contact.attr("class").search("blog-form") === -1) {
				
				contact.submit(submitForm);
				
			}
			
		}
		
		data = null;
		typed = null;
		
		// CONTACT FORM SUBMIT EVENT
		function submitForm(event) {
			
			event.preventDefault();
  			event.stopPropagation();
			
			if(successMes) successMes.stop(true, true).css("display", "none");
			
			var st, val, ids, amp, before, after, typed = "", checked, passed = true;
			
			contact.children("fieldset").children().each(function() {
				
				checked = false;
				
				if($(this).attr("name")) {
				
					if($(this).attr("type")) {
						
						if($(this).attr("type") === "text") checked = true;
						
					}
					
					if($(this).is("textarea")) checked = true;
					
				}
					
				if(checked) {
							
					st = $(this).attr("name");		
					val = this.value;
								
					if(st.search("required") !== -1) {
						
						// CHECK FOR VALID STRING
						if(val === "" || val === $(this).data("original")) {
							
							this.value = err + st.split("-required")[0];
							passed = false;
									
						}
						
						// EMAIL VALIDATION
						if(st === "email-required") {
									
							before = val.indexOf("@");
							after = val.lastIndexOf(".");
									
							if(before === 0 || after < before + 2 || after + 2 >= val.length) {
										
								this.value = emailErr;
								passed = false;
										
							}
								
						}
						
					}
					
				}
					
			});
			
			// SUBMIT THE EMAIL
			if(passed) {
				
				$.ajax({type: "POST", url: submitUrl, data: contact.serialize(), success: showSuccess});
				
				contact.unbind("submit", submitForm).children("fieldset").children().each(function() {
					
					if($(this).data("original")) this.value = $(this).data("original");
					
				});
				
				contact.submit(submitForm);
				
			}
				
		}
		
		// EMAIL SUCCESS EVENT
		function showSuccess() {
			
			shown = true;
			
			if(!successMes) {
				successMes = $("<p />").addClass("contact-form-success-message").attr("id", "success-message").text(message).insertBefore($("#submit")).fadeIn();
			}
			else {
				successMes.stop(true, true).fadeIn();	
			}
			
		}
		
		// INPUT FIELD FOCUS IN EVENT		
		function inFocus() {
			
			if(successMes && shown) {
				
				successMes.stop(true, true).fadeOut();
				shown = false;
				
			}
			
			var st = this.value;
			
			if(st === $(this).data("original") || st === err + $(this).attr("name").split("-required")[0] || st === emailErr) {
			
				this.value = "";
				
			}
			
			$(this).addClass("form-field-focus");
			
		}
		
		// INPUT FIELD FOCUS OUT EVENT
		function outFocus() {
			
			if(this.value === "") this.value = $(this).data("original");
			
			$(this).removeClass("form-field-focus");
			
		}
		
	}
	
})(jQuery);












