(function($) {
	
	$.royaleBgImage = function(data) {
		
		// RETURN IF NO BG SETTINGS ARE DECLARED
		if(data == undefined) {
		
			alert("bgSettings need to be defined");
			return;
			
		}
		
		// GLOBAL VARS
		var img, 
		imgWidth,
		imgHeight,
		win = $(window), 
		winWide = win.width(), 
		winTall = win.height(),
		centered = data.scaleFrom === "center" ? true : false,
		bg = $("<div />").css({position: "fixed", top: 0, left: 0}).appendTo($("body")),
		
		img = $("<img />").css({position: "absolute", display: "none"}).load(loaded).appendTo(bg);
		img.attr("src", data.url);
		
		win.resize(sizer);
		
		data = null;
		
		// BG IMAGE LOAD EVENT
		function loaded(event) {                                          
			
			event.stopPropagation();
			
			imgWidth = $(event.target).width();
			imgHeight = $(event.target).height();
			
			sizer();
			
			img.unbind("load", loaded).fadeIn(750);
						
		}
		
		// WINDOW RESIZE EVENT
		function sizer(fromLoad) {
			
			winWide = win.width();
			winTall = win.height();
			
			var wide = winWide / imgWidth;
			var tall = winTall / imgHeight;
			var perc, w, h, x, y;
			
			perc = (wide > tall) ? wide : tall;
			w = Math.ceil(imgWidth * perc);
			h = Math.ceil(imgHeight * perc);
				
			if(centered) {
				
				(w > winWide) ? x = Math.floor((w - winWide) >> 1) : x = 0;
				(h > winTall) ? y = Math.floor((h - winTall) >> 1) : y = 0;
						
			}
			else {
					
				x = 0;
				y = 0;
						
			}
			
			img.width(w).height(h).css({top: -y, left: -x});
				
		}
		
	}
	
})(jQuery);



