<?php
/*
 * Template Name: Left Note Block
 */

/**
 * Template for a page with left note block
 *
 * @package Storm
 * @since Storm 1.0
 * @see content-page.php
 */
?><!DOCTYPE html>
<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?> class="no-js">
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?> class="no-js">
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?> class="no-js">
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?> class="no-js">
<!--<![endif]-->
<head>
<script type="text/javascript">with(document.documentElement){className=className.replace(/\bno-js\b/,'js');}</script>
<meta charset="<?php bloginfo('charset'); ?>" />
<meta name="viewport" content="width=1000, user-scalable=yes, target-densitydpi=device-dpi"/>
<title><?php wp_title('|', true, 'right') . bloginfo('name'); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<link rel="stylesheet" href="<?php echo TCR_URL; ?>/style.css" type="text/css" media="all" />
<?php tcr_head(); ?>
<?php wp_head(); ?>
</head>
<body id="top" <?php body_class(); ?>>
<?php tcr_body_start(); ?>

<div id="outside">

    <?php tcr_before_header(); ?>

    <div id="header-outer" class="clearfix">
        <div id="header-inner">

            <?php tcr_header(); ?>

        </div><!-- #header-inner -->
	</div><!-- #header-outer -->

	<div class="content-outer clearfix">
		<div class="content-inner">

            <?php tcr_before_content_style(); ?>

            <div class="content-style left-note-block clearfix">

                <?php tcr_before_content(); ?>

                <div id="content">

                    <?php while (have_posts()) : the_post(); ?>

                        <?php get_template_part('content', 'page'); ?>

                    <?php endwhile; ?>

                </div><!-- #content -->

                <?php tcr_after_content(); ?>

            </div><!-- .content-style clearfix -->

            <?php tcr_after_content_style(); ?>

        </div><!-- .content-inner -->
    </div><!-- .content-outer -->

    <?php tcr_before_footer(); ?>

    <!-- Begin Footer -->
  	<div id="footer">
        <div class="footer-inside clearfix">
            <?php tcr_footer(); ?>
        </div>
	</div>

	<?php tcr_after_footer(); ?>

</div><!-- #outside -->
<?php wp_footer(); ?>

</body>
</html>