<?php
/*
 * Template Name: Intro Page
 */

/**
 * Template for an intro page
 *
 * @package Storm
 * @since Storm 1.0
 */
global $post;
$url = !empty($post) ? tcr_get_post_meta($post->ID, 'skip_url', home_url()) : home_url();
?><!DOCTYPE html>
<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?> class="no-js">
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?> class="no-js">
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?> class="no-js">
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?> class="no-js">
<!--<![endif]-->
<head>
<script type="text/javascript">with(document.documentElement){className=className.replace(/\bno-js\b/,'js');}</script>
<meta charset="<?php bloginfo('charset'); ?>" />
<meta name="viewport" content="width=1000, user-scalable=yes, target-densitydpi=device-dpi"/>
<title><?php wp_title('|', true, 'right') . bloginfo('name'); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<link rel="stylesheet" href="<?php echo TCR_URL; ?>/style.css" type="text/css" media="all" />
<?php tcr_head(); ?>
<?php wp_head(); ?>
</head>
<body id="top" <?php body_class(); ?>>
<?php tcr_body_start(); ?>

<div id="outside">

    <!-- Begin Footer -->
  	<div id="footer">
        <div class="footer-inside clearfix">
            <?php tcr_footer(); ?>
        </div>
	</div>

	<div id="intro-page-skip"><a href="<?php echo esc_url($url); ?>"><?php tcr_esc_html_e('skip_intro', __('Skip intro &raquo;', TCR_TEXT_DOMAIN)); ?></a></div>

</div><!-- #outside -->
<?php wp_footer(); ?>

</body>
</html>