<?php
/*
 * Template Name: Contact Page
 */

/**
 * Template for the contact page
 *
 * @package Storm
 * @since Storm 1.0
 */
global $tcr;
get_header(); ?>

<?php tcr_breadcrumbs(); ?>

<?php while (have_posts()) : the_post(); ?>

    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

        <div class="entry-content clearfix">
            <?php
                the_content();
            ?>
        </div><!-- .entry-content -->

        <?php edit_post_link(__('Edit', TCR_ADMIN_TEXT_DOMAIN), '<div class="entry-meta clearfix"><span class="edit-link">', '</span></div><!-- .entry-meta -->'); ?>

        <div class="contact-template-wrap clearfix">
            <div class="contact-left-col">

                <?php if (function_exists('iphorm')) : ?>
                    <?php if (is_numeric($tcr['options']['contact_quform_id']) && iphorm_form_exists($tcr['options']['contact_quform_id'])) : ?>
                        <?php echo iphorm($tcr['options']['contact_quform_id']); ?>
                    <?php else : ?>
                        Please choose a form to use in the theme options panel, at Contact &rarr; General.
                    <?php endif; ?>
                <?php else : ?>
                    Please install the Quform plugin to use the contact form.
                <?php endif; ?>

            </div>

            <div class="contact-right-col">
                <div class="contact-info-wrap">

                    <?php if ($tcr['options']['contact_phone_number']) : ?>
                    <!--Phone Number-->
                    <div class="contact-type-wrap  phone clearfix">
                        <div class="contact-type-left">
                            <span class="contact-ico"></span>
                            <h3><?php tcr_esc_html_e('phone', __('Phone', TCR_TEXT_DOMAIN)); ?></h3>
                        </div>
                        <div class="contact-type-right">
                            <?php echo $tcr['options']['contact_phone_number']; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if ($tcr['options']['contact_fax_number']) : ?>
                    <!--Fax Number-->
                    <div class="contact-type-wrap fax clearfix">
                        <div class="contact-type-left">
                            <span class="contact-ico"></span>
                            <h3><?php tcr_esc_html_e('fax', __('Fax', TCR_TEXT_DOMAIN)); ?></h3>
                        </div>
                        <div class="contact-type-right">
                            <?php echo $tcr['options']['contact_fax_number']; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if ($tcr['options']['contact_email']) : ?>
                    <!--Email Address-->
                    <div class="contact-type-wrap email clearfix">
                        <div class="contact-type-left">
                            <span class="contact-ico"></span>
                            <h3><?php tcr_esc_html_e('email', __('Email', TCR_TEXT_DOMAIN)); ?></h3>
                        </div>
                        <div class="contact-type-right">
                            <a href="mailto:<?php echo esc_attr($tcr['options']['contact_email']); ?>"><?php echo $tcr['options']['contact_email']; ?></a>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

                <?php if ($tcr['options']['contact_address']) : ?>
                    <!--Address-->
                    <div class="contact-type-wrap address clearfix">
                        <div class="clearfix">
                            <div class="contact-type-left">
                                <span class="contact-ico"></span>
                                <h3><?php tcr_esc_html_e('location', __('Location', TCR_TEXT_DOMAIN)); ?></h3>
                            </div>
                            <div class="contact-type-right">
                                <?php if ($tcr['options']['contact_address']) : ?>
                                    <?php echo nl2br($tcr['options']['contact_address']); ?>
                                <?php endif; ?>

                                <?php if ($tcr['options']['contact_map']) : ?>
                                <div class="view-map-wrap clearfix">
                                    <a class="button-press view-map"><?php tcr_esc_html_e('find_us', __('Find us', TCR_TEXT_DOMAIN)); ?></a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <?php if ($tcr['options']['contact_map']) : ?>
                    <div class="hidden-map" style="display: none;">
                        <?php echo $tcr['options']['contact_map']; ?>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

        </div><!-- .contact-template-wrap -->

    </div><!-- #post-## -->

<?php endwhile; ?>

<?php get_footer(); ?>