/*
 * Image preloader
 * 
 * Usage: $.preloadImages([array of paths], 'common path prefix');
 */
(function(b){b.preloadImages=function(d,a){for(var a=a?a:"",b=[],c=0;c<d.length;c++){var e=new Image;e.src=a+d[c];b.push(e)}}})(jQuery);

;(function($, window) {    
	$(document).ready(function() {	    
		var $window = $(window),
		$body = $('body'),
		isIE7 = $.browser.msie && parseInt($.browser.version, 10) === 7,
		cufonEnabled = !!window.Cufon && typeof tcrL10n.font === 'object' && tcrL10n.font.type === 'cufon';
		
	    if (cufonEnabled && tcrL10n.font.selector != '') {
	        Cufon.replace($(tcrL10n.font.selector).not('.portfolio-captions *'), { fontFamily: tcrL10n.font.family });      
	    }
	    
	    if (cufonEnabled && tcrL10n.font.portfolio) {
	        Cufon.replace('.portfolio-item-title', { fontFamily: tcrL10n.font.family });      
	    };
		
		// Last & first child classes
		$('.accordion-content-wrap:last-child').addClass('last-child');
		
		if (tcrL10n.video) {
		    var $video = $('#video-background'),
		    $videoWrap = $('#video-background-wrap');
		    
		    if ($video.length) {
		    	var videoAutostart = tcrL10n.video.autostart,
		    	userAutostart = $.cookie('tcrVideoPlay'),
		    	videoMute = $.cookie('tcrVideoMute') === 'mute',
		    	$videoControlsWrap = $('#video-controls'),
		    	$videoControls,
		    	$videoPlay,
		    	$videoMute;

		    	$videoControls = $('<div class="video-controls"></div>').append(
	    	        $videoPlay = $('<div class="video-play"></div>'),
	    	        $videoMute = $('<div class="video-unmute"></div>')
	            );

		    	// Check if the user has clicked play or pause previously and use that state	    	
		    	if (userAutostart === 'play') {
		    	    videoAutostart = true;
		    	} else if (userAutostart === 'pause') {
		    	    videoAutostart = false;
		    	}
		    	
		    	if (videoAutostart) {
		    	    $videoPlay.removeClass('video-play').addClass('video-pause');
		    	}
		    	
		    	if (videoMute) {
		    	    $videoMute.removeClass('video-unmute').addClass('video-mute');
		    	}
		    	
		    	$body.addClass('video-background');
		    	$videoControlsWrap.append($videoControls);

		    	if (!tcrL10n.video.width) {    		    	
    		    	tcrL10n.video.width = 640;
    		    }
    		    if (!tcrL10n.video.height) {    		    	
    		    	tcrL10n.video.height = 390;
    		    }
    		    
    		    if (isIE7) {
    		    	$video.attr('src', $video.attr('src') + '&autoplay=1');
    		    	$videoControlsWrap.remove();
    		    }
    		        		    
    		    var videoRatio = tcrL10n.video.width / tcrL10n.video.height;
	        	
	        	var resizeVideo = function () {
    		    	var wWidth = $window.width(),
    		    	wHeight = $window.height(),
    		    	wRatio = wWidth / wHeight;
    		    	
    		    	if (wRatio > videoRatio) {
    		    		var newWidth = wWidth,
    		    		newHeight = parseInt(wWidth / videoRatio);
    		    	} else {
    		    		var newWidth = wHeight * videoRatio,
    		    		newHeight = wHeight;
    		    	}
    		    	
		    		if (tcrL10n.video.type == 'vimeo') {
		    			$video.width(newWidth).height(newHeight);
		    		} else if (tcrL10n.video.type == 'youtube' && player) {
		    			player.setSize(newWidth, newHeight);
		    		}
		    		
    		    	$videoWrap.css({
    		    		width: newWidth + 'px',
    		    		height: newHeight + 'px',
    		    		left: parseInt(((wWidth - newWidth) / 2)) + 'px',
    		    		top: parseInt(((wHeight - newHeight) / 2)) + 'px'
    		    	})
    		    };
    		    
    		    $window.bind('resize.tcr-video', $.isFunction($.throttle) ? $.throttle(250, resizeVideo) : resizeVideo);
	        	
    		    if (tcrL10n.video.type == 'vimeo') {
    		        var player = $f($video[0]);

    		        player.addEvent('ready', function () {
    		        	$window.resize();
    		        	
    		        	if (videoMute) {
    		        	    player.api('setVolume', 0);
    		        	}

    		        	if (tcrL10n.video.start > 0) {
    		        	    player.api('seekTo', tcrL10n.video.start);
    		        	}
    		        	
    		            if (videoAutostart) {
    	                    player.api('play');
    	                }
    		            
    		            player.addEvent('finish', function () {
    		                if (tcrL10n.video.complete == 'redirect' && tcrL10n.video.redirect) {
    		                    window.location = tcrL10n.video.redirect;
    		                } else if (tcrL10n.video.complete == 'restart') {
    		            		player.api('play');
    		        		} else if (tcrL10n.video.complete == 'hide') {
    		        			$window.unbind('resize.tcr-video');
    		        			$videoWrap.remove();
	        					delete player;
    		        		}
    		            });
    		            
    		            $videoPlay.click(function () {
    		                if ($videoPlay.hasClass('video-play')) {
    		                    $videoPlay.removeClass('video-play').addClass('video-pause');
    		                    player.api('play');
    		                    $.cookie('tcrVideoPlay', 'play', {expires: 28, path: '/'});
    		                } else {
    		                    $videoPlay.removeClass('video-pause').addClass('video-play');
                                player.api('pause');
                                $.cookie('tcrVideoPlay', 'pause', {expires: 28, path: '/'});
    		                }
    		            });
    		            
    		            $videoMute.click(function () {
                            if ($videoMute.hasClass('video-unmute')) {
                                $videoMute.removeClass('video-unmute').addClass('video-mute');
                                player.api('setVolume', 0);
                                $.cookie('tcrVideoMute', 'mute', {expires: 28, path: '/'});
                            } else {
                                $videoMute.removeClass('video-mute').addClass('video-unmute');
                                player.api('setVolume', 1);
                                $.cookie('tcrVideoMute', 'unmute', {expires: 28, path: '/'});
                            }
                        });
    		        });
    		    } else if (tcrL10n.video.type == 'youtube') {
    		        // Load the IFrame Player API code asynchronously.
    		        var tag = document.createElement('script');
    		        tag.src = "https://www.youtube.com/player_api";
    		        var firstScriptTag = document.getElementsByTagName('script')[0];
    		        firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
    		        
    		        // Check window size
    		        var wX = $window.width(),
    		    	wY = $window.height(),
    		    	wR = wX / wY;
    		    	
    		    	if (wR > videoRatio) {
    		    		var newX = wX,
    		    		newY = parseInt(wX / videoRatio);
    		    	} else {
    		    		var newX = wY * videoRatio,
    		    		newY = wY;
    		    	}

    		        var player,
    		        playerVars = {
                        wmode: 'transparent',
                        autohide: 1,
                        controls: 0,
                        modestbranding: 1,
                        rel: 0
                    };
                    
                    if (tcrL10n.video.start > 0) {
                        playerVars.start = tcrL10n.video.start;
                    }
                    
    		        window.onYouTubePlayerAPIReady = function () {
    		            player = new YT.Player('video-background', {
    		            	width: newX,
    		            	height: newY,
    		            	videoId: tcrL10n.video.id,
	    		            events: {
	    		            	onReady: onPlayerReady,
	    		            	onStateChange: onPlayerStateChange
	    		            },
	    		            playerVars: playerVars	    		            
    		            });
    		        }
    		        
    		        function onPlayerReady(event)
    		        {
    		        	$window.resize();
    		        	
    		        	if (videoMute) {
                            player.mute();
                        }
    		        	
    		        	if (videoAutostart) {
    		        		player.playVideo();
    		        	}
    		        	
    		        	setTimeout(function () {
                            $videoWrap.animate({ opacity: 1 }, 1000);
                        }, 500);

                        $videoPlay.click(function () {
                            if ($videoPlay.hasClass('video-play')) {
                                $videoPlay.removeClass('video-play').addClass('video-pause');
                                player.playVideo();
                                $.cookie('tcrVideoPlay', 'play', {expires: 28, path: '/'});
                            } else {
                                $videoPlay.removeClass('video-pause').addClass('video-play');
                                player.pauseVideo();
                                $.cookie('tcrVideoPlay', 'pause', {expires: 28, path: '/'});
                            }
                        });
                        
                        $videoMute.click(function () {
                            if ($videoMute.hasClass('video-unmute')) {
                                $videoMute.removeClass('video-unmute').addClass('video-mute');
                                player.mute();
                                $.cookie('tcrVideoMute', 'mute', {expires: 28, path: '/'});
                            } else {
                                $videoMute.removeClass('video-mute').addClass('video-unmute');
                                player.unMute();
                                $.cookie('tcrVideoMute', 'unmute', {expires: 28, path: '/'});
                            }
                        });
    		        }
    		            		        
    		        function onPlayerStateChange(event)
    		        {
    		        	if (event.data == YT.PlayerState.ENDED) {
    		        	    if (tcrL10n.video.complete == 'redirect' && tcrL10n.video.redirect) {
    		        	        window.location = tcrL10n.video.redirect;
    		        	    } else if (tcrL10n.video.complete == 'restart') {
    		        			player.playVideo();
    		        		} else if (tcrL10n.video.complete == 'hide') {
    		        			$window.unbind('resize.tcr-video');
    		        			$videoWrap.remove();
	        					delete player;
    		        		}
    		        	}
    		        }    		        
    		    } // end type == youtube
    		    
		    } // end if $video.length
		} else {		    
		    $.fullscreen($.extend({
                captionEnhancement: function ($captionOuter) {
                    if (cufonEnabled && tcrL10n.font.fullscreen) {
                        Cufon.replace('.fullscreen-caption h1, .fullscreen-caption h2, .fullscreen-caption h3', { fontFamily: tcrL10n.font.family });        
                    }                       
                }
            }, tcrL10n.backgroundOptions));
		}
		
		// Audio player setup
		if (tcrL10n.audio && tcrL10n.audio.files && tcrL10n.audio.files.length && $.isFunction($.fn.jPlayer)) {
			var audioIndex = 0,
			audioTotal = tcrL10n.audio.files.length,
			audioAutostart = tcrL10n.audio.autostart,
			userAudioAutostart = $.cookie('tcrAudioPlay'),
			audioMute = $.cookie('tcrAudioMute') === 'mute',
			userAudioIndex = parseInt($.cookie('tcrAudioIndex')),
			useUserAudioIndex = !tcrL10n.audio.random && !tcrL10n.audio.specific,
			$audioControls,
			$audioPlay,
			$audioNext,
			$audioPrev,
			$audioMute,
			$player;
			
			// Set up the controls
			$audioControls = $('<div class="audio-controls"></div>').append(
				$audioPrev = $('<div class="audio-prev"></div>'),
				$audioPlay = $('<div class="audio-play"></div>'),
				$audioMute = $('<div class="audio-unmute"></div>'),
				$audioNext = $('<div class="audio-next"></div>')
            );
			
			// Check if the user has previously clicked the pause or play button and maintain that state
			if (userAudioAutostart === 'play') {
			    audioAutostart = true;
			} else if (userAudioAutostart === 'pause') {
			    audioAutostart = false;
			}
			
			if (audioAutostart) {
				$audioPlay.removeClass('audio-play').addClass('audio-pause');
			}
			
			if (audioMute) {
			    $audioMute.removeClass('audio-unmute').addClass('audio-mute');
			}
			
			// Continue from the last played track if the audio is not randomised or page-specific
			if ($.isNumeric(userAudioIndex) && userAudioIndex >= 0 && userAudioIndex < audioTotal && useUserAudioIndex) {
			    audioIndex = userAudioIndex;
			}
			
			// Hide the previous and next button if it's a single track
			if (audioTotal == 1) {
				$audioPrev.add($audioNext).hide();
			}
			
			$body.addClass('audio-background');
			$('#audio-controls').append($audioControls);
			
			$player = $('#jplayer-container').jPlayer({
				ready: function (event) {
					$player.jPlayer('setMedia', tcrL10n.audio.files[audioIndex]);
					if (audioMute) {
					    $player.jPlayer('mute');
					}
					
					if (audioAutostart) {
						$player.jPlayer('play');
					}
				},
				swfPath: tcrL10n.themeUrl + '/js/',
				supplied: tcrL10n.audio.supplied,
				wmode: 'window',
				ended: function () {
				    // If we are at the last track, check if we should loop or stop
				    if (audioIndex == (audioTotal - 1)) {
				        if (tcrL10n.audio.complete == 'restart') {
				            $audioNext.click();
				        }
				    } else {
				        // We are not at the end so play next track
				        $audioNext.click();
				    }
				}
			});
			
			$audioPrev.click(function () {
				audioIndex = (audioIndex == 0) ? audioTotal - 1 : audioIndex - 1;
				$player.jPlayer('setMedia', tcrL10n.audio.files[audioIndex]);
				$player.jPlayer('play');
				$audioPlay.removeClass('audio-play').addClass('audio-pause');
				if (useUserAudioIndex) {
				    $.cookie('tcrAudioIndex', audioIndex, {expires: 28, path: '/'});
				}
			});
			
			$audioPlay.click(function () {
				if ($audioPlay.hasClass('audio-play')) {
					$audioPlay.removeClass('audio-play').addClass('audio-pause');
					$player.jPlayer('play');
					$.cookie('tcrAudioPlay', 'play', {expires: 28, path: '/'});
				} else {
					$audioPlay.removeClass('audio-pause').addClass('audio-play');
					$player.jPlayer('pause');
					$.cookie('tcrAudioPlay', 'pause', {expires: 28, path: '/'});
				}
			});
			
			$audioMute.click(function () {
				if ($audioMute.hasClass('audio-unmute')) {
					$audioMute.removeClass('audio-unmute').addClass('audio-mute');
					$player.jPlayer('mute');
					$.cookie('tcrAudioMute', 'mute', {expires: 28, path: '/'});
				} else {
					$audioMute.removeClass('audio-mute').addClass('audio-unmute');
					$player.jPlayer('unmute');
					$.cookie('tcrAudioMute', 'unmute', {expires: 28, path: '/'});
				}		
			});
			
			$audioNext.click(function () {
				audioIndex = (audioIndex == (audioTotal - 1)) ? 0 : audioIndex + 1;
				$player.jPlayer('setMedia', tcrL10n.audio.files[audioIndex]);
				$player.jPlayer('play');
				$audioPlay.removeClass('audio-play').addClass('audio-pause');
				if (useUserAudioIndex) {
				    $.cookie('tcrAudioIndex', audioIndex, {expires: 28, path: '/'});
				}
			});			
		} // end if tcrL10n.audio
		

		// Initialise the menu
		$('#nav-wrap-inner ul.primary-menu').superfish({ speed: 0 });
		
		// Sticky header
        if ($body.hasClass('sticky-header')) {
            var $header = $('#header-outer'),
            positionStickyHeader = function () {
                var scrollY = $(window).scrollTop(),
                isFixed = $header.css('position') == 'fixed',
                minY = $('#outside').offset().top + 20;            
                                
                if (scrollY > minY && !isFixed) {
                    $body.addClass('sticky-header-active');
                } else if (scrollY < minY && isFixed) {
                    $body.removeClass('sticky-header-active');
                }
            };
            
            $window.bind('scroll.sticky-header resize.sticky-header', $.isFunction($.throttle) ? $.throttle(10, positionStickyHeader) : positionStickyHeader);
        }
            	
		if ($.isFunction($.fn.fptabs)) {
			// Slide up / slide down effect
			$.tools.tabs.addEffect('slide-slide',function(tabIndex, done) { 
		        this.getPanes().slideUp(400).eq(tabIndex).delay(400).slideDown(400, done);           
		    });
						
			// Tabs
			$('.tabs').each(function () {
				var $root = $(this),
				effect = $root.hasClass('sliding') ? 'slide-slide' : 'default';
				$root.fptabs('.tab-content', {
					tabs: '> .tabs-nav > li',
					current: 'active',
					effect: effect
				});
			});
			
			// Blog tabs
			$('#comment-tabs-nav').fptabs('.comment-tab');
		}
		
		// Accordion & toggles		
		$('.accordion').each(function () {
			var $root = $(this),
			$triggers = $root.find('> h3').prepend('<span class="acc-icon"/>');
			
			if ($root.hasClass('toggle')) {
				$triggers.click(function () {
					var $this = $(this);
					
					if ($this.hasClass('active')) {
						$this.next().slideUp(400, function () {
							$this.removeClass('active');
						});
					} else {
						$this.addClass('active');
						$this.next().slideDown(400);
					}
				});
			} else {
				$triggers.click(function (e) {
					var $this = $(this);
					if ($this.next().is(':hidden')) {
						$triggers.removeClass('active').next().slideUp();
						$this.toggleClass('active').next().slideDown();
					}
				});
			}
		});
				
		// Bind the search button to show/hide the search field
		var $searchContainer = $('.search-container');
		$('#search-button').click(function() {
			if ($searchContainer.is(':visible')) {
				$searchContainer.stop().fadeOut();
			} else {
				$searchContainer.stop().fadeIn();
				$('#search-input').focus();
			}
			return false;
		});
		
		// Footer pop out widgets
		$('.footer-pop-out-trigger', '#footer').click(function () {
			var $trigger = $(this);
			var $allBoxes = $('.foot-right-col > .widget');
			if ($allBoxes.is(':animated')) {
				return false;
			}
			
			var thisId = $trigger.attr('id').replace('footer-widget-area-', '');
			var $thisBox = $('#' + thisId);
			if ($thisBox.is(':visible')) {
				$('.footer-pop-out-trigger').removeClass('footer-pop-active');
				$thisBox.slideUp();
			} else {
				if ($allBoxes.is(':visible')) {
					$('.footer-pop-out-trigger').removeClass('footer-pop-active');
					$allBoxes.filter(':visible').slideUp(function() {
						$trigger.addClass('footer-pop-active');
						$thisBox.slideDown();
					});
				} else {
					$trigger.addClass('footer-pop-active');
					$thisBox.slideDown();
				}
			}
			
			return false;
		});
		
		// Bind the view map button to slide down / up the map
		var $viewMapButton = $('.view-map'),
		$mapImg = $('.hidden-map'),
		$contactInfoWrap = $('.contact-info-wrap'),
		viewMapButtonText = $('.view-map').text();
		
		$viewMapButton.click(function() {
			if (!$mapImg.add($contactInfoWrap).is(':animated')) {
				if (!$mapImg.hasClass('map-visible')) {
					$contactInfoWrap.slideUp(600, function() {
						$mapImg.slideDown(600, function() {
							$mapImg.addClass('map-visible');
							$viewMapButton.text(tcrL10n.hideMap);
						});
					});
				} else {
					$mapImg.removeClass('map-visible').slideUp(600, function() {
						$contactInfoWrap.slideDown(600, function() {
							$viewMapButton.text(viewMapButtonText);
						});
					});
				}
			}
			return false;
		});
		
		// Bind links with the class "scroll-top" to scroll to the top of the page
		$('a.scroll-top').click(function () {
			if (typeof $.smoothScroll === 'function') {
				$.smoothScroll();
			}
			return false;
		});
				
		var rollovers = function (context) {
			// Create the gallery rollover effect
			if (!context) context = document;
			$('a.portfolio-thumb-link', context).append(
				$('<div class="portfolio-hover"> <span class="zoom"></span> </div>').css({ opacity: 0, display: 'block' })
			).hover(function() {
				$(this).find('.portfolio-hover').stop().fadeTo(400, 0.9);
			}, function() {
				$(this).find('.portfolio-hover').stop().fadeTo(400, 0.0);
			});
		};
		
		rollovers();
		
		// Set up lightboxes
		var lightboxes = function (context) {
			if (!context) context = document;
			
			$('.lightbox', context).each(function () {
				var href = $(this).attr('href');
				
				if (href.match(/vimeo\.com/i)) {
					if (href.match(/http(s)?:\/\/(www\.)?vimeo\.com/i)) {
						$(this).attr('href', href.replace(/(www\.)?vimeo.com/, 'player.vimeo.com/video'));
					}					
					$(this).removeClass('lightbox')
					       .addClass('lightbox-video');
				} else if (href.match(/youtube\.com/i)) {
					if (href.match(/youtube\.com\/watch/i)) {						
						href = href.replace(/watch\?v=/i, 'embed/');						
						var params = [];
						
						// Set to autoplay
						if (!href.match(/autoplay=/)) {
							params.push('autoplay=1');
						}
						
						// Set fullscreen active
						if (!href.match(/fs=/)) {
							params.push('fs=1');
						}
													                    
						if (href.match(/&/)) {
	                        href = href.replace(/&/, '?');
	                        href += '&';
	                    } else {
	                        href += '?';
	                    }
						
						params.push('wmode=transparent');
						
						href += params.join('&');
	                    
	                    $(this).attr('href', href);
					}
					$(this).removeClass('lightbox')
					   	   .addClass('lightbox-video');
				} else if (href.match(/\b.swf\b/i)) {
					$(this).removeClass('lightbox')
				   	       .addClass('lightbox-swf');
				}
			});
						
			if ($.isFunction($.fn.fancybox)) {
				// Normal lightbox
				$('.lightbox', context).each(function () {
					var $this = $(this),
					options = $this.data('options') || {};	
					
					$this.fancybox($.extend({}, {
						transitionIn: 'elastic',
						transitionOut: 'elastic',
						titlePosition: 'inside',
						padding: 1,
						titleFormat: function (title, currentArray, currentIndex, currentOpts) {
							var captionId = $(currentArray[currentIndex]).data('caption'),
							caption = $(captionId).html() || '',
							output = '';
							
							if (caption.length && currentOpts.titlePosition == 'over') {
								output += '<div id="fancybox-title-over">' + caption + '</div>';
							}
							
							return output;
						},
						titlePosition: 'over',
						onComplete: function () {
						    if (cufonEnabled && tcrL10n.font.fancybox) {
						        Cufon.replace('#fancybox-title h1, #fancybox-title h2, #fancybox-title h3', { fontFamily: tcrL10n.font.family });        
						    }
					    }
					}, options));
				});
				
				// Swf lightbox
				$('.lightbox-swf', context).each(function () {
					var $this = $(this),
					options = $this.data('options') || {};	
					
					$this.fancybox($.extend({}, {
						transitionIn: 'elastic',
						transitionOut: 'fade',  // elastic is not good here
						titlePosition: 'inside',
						padding: 1,
						type: 'swf',
						swf: { wmode: 'transparent', autoplay: 'true', allowFullScreen: 'true' },
						width: 640,
						height: 385
					}, options));
				});
				
				// Video lightbox (iframe - Vimeo, YouTube etc)
				$('.lightbox-video', context).each(function () {
					var $this = $(this),
					options = $this.data('options') || {};	
					
					$this.fancybox($.extend({}, {
						transitionIn: 'elastic',
						transitionOut: 'fade',  // elastic is not good here
						titlePosition: 'inside',
						padding: 1,
						type: 'iframe',
						width: 640,
						height: 360
					}, options));
				});
			}
			
			if ($.isFunction($.fn.serene)) {
				$('.serene', context).each(function () {
					var $this = $(this),
					options = $this.data('options') || {};
					
					$this.serene($.extend({
						captionEnhancement: function ($captionOuter) {
						    if (cufonEnabled && tcrL10n.font.serene) {
                                Cufon.replace('.serene-caption h1, .serene-caption h2, .serene-caption h3', { fontFamily: tcrL10n.font.family });        
                            }						
						}
					}, tcrL10n.sereneOptions, options));
				});
			}
		};
		
		lightboxes();
		
		if ($.isFunction($.fn.fancybox)) {
			// Default WP gallery lightbox
			$('.gallery').each(function(index) {
				var rel = 'gallery-group-' + index;
				$(this).find('.gallery-icon > a').each(function () {
				    var $this = $(this),
				    href = $this.attr('href') || '';
				    
				    if (href && /\.(jpe?g|gif|png)$/i.test(href)) { // Match only image files
    				    $this.attr('rel', rel).fancybox({
    						transitionIn: 'elastic',
    						transitionOut: 'elastic',
    						titlePosition: 'inside',
    						padding: 1,
    						titleFormat: function (title, currentArray, currentIndex, currentOpts) {
    							var captionId = $(currentArray[currentIndex]).data('caption'),
    							caption = $(captionId).html() || '',
    							output = '';
    							
    							if (caption.length && currentOpts.titlePosition == 'over') {
    								output += '<div id="fancybox-title-over">' + caption + '</div>';
    							}
    							
    							return output;
    						},
    						titlePosition: 'over',
    						onComplete: function () {
    						    if (cufonEnabled && tcrL10n.font.fancybox) {
                                    Cufon.replace('#fancybox-title h1, #fancybox-title h2, #fancybox-title h3', { fontFamily: tcrL10n.font.family });        
                                }
    					    }						
    					});
				    }
				});
			});
		}
						
		// Portfolio
		$('.portfolio').each(function () {
			// Portfolio Quicksand filter
			var $portfolio = $(this),
			$portfolioItems = $('.portfolio-items', $portfolio),
			portfolioOptions = $portfolio.data('options') || {};
						
			if (portfolioOptions.sortable && typeof $.fn.quicksand === 'function' && $('.portfolio-filter', $portfolio).length) {		
				var $data = $('.portfolio-items', $portfolio).clone();
				
				$('.portfolio-filter a', $portfolio).click(function () {
					var $clicked = $(this),
					filter = '' + $clicked.data('filter');
					
					$('.portfolio-filter a', $portfolio).removeClass('active-filter');
					
					if (filter == 'all') {
						var $filteredData = $data.find('.portfolio-item');
					} else {
						var $filteredData = $data.find('.portfolio-item').filter(function () {
							var types = $(this).data('types').split(',');
							return $.inArray(filter, types) > -1;
						});
					}

					$portfolioItems.quicksand($filteredData, {
					    duration: 800,
					    easing: 'easeInOutQuad',
					    enhancement: function () {
					        if (cufonEnabled && tcrL10n.font.portfolio) {
                                Cufon.replace($('.portfolio-item-title', $portfolio), { fontFamily: tcrL10n.font.family });        
                            }
						}
					}, function () {
						lightboxes($portfolioItems);
						rollovers($portfolioItems);
					});
					
					$clicked.addClass('active-filter');
					return false;
				});
			}
		});
		
		$('a.external').click(function () {
		    var h = $(this).attr('href');		    
		    if (h) {
		        window.open(h);
		    }
		    return false;
		});
		
		$('a.popup-link').attr('target', '_blank');
		
		if ($.isFunction($.fn.qtip)) {
		    $('.tooltip').qtip({
                text: false,
                style: {
                    classes: 'ui-tooltip-storm ui-tooltip-dark',
					border: { color: '#000000' },
					tip: {
					    color: 'false'
					}
                },
                position: {
                    my: 'bottom center',
                    at: 'top center'
                }
            });
		}
		
		// Comment form inside labels
		if ($.isFunction($.fn.inFieldLabels)) {
    		$('#commentform').find('.inside-label').each(function (i) {
                var $root = $(this),
                $label = $root.find('> label');

                $label.inFieldLabels();
            });
		}
		
	}); // End (document).ready
	
	$(window).load(function () {
	    // Generic sliders
        if ($.isFunction($.fn.cycle)) {
            $('.cycle').each(function () {
                var $root = $(this),
                    $slidesWrap = $root.find('.cycle-slides'),
                    $slides = $slidesWrap.children(),
                    $next = $root.find('.cycle-forward'),
                    $prev = $root.find('.cycle-backward'),
                    options = $root.data('options') || {};
                    
                $slides.each(function () {
                    $(this).width($(this).actual('width'));
                });

                if ($slidesWrap.children().length) {
                    $slidesWrap.cycle($.extend({}, {
                        next: $next,
                        prev: $prev,
                        fx: 'fade',
                        speedOut: 1,
                        cleartype: true,
                        cleartypeNoBg: true,
                        timeout: 0
                    }, options));
                }
            });
        }
        
        // Image preloading
        $.preloadImages([
             '/images/nav-a-bg1.png',
             '/images/search1.png',
             '/images/opacity-60-rep.png',
             '/images/portfolio-image-hover.png',
             '/images/portfolio-image-hover-small.png',
             '/images/backward1.png',
             '/images/play1.png',
             '/images/pause1.png',
             '/images/forward1.png',
             '/images/fs-max1.png',
             '/images/no-sound1.png',
             '/images/sound1.png',
             '/images/mini-slider-arrow-right-hover.png',
             '/images/mini-slider-arrow-left-hover.png',
             '/images/backward1.png',
             '/images/backward1.png',
             '/images/backgrounds/transparent/plain-dark-80.png',
             '/images/backgrounds/transparent/plain-dark-90.png',
             '/images/loading.gif',
             '/images/serene-back.png',
             '/images/serene-play.png',
             '/images/serene-pause.png',
             '/images/serene-forward.png',
             '/images/close-icon.png',
             '/images/close-icon-hover.png',
             '/images/fs-bullet.png',
             '/images/fs-bullet-hover.png',
             '/images/fs-bullet-on.png'
         ], tcrL10n.themeUrl);
	});	
})(jQuery, window);