<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Twitter widget
 */
class TCR_Widget_Twitter extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'widget_tcr_twitter', 'description' => __('Twitter feed', TCR_ADMIN_TEXT_DOMAIN));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('tcr_twitter', TCR_NAME . ' - ' . __('Twitter', TCR_ADMIN_TEXT_DOMAIN), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
	    global $tcr;

		extract($args);
		$title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);
		$instance['retweets'] = $instance['retweets'] ? 'false' : 'true';

        if (strlen($instance['username'])) {
    		echo $before_widget;
    		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; } ?>
    			<div class="tcr-twitter-widget">
    			    <div id="<?php echo $widget_id; ?>-feed"></div>
    			    <?php if ($instance['show_follow_button']) : ?>
    			    <div class="follow-me-button">
    			        <a href="http://twitter.com/<?php echo urlencode($instance['username'])?>" class="button-press"><?php echo esc_html($instance['follow_button_text']); ?></a>
			        </div>
			        <?php endif; ?>
    			</div>
    			<?php ob_start(); ?>
    			jQuery(document).ready(function ($) {
    			    if ($.isFunction($.fn.tweet)) {
        			    $('#<?php echo $widget_id; ?>-feed').tweet({
        			        username: '<?php echo esc_js($instance['username']); ?>',
        			        count: <?php echo $instance['count']; ?>,
        			        template: '{text} <span class="tweet-time">{time}</span>',
        			        retweets: <?php echo $instance['retweets']; ?>,
        			        loading_text: '<?php echo esc_js($instance['loading_text']); ?>'
        			    });
    			    }
    			});
    		<?php
    		tcr_add_footer_js(ob_get_clean());
    		$tcr['twitter'] = true;
    		echo $after_widget;
        }
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['username'] = trim(strip_tags($new_instance['username']));
		$instance['count'] = absint($new_instance['count']);
		$instance['retweets'] = isset($new_instance['retweets']) ? true : false;
		$instance['loading_text'] = trim(strip_tags($new_instance['loading_text']));
		$instance['show_follow_button'] = isset($new_instance['show_follow_button']) ? true : false;
		$instance['follow_button_text'] = trim(strip_tags($new_instance['follow_button_text']));
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args((array) $instance, array(
		    'title' => tcr__('twitter', __('Twitter', TCR_TEXT_DOMAIN)),
		    'username' => '',
		    'count' => 3,
		    'retweets' => true,
		    'loading_text' => tcr__('loading_tweets', __('Loading tweets...', TCR_TEXT_DOMAIN)),
		    'show_follow_button' => true,
		    'follow_button_text' =>  tcr__('follow_me', __('Follow Me', TCR_TEXT_DOMAIN)),
	    ));
?>
        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('username'); ?>"><?php esc_html_e('Username', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-150" id="<?php echo $this->get_field_id('username'); ?>" name="<?php echo $this->get_field_name('username'); ?>" type="text" value="<?php echo esc_attr($instance['username']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('count'); ?>"><?php esc_html_e('Number of tweets', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-50" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>" type="text" value="<?php echo esc_attr($instance['count']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('retweets'); ?>"><?php esc_html_e('Include retweets', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input id="<?php echo $this->get_field_id('retweets'); ?>" name="<?php echo $this->get_field_name('retweets'); ?>" type="checkbox" <?php checked($instance['retweets'], true); ?> value="1" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('loading_text'); ?>"><?php esc_html_e('Loading text', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('loading_text'); ?>" name="<?php echo $this->get_field_name('loading_text'); ?>" type="text" value="<?php echo esc_attr($instance['loading_text']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('show_follow_button'); ?>"><?php esc_html_e('Show follow button', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input id="<?php echo $this->get_field_id('show_follow_button'); ?>" name="<?php echo $this->get_field_name('show_follow_button'); ?>" type="checkbox" <?php checked($instance['show_follow_button'], true); ?> value="1" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('follow_button_text'); ?>"><?php esc_html_e('Follow button text', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('follow_button_text'); ?>" name="<?php echo $this->get_field_name('follow_button_text'); ?>" type="text" value="<?php echo esc_attr($instance['follow_button_text']); ?>" />
            </div>
        </div>
<?php
	}
}