<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Text widget class with shortcodes generator
 */
class TCR_Widget_Text extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'widget_tcr_text', 'description' => __('Arbitrary text, HTML or shortcodes', TCR_ADMIN_TEXT_DOMAIN));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('tcr_text', TCR_NAME . ' - ' . __('Shortcode', TCR_ADMIN_TEXT_DOMAIN), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);

		$title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);

		echo $before_widget;
		if ( !empty( $instance['title'] ) ) { echo $before_title . $title . $after_title; } ?>
			<div class="tcr-text-widget"><?php echo do_shortcode($instance['text']); ?></div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);

		if (current_user_can('unfiltered_html')) {
			$instance['text'] = $new_instance['text'];
		} else {
			$instance['text'] = stripslashes(wp_filter_post_kses(addslashes($new_instance['text']))); // wp_filter_post_kses() expects slashed
		}

		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args((array) $instance, array(
		    'title' => '',
		    'text' => ''
	    ));
?>
        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </div>
        </div>
        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label tcr-clearfix">
                <label for="<?php echo $this->get_field_id('text'); ?>"><?php esc_html_e('Content', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                <div class="tcr-widget-insert-shortcode"><?php tcr_insert_shortcode_button($this->get_field_id('text')); ?></div>
            </div>
            <div class="tcr-widgetfield-input">
		        <textarea class="widefat" rows="16" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo _wp_specialchars($instance['text'], ENT_NOQUOTES, false, true); ?></textarea>
                <p class="tcr-widgetfield-description"><?php esc_html_e('Enter the widget content HTML and/or shortcodes', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>
<?php
	}
}