<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Social icons widget
 */
class TCR_Widget_Social extends WP_Widget {

    var $socials = array(
        'audioboo' => 'AudioBoo',
        'bebo' => 'Bebo',
        'behance' => 'Behance',
        'blogger' => 'Blogger',
        'creativecommons' => 'CreativeCommons',
        'dailybooth' => 'DailyBooth',
        'delicious' => 'Delicious',
        'designfloat' => 'DesignFloat',
        'deviantart' => 'deviantART',
        'digg' => 'Digg',
        'dopplr' => 'Dopplr',
        'dribbble' => 'Dribbble',
        'email' => 'Email',
        'ember' => 'Ember',
        'facebook' => 'Facebook',
        'flickr' => 'Flickr',
        'forrst' => 'Forrst',
        'friendfeed' => 'FriendFeed',
        'google' => 'Google',
        'gowalla' => 'Gowalla',
        'grooveshark' => 'Grooveshark',
        'hyves' => 'Hyves',
        'lastfm' => 'Last.fm',
        'linkedin' => 'LinkedIn',
        'livejournal' => 'LiveJournal',
        'lockerz' => 'Lockerz',
        'myspace' => 'MySpace',
        'piano' => 'Piano',
        'playfire' => 'Playfire',
        'playstation' => 'PlayStation',
        'reddit' => 'Reddit',
        'rss' => 'RSS',
        'skype' => 'Skype',
        'socialvibe' => 'SocialVibe',
        'soundcloud' => 'SoundCloud',
        'spotify' => 'Spotify',
        'steam' => 'Steam',
        'stumbleupon' => 'StumbleUpon',
        'technorati' => 'Technorati',
        'tumblr' => 'Tumblr',
        'twitpic' => 'Twitpic',
        'twitter' => 'Twitter',
        'typepad' => 'Typepad',
        'vimeo' => 'Vimeo',
        'wakoopa' => 'Wakoopa',
        'wordpress' => 'WordPress',
        'xing' => 'Xing',
        'yahoo' => 'Yahoo!',
        'youtube' => 'YouTube'
    );

	function __construct() {
		$widget_ops = array('classname' => 'widget_tcr_social', 'description' => __('Social icons and links', TCR_ADMIN_TEXT_DOMAIN));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('tcr_social', TCR_NAME . ' - ' . __('Social Icons', TCR_ADMIN_TEXT_DOMAIN), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);
		$instance['popup'] = $instance['popup'] ? 'class="external"' : '';

		echo $before_widget;
		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; } ?>
			<div class="tcr-social-widget clearfix">
			    <?php foreach ($this->socials as $key => $name) : ?>
			        <?php if ($instance[$key]) : ?>
			        <div class="one-icon-wrap">
			            <a <?php echo $instance['popup']; ?> href="<?php echo esc_url($instance[$key]); ?>">
			                <img src="<?php echo TCR_URL . '/images/social-icons/' . $key . '.png'; ?>" alt="<?php echo esc_attr($name); ?>" />
			            </a>
			        </div>
			        <?php endif; ?>
			    <?php endforeach; ?>
			</div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['popup'] = $new_instance['popup'];
		foreach ($this->socials as $key => $name) {
		    $instance[$key] = $new_instance[$key];
		}
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args((array) $instance, array(
		    'title' => tcr__('social_links', __('Social Links', TCR_TEXT_DOMAIN)),
		    'popup' => 'popup'
	    ));
?>
        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('popup'); ?>"><?php esc_html_e('Link target', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <select id="<?php echo $this->get_field_id('popup'); ?>" name="<?php echo $this->get_field_name('popup'); ?>">
        		    <option value="" <?php selected($instance['popup'], ''); ?>><?php esc_html_e('Same window', TCR_ADMIN_TEXT_DOMAIN); ?></option>
        		    <option value="popup" <?php selected($instance['popup'], 'popup'); ?>><?php esc_html_e('New tab', TCR_ADMIN_TEXT_DOMAIN); ?></option>
        		</select>
            </div>
        </div>

	    <table class="tcr-widgetfield-table widefat">
	        <tr>
	            <th colspan="2"><?php esc_html_e('Network', TCR_ADMIN_TEXT_DOMAIN); ?></th>
	            <th><?php esc_html_e('URL', TCR_ADMIN_TEXT_DOMAIN); ?></th>
	        </tr>
		<?php foreach ($this->socials as $key => $name) : ?>
		    <?php $value = isset($instance[$key]) ? $instance[$key] : ''; ?>
		    <tr>
		        <td><?php echo tcr_get_image_tag(tcr_get_image_src(TCR_URL . '/images/social-icons/' . $key . '.png', array('width' => 25, 'height' => 25))); ?></td>
    		    <td><label for="<?php echo $this->get_field_id($key); ?>"><?php echo $name; ?></label></td>
    		    <td><input class="widefat" id="<?php echo $this->get_field_id($key); ?>" name="<?php echo $this->get_field_name($key); ?>" type="text" value="<?php echo esc_attr($value); ?>" /></td>
		    </tr>
	    <?php endforeach; ?>
		</table>
<?php
	}
}