<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Opening times widget
 */
class TCR_Widget_Opening extends WP_Widget {
    var $days;

	function __construct() {
		$widget_ops = array('classname' => 'widget_tcr_opening', 'description' => __('Display business opening times', TCR_ADMIN_TEXT_DOMAIN));
		$control_ops = array('width' => 400, 'height' => 350);
		$this->days = array(
            'monday' => __('Monday', TCR_ADMIN_TEXT_DOMAIN),
            'tuesday' => __('Tuesday', TCR_ADMIN_TEXT_DOMAIN),
            'wednesday' => __('Wednesday', TCR_ADMIN_TEXT_DOMAIN),
            'thursday' => __('Thursday', TCR_ADMIN_TEXT_DOMAIN),
            'friday' => __('Friday', TCR_ADMIN_TEXT_DOMAIN),
            'saturday' => __('Saturday', TCR_ADMIN_TEXT_DOMAIN),
            'sunday' => __('Sunday', TCR_ADMIN_TEXT_DOMAIN)
        );
		parent::__construct('tcr_opening', TCR_NAME . ' - ' . __('Opening Times', TCR_ADMIN_TEXT_DOMAIN), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);

		$title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);

		echo $before_widget;
		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; } ?>
			<div class="tcr-opening-times-widget clearfix">
			    <?php
			    if ($instance['before']) {
			        echo do_shortcode($instance['before']);
			    }
			    ?>
                <div class="opening-times-wrap clearfix">
                    <?php foreach ($this->days as $key => $day) : ?>
                        <?php if (!$instance["hide_$key"]) : ?>
                            <div class="opening-times clearfix">
                                <div class="one-day">
                                    <?php echo esc_html($day); ?>
                                </div>
                                <div class="open-time">
                                    <?php echo esc_html($instance[$key]); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
                <?php
			    if ($instance['after']) {
			        echo do_shortcode($instance['after']);
			    }
			    ?>
			</div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['before'] = $new_instance['before'];
		$instance['monday'] = $new_instance['monday'];
		$instance['tuesday'] = $new_instance['tuesday'];
		$instance['wednesday'] = $new_instance['wednesday'];
		$instance['thursday'] = $new_instance['thursday'];
		$instance['friday'] = $new_instance['friday'];
		$instance['saturday'] = $new_instance['saturday'];
		$instance['sunday'] = $new_instance['sunday'];
		$instance['hide_monday'] = isset($new_instance['hide_monday']) ? true : false;
		$instance['hide_tuesday'] = isset($new_instance['hide_tuesday']) ? true : false;
		$instance['hide_wednesday'] = isset($new_instance['hide_wednesday']) ? true : false;
		$instance['hide_thursday'] = isset($new_instance['hide_thursday']) ? true : false;
		$instance['hide_friday'] = isset($new_instance['hide_friday']) ? true : false;
		$instance['hide_saturday'] = isset($new_instance['hide_saturday']) ? true : false;
		$instance['hide_sunday'] = isset($new_instance['hide_sunday']) ? true : false;
		$instance['after'] = $new_instance['after'];
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args((array) $instance, array(
		    'title' => tcr__('opening_times', __('Opening Times', TCR_TEXT_DOMAIN)),
		    'before' => '',
		    'after' => ''
	    ));
?>
        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('before'); ?>"><?php esc_html_e('Text/HTML before opening times', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <textarea class="widefat" id="<?php echo $this->get_field_id('before'); ?>" name="<?php echo $this->get_field_name('before'); ?>"><?php echo _wp_specialchars($instance['before'], ENT_NOQUOTES, false, true); ?></textarea>
                <p class="tcr-widgetfield-description"><?php esc_html_e('Custom HTML to be displayed before the opening times. Shortcodes can be used here.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <table class="tcr-widgetfield-table widefat">
	        <tr>
	            <th><?php esc_html_e('Day', TCR_ADMIN_TEXT_DOMAIN); ?></th>
	            <th><?php esc_html_e('Opening times', TCR_ADMIN_TEXT_DOMAIN); ?></th>
	        </tr>
            <?php foreach ($this->days as $key => $day) : ?>
                <?php
                    if (!isset($instance[$key])) {
                        $instance[$key] = '';
                    }
                    if (!isset($instance["hide_$key"])) {
                        $instance["hide_$key"] = false;
                    }
                ?>
    		    <tr>
        		    <td><label for="<?php echo $this->get_field_id($key); ?>"><?php echo $day; ?></label></td>
        		    <td><input class="tcr-width-150" id="<?php echo $this->get_field_id($key); ?>" name="<?php echo $this->get_field_name($key); ?>" type="text" value="<?php echo esc_attr($instance[$key]); ?>" />
        		    <label><?php esc_html_e('Hide day?', TCR_ADMIN_TEXT_DOMAIN); ?> <input id="<?php echo $this->get_field_id("hide_$key"); ?>" name="<?php echo $this->get_field_name("hide_$key"); ?>" type="checkbox" value="1" <?php checked($instance["hide_$key"], true); ?> /></label></td>
    		    </tr>
            <?php endforeach; ?>
		</table>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('after'); ?>"><?php esc_html_e('Text/HTML after opening times', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <textarea class="widefat" id="<?php echo $this->get_field_id('after'); ?>" name="<?php echo $this->get_field_name('after'); ?>"><?php echo _wp_specialchars($instance['after'], ENT_NOQUOTES, false, true); ?></textarea>
                <p class="tcr-widgetfield-description"><?php esc_html_e('Custom HTML to be displayed after the opening times. Shortcodes can be used here.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>
<?php
	}
}