<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Facebook widget
 */
class TCR_Widget_Facebook extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'widget_tcr_facebook', 'description' => __('Facebook plugin with stream and Like box', TCR_ADMIN_TEXT_DOMAIN));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('tcr_facebook', TCR_NAME . ' - ' . __('Facebook', TCR_ADMIN_TEXT_DOMAIN), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
	    global $tcr;
	    $tcr['facebook'] = true;
	    $style = array();

		extract($args);
		$title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);

		$attributes['href'] = $instance['url'];

	    if ($instance['colorscheme'] == 'dark') {
	        $attributes['colorscheme'] = 'dark';
	        $wrapClass = 'fb-theme-dark';
	    } else {
	        $wrapClass = 'fb-theme-light';
	    }

	    if (strlen($instance['width'])) {
	        $attributes['width'] = $instance['width'];
	        $style[] = 'width:' . $attributes['width'] . 'px;';
	    }

	    if (strlen($instance['height'])) {
	        $attributes['height'] = $instance['height'];
	        $style[] = 'height:' . $attributes['height'] . 'px;';
	    }

	    if ($instance['show_faces']) {
	        $attributes['show_faces'] = 'true';
	    } else {
	        $attributes['show_faces'] = 'false';
	    }

	    if (strlen($instance['border_color'])) {
	        $attributes['border_color'] = $instance['border_color'];
	    }

	    if ($instance['stream']) {
	        $attributes['stream'] = 'true';
	    } else {
	        $attributes['stream'] = 'false';
	    }

	    if ($instance['header']) {
	        $attributes['header'] = 'true';
	    } else {
	        $attributes['header'] = 'false';
	    }

		echo $before_widget;
		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; } ?>
			<div class="tcr-facebook-widget <?php echo $wrapClass; ?> clearfix">
			    <iframe src="//www.facebook.com/plugins/likebox.php?<?php echo http_build_query($attributes, null, '&amp;'); ?>" scrolling="no" frameborder="0" style="border:none; overflow:hidden; <?php echo join(' ', $style); ?>" allowTransparency="true"></iframe>
		    </div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['url'] = $new_instance['url'];
		$instance['colorscheme'] = $new_instance['colorscheme'];
		$instance['width'] = strlen($new_instance['width']) ? absint($new_instance['width']) : '';
		$instance['height'] = strlen($new_instance['height']) ? absint($new_instance['height']) : '';
		$instance['show_faces'] = isset($new_instance['show_faces']) ? true : false;
		$instance['border_color'] = substr(preg_replace('/[^A-Fa-f0-9]/', '', $new_instance['border_color']), 0, 6);
		$instance['stream'] = isset($new_instance['stream']) ? true : false;
		$instance['header'] = isset($new_instance['header']) ? true : false;
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args((array) $instance, array(
		    'title' => tcr__('facebook', __('Facebook', TCR_TEXT_DOMAIN)),
		    'url' => '',
		    'colorscheme' => 'dark',
		    'width' => '240',
		    'height' => '590',
		    'show_faces' => true,
		    'border_color' => '',
		    'stream' => true,
		    'header' => false
	    ));
?>
        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('url'); ?>"><?php esc_html_e('URL', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('url'); ?>" name="<?php echo $this->get_field_name('url'); ?>" type="text" value="<?php echo esc_attr($instance['url']); ?>" />
                <p class="tcr-widgetfield-description"><?php esc_html_e('The URL of the Facebook Page for this Like box.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('colorscheme'); ?>"><?php esc_html_e('Color scheme', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <select id="<?php echo $this->get_field_id('colorscheme'); ?>" name="<?php echo $this->get_field_name('colorscheme'); ?>">
        		    <option value="" <?php selected($instance['colorscheme'], ''); ?>><?php esc_html_e('Light', TCR_ADMIN_TEXT_DOMAIN); ?></option>
        		    <option value="dark" <?php selected($instance['colorscheme'], 'dark'); ?>><?php esc_html_e('Dark', TCR_ADMIN_TEXT_DOMAIN); ?></option>
        	    </select>
        	    <p class="tcr-widgetfield-description"><?php esc_html_e('The color scheme of the plugin. Note that the background is always transparent to match your background color. This setting changes the foreground colors to work well on light or dark backgrounds.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('width'); ?>"><?php esc_html_e('Width', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-50" id="<?php echo $this->get_field_id('width'); ?>" name="<?php echo $this->get_field_name('width'); ?>" type="text" value="<?php echo esc_attr($instance['width']); ?>" />
                <p class="tcr-widgetfield-description"><?php esc_html_e('The width of the plugin in pixels. Use 240 for sidebar widget, 217 for footer widget.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('height'); ?>"><?php esc_html_e('Height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-50" id="<?php echo $this->get_field_id('height'); ?>" name="<?php echo $this->get_field_name('height'); ?>" type="text" value="<?php echo esc_attr($instance['height']); ?>" />
                <p class="tcr-widgetfield-description"><?php esc_html_e('The height of the plugin in pixels. 590 is the default with all features enabled, if you remove some features you may want to reduce the height.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('show_faces'); ?>"><?php esc_html_e('Show faces', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input id="<?php echo $this->get_field_id('show_faces'); ?>" name="<?php echo $this->get_field_name('show_faces'); ?>" type="checkbox" value="1" <?php checked($instance['show_faces'], true); ?> />
                <p class="tcr-widgetfield-description"><?php esc_html_e('Show profile photos in the plugin.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('border_color'); ?>"><?php esc_html_e('Border color', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        #<input id="<?php echo $this->get_field_id('border_color'); ?>" name="<?php echo $this->get_field_name('border_color'); ?>" type="text" value="<?php echo esc_attr($instance['border_color']); ?>" />
                <p class="tcr-widgetfield-description"><?php esc_html_e('The border color of the plugin. Hex color code.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('stream'); ?>"><?php esc_html_e('Show stream', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input id="<?php echo $this->get_field_id('stream'); ?>" name="<?php echo $this->get_field_name('stream'); ?>" type="checkbox" value="1" <?php checked($instance['stream'], true); ?> />
                <p class="tcr-widgetfield-description"><?php esc_html_e('Show the profile stream for the public profile.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

		<div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('header'); ?>"><?php esc_html_e('Show header', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="widefat" id="<?php echo $this->get_field_id('header'); ?>" name="<?php echo $this->get_field_name('header'); ?>" type="checkbox" value="1" <?php checked($instance['show_faces'], true); ?> />
                <p class="tcr-widgetfield-description"><?php esc_html_e("Show the 'Find us on Facebook' bar at top. Only shown when either stream or faces are present.", TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>
<?php
	}
}

add_action('tcr_body_end', 'tcr_facebook_footer');

function tcr_facebook_footer()
{
    global $tcr;
    if (isset($tcr['facebook'])) : ?>
<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>
    <?php endif;
}