<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Contact details widget
 */
class TCR_Widget_Contact extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'widget_tcr_opening', 'description' => __('Display contact details', TCR_ADMIN_TEXT_DOMAIN));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('tcr_contact', TCR_NAME . ' - ' . __('Contact Details', TCR_ADMIN_TEXT_DOMAIN), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);
		$title = empty($instance['title']) ? '' : $instance['title'];

		echo $before_widget;
		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; } ?>
			<div class="tcr-contact-details-widget clearfix">
			    <?php
			    if ($instance['before']) {
			        echo do_shortcode($instance['before']);
			    }
			    ?>
                <div class="contact-details-wrap clearfix">
                    <?php if ($instance['phone']) : ?>
                        <div class="contact-details clearfix">
                            <div class="method phone">
                                <?php esc_html_e('Phone', TCR_ADMIN_TEXT_DOMAIN); ?>
                            </div>
                            <div class="details">
                                <?php echo esc_html($instance['phone']); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($instance['fax']) : ?>
                        <div class="contact-details clearfix">
                            <div class="method fax">
                                <?php esc_html_e('Fax', TCR_ADMIN_TEXT_DOMAIN); ?>
                            </div>
                            <div class="details">
                                <?php echo esc_html($instance['phone']); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($instance['email']) : ?>
                        <div class="contact-details clearfix">
                            <div class="method email">
                                <?php esc_html_e('Email', TCR_ADMIN_TEXT_DOMAIN); ?>
                            </div>
                            <div class="details">
                                <a href="mailto:<?php echo esc_attr($instance['email']); ?>"><?php echo esc_html($instance['email']); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($instance['address']) : ?>
                        <div class="contact-details clearfix">
                            <div class="method address">
                                <?php esc_html_e('Address', TCR_ADMIN_TEXT_DOMAIN); ?>
                            </div>
                            <div class="details">
                                <?php echo nl2br($instance['address']); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <?php
			    if ($instance['after']) {
			        echo do_shortcode($instance['after']);
			    }
			    ?>
			</div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['before'] = $new_instance['before'];
		$instance['phone'] = $new_instance['phone'];
		$instance['fax'] = $new_instance['fax'];
		$instance['email'] = $new_instance['email'];
		$instance['address'] = $new_instance['address'];
		$instance['after'] = $new_instance['after'];
		return $instance;
	}

	function form( $instance ) {
	    global $tcr;

		$instance = wp_parse_args((array) $instance, array(
		    'title' => tcr__('contact_details', __('Contact Details', TCR_TEXT_DOMAIN)),
		    'before' => '',
		    'phone' => $tcr['options']['contact_phone_number'],
		    'fax' => $tcr['options']['contact_fax_number'],
		    'email' => $tcr['options']['contact_email'],
		    'address' => $tcr['options']['contact_address'],
		    'after' => ''
	    ));
?>
        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-300" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('before'); ?>"><?php esc_html_e('Text/HTML before contact details', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <textarea class="widefat" id="<?php echo $this->get_field_id('before'); ?>" name="<?php echo $this->get_field_name('before'); ?>"><?php echo _wp_specialchars($instance['before'], ENT_NOQUOTES, false, true); ?></textarea>
                <p class="tcr-widgetfield-description"><?php esc_html_e('Custom HTML to be displayed before the contact details. Shortcodes can be used here.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('phone'); ?>"><?php esc_html_e('Phone', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-150" id="<?php echo $this->get_field_id('phone'); ?>" name="<?php echo $this->get_field_name('phone'); ?>" type="text" value="<?php echo esc_attr($instance['phone']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('fax'); ?>"><?php esc_html_e('Fax', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-150" id="<?php echo $this->get_field_id('fax'); ?>" name="<?php echo $this->get_field_name('fax'); ?>" type="text" value="<?php echo esc_attr($instance['fax']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('email'); ?>"><?php esc_html_e('Email', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <input class="tcr-width-150" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo esc_attr($instance['email']); ?>" />
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('address'); ?>"><?php esc_html_e('Address', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <textarea class="widefat" id="<?php echo $this->get_field_id('address'); ?>" name="<?php echo $this->get_field_name('address'); ?>"><?php echo _wp_specialchars($instance['address'], ENT_NOQUOTES, false, true); ?></textarea>
                <p class="tcr-widgetfield-description"><?php printf(esc_html__('HTML is allowed, new lines will be converted automatically to %s', TCR_ADMIN_TEXT_DOMAIN), esc_html('<br />')); ?></p>
            </div>
        </div>

        <div class="tcr-widgetfield-wrap">
            <div class="tcr-widgetfield-label">
                <label for="<?php echo $this->get_field_id('after'); ?>"><?php esc_html_e('Text/HTML after contact details', TCR_ADMIN_TEXT_DOMAIN); ?></label>
            </div>
            <div class="tcr-widgetfield-input">
		        <textarea class="widefat" id="<?php echo $this->get_field_id('after'); ?>" name="<?php echo $this->get_field_name('after'); ?>"><?php echo _wp_specialchars($instance['after'], ENT_NOQUOTES, false, true); ?></textarea>
                <p class="tcr-widgetfield-description"><?php esc_html_e('Custom HTML to be displayed after the contact details. Shortcodes can be used here.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
            </div>
        </div>
<?php
	}
}