<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

add_action('widgets_init', 'tcr_widgets_init');

function tcr_get_sidebars()
{
    $sidebars = array(
        'page' => array(
            'name' => __('Page Sidebar', TCR_ADMIN_TEXT_DOMAIN),
            'description' => __('The sidebar widget area on pages', TCR_ADMIN_TEXT_DOMAIN)
        ),
        'blog' => array(
            'name' => __('Blog Sidebar', TCR_ADMIN_TEXT_DOMAIN),
            'description' => __('The sidebar widget area on blog articles', TCR_ADMIN_TEXT_DOMAIN)
        ),
        'portfolio' => array(
            'name' => __('Portfolio Sidebar', TCR_ADMIN_TEXT_DOMAIN),
            'description' => __('The sidebar widget area on portfolio pages', TCR_ADMIN_TEXT_DOMAIN)
        ),
        'footer' => array(
            'name' => __('Footer Boxes', TCR_ADMIN_TEXT_DOMAIN),
            'description' => __('The footer widget area with popup boxes', TCR_ADMIN_TEXT_DOMAIN)
        )
    );

    return $sidebars;
}

function tcr_widgets_init()
{
    require_once TCR_INCLUDES_DIR . '/widgets/text.php';
    require_once TCR_INCLUDES_DIR . '/widgets/twitter.php';
    require_once TCR_INCLUDES_DIR . '/widgets/social.php';
    require_once TCR_INCLUDES_DIR . '/widgets/facebook.php';
    require_once TCR_INCLUDES_DIR . '/widgets/opening-times.php';
    require_once TCR_INCLUDES_DIR . '/widgets/contact-details.php';
    require_once TCR_INCLUDES_DIR . '/widgets/related.php';
    require_once TCR_INCLUDES_DIR . '/widgets/recent.php';
    require_once TCR_INCLUDES_DIR . '/widgets/popular.php';

    // Initialise widgets
    register_widget('TCR_Widget_Text');
    register_widget('TCR_Widget_Twitter');
    register_widget('TCR_Widget_Social');
    register_widget('TCR_Widget_Facebook');
    register_widget('TCR_Widget_Opening');
    register_widget('TCR_Widget_Contact');
    register_widget('TCR_Widget_Related');
    register_widget('TCR_Widget_Recent');
    register_widget('TCR_Widget_Popular');

    // Initialise sidebars
    $sidebars = tcr_get_sidebars();
    global $tcr;

    foreach ($sidebars as $key => $sidebar) {
        $tcr['sidebars'][$key] = register_sidebar(array(
            'name' => $sidebar['name'],
            'description' => $sidebar['description'],
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        ));
    }

    // Enable shortcodes in the default text widget
    add_filter('widget_text', 'do_shortcode');
}

/**
 * Displays the sidebar
 */
function tcr_dynamic_sidebar()
{
    $sidebars = tcr_get_sidebars();

    if (is_page()) {
        $sidebar = 'page';
    } elseif (is_singular() && get_post_type() == 'portfolio') {
        $sidebar = 'portfolio';
    } elseif (tcr_is_blog()) {
        $sidebar = 'blog';
    }

    if (isset($sidebar, $sidebars[$sidebar])) {
        dynamic_sidebar($sidebars[$sidebar]['name']);
    }
}

add_action('tcr_after_content', 'tcr_get_sidebar');

/**
 * This function determines whether we should show the sidebar on the current
 * page
 */
function tcr_get_sidebar()
{
    global $tcr;
    $sidebar = true;

    if (is_404()) {
        return;
    }

    if ($tcr['layout'] == 'full-width') {
        $sidebar = false;
    }

    if ($sidebar) {
        get_sidebar();
    }
}