<?php

/**
 *  COLUMNS
 */
add_shortcode('one_half', 'tcr_shortcode_column');
add_shortcode('one_third', 'tcr_shortcode_column');
add_shortcode('one_fourth', 'tcr_shortcode_column');
add_shortcode('one_fifth', 'tcr_shortcode_column');
add_shortcode('one_sixth', 'tcr_shortcode_column');

add_shortcode('two_thirds', 'tcr_shortcode_column');
add_shortcode('three_fourths', 'tcr_shortcode_column');
add_shortcode('two_fifths', 'tcr_shortcode_column');
add_shortcode('three_fifths', 'tcr_shortcode_column');
add_shortcode('four_fifths', 'tcr_shortcode_column');
add_shortcode('five_sixths', 'tcr_shortcode_column');

add_shortcode('one_half_last', 'tcr_shortcode_column_last');
add_shortcode('one_third_last', 'tcr_shortcode_column_last');
add_shortcode('one_fourth_last', 'tcr_shortcode_column_last');
add_shortcode('one_fifth_last', 'tcr_shortcode_column_last');
add_shortcode('one_sixth_last', 'tcr_shortcode_column_last');

add_shortcode('two_thirds_last', 'tcr_shortcode_column_last');
add_shortcode('three_fourths_last', 'tcr_shortcode_column_last');
add_shortcode('two_fifths_last', 'tcr_shortcode_column_last');
add_shortcode('three_fifths_last', 'tcr_shortcode_column_last');
add_shortcode('four_fifths_last', 'tcr_shortcode_column_last');
add_shortcode('five_sixths_last', 'tcr_shortcode_column_last');

function tcr_shortcode_column($atts, $content = '', $code)
{
    return '<div class="' . $code . '">' . do_shortcode(trim($content)) . '</div>';
}

function tcr_shortcode_column_last($atts, $content = '', $code)
{
    return '<div class="' . str_replace('_last', '', $code) . ' last">' . do_shortcode(trim($content)) . '</div><div class="clear"></div>';
}

/**
 *  BLOCKQUOTE
 */
add_shortcode('blockquote', 'tcr_shortcode_blockquote');

function tcr_shortcode_blockquote($atts, $content = '')
{
    extract(shortcode_atts(array(
        'cite' => '',
        'citelink' => ''
    ), $atts));

    if ($cite) {
        $cite = $citelink ? '<a href="' . esc_url($citelink) . '" class="popup-link">' . esc_html($cite) . '</a>' : $cite;
        $cite = '<div class="cite">&ndash; ' . $cite . '</div>';
    }

    return '<blockquote><div class="blockquote-inner">' . wpautop($content) . $cite . '</div></blockquote>';
}

function tcr_render_shortcode_blockquote_options()
{
    $config = array(
        'config' => array(
            'title' => __('Blockquote options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'blockquote'
        ),
        'options' => array(
            array(
                'name' => 'enclosed_content',
                'label' => __('Quote', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'textarea',
                'default' => ''
            ),
            array(
                'name' => 'cite',
                'label' => __('Cite', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Cite is the reference to the source', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            ),
            array(
                'name' => 'citelink',
                'label' => __('Cite URL', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Add a link to the source, including http://', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  PULLQUOTE
 */
add_shortcode('pullquote', 'tcr_shortcode_pullquote');

function tcr_shortcode_pullquote($atts, $content = '')
{
    extract(shortcode_atts(array(
        'align' => 'left',
        'width' => '',
        'cite' => '',
        'citelink' => ''
    ), $atts));

    $style = $width ? ' style="width:' . $width . ';"' : '';

    if ($cite) {
        $cite = $citelink ? '<a href="' . esc_url($citelink) . '" class="popup-link">' . esc_html($cite) . '</a>' : $cite;
        $cite = '<div class="cite">&ndash; ' . $cite . '</div>';
    }

    return '<div class="pullquote align' . $align . '"' . $style . '>' . wpautop($content) . $cite . '</div>';
}

function tcr_render_shortcode_pullquote_options()
{
    $config = array(
        'config' => array(
            'title' => __('Pullquote options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'pullquote'
        ),
        'options' => array(
            array(
                'name' => 'align',
                'label' => __('Alignment', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose how the quote is aligned within the content.', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'left',
                'options' => array(
                    'left' => __('Left', TCR_ADMIN_TEXT_DOMAIN),
                    'center' => __('Center', TCR_ADMIN_TEXT_DOMAIN),
                    'right' => __('Right', TCR_ADMIN_TEXT_DOMAIN),
                )
            ),
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('The CSS width of the pullquote, e.g. %s or %s', TCR_ADMIN_TEXT_DOMAIN), '<strong>200px</strong>', '<strong>25%</strong>'),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Quote', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'textarea',
                'default' => ''
            ),
            array(
                'name' => 'cite',
                'label' => __('Cite', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Cite is the reference to the source', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            ),
            array(
                'name' => 'citelink',
                'label' => __('Cite URL', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Add a link to the source, including http://', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  BOX
 */
add_shortcode('box', 'tcr_shortcode_box');

function tcr_shortcode_box($atts, $content = '')
{
    extract(shortcode_atts(array(
        'type' => 'basic',
        'align' => '',
        'width' => ''
    ), $atts));

    $align = $align ? ' align' . $align : '';

    if ($width) {
        if (is_numeric($width)) {
            $width = $width . 'px';
        }

        $width =  ' style="width:' . $width . ';"';
    } else {
        $width = '';
    }

    return '<div class="boxed-content ' . $type . $align . '"' . $width . '><div class="boxed-content-inner">' . do_shortcode($content) . '</div></div>';
}

function tcr_render_shortcode_box_options()
{
    $config = array(
        'config' => array(
            'title' => __('Box options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'box'
        ),
        'options' => array(
            array(
                'name' => 'type',
                'label' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a style', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'basic',
                'options' => array(
                    'basic' => __('Basic', TCR_ADMIN_TEXT_DOMAIN),
                    'info' => __('Information', TCR_ADMIN_TEXT_DOMAIN),
                    'warning' => __('Warning', TCR_ADMIN_TEXT_DOMAIN),
                    'error' => __('Error', TCR_ADMIN_TEXT_DOMAIN),
                    'success' => __('Success', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'align',
                'label' => __('Alignment', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => '',
                'options' => array(
                    '' => __('None', TCR_ADMIN_TEXT_DOMAIN),
                    'left' => __('Left', TCR_ADMIN_TEXT_DOMAIN),
                    'center' => __('Center', TCR_ADMIN_TEXT_DOMAIN),
                    'right' => __('Right', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('The CSS width of the box, e.g. %s or %s', TCR_ADMIN_TEXT_DOMAIN), '<strong>200px</strong>', '<strong>25%</strong>'),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Message', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'textarea',
                'default' => ''
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  BUTTON
 */
add_shortcode('button', 'tcr_shortcode_button');

function tcr_shortcode_button($atts, $content = '')
{
    extract(shortcode_atts(array(
        'style' => 'style1',
        'popup' => '0',
        'href' => ''
    ), $atts));

    $class = $popup == '1' ? ' class="popup-link"' : '';

    return '<div class="fancy-button fancy-button-' . $style . '"><a href="' . $href . '"' . $class . '>' . $content . '</a></div>';
}

function tcr_render_shortcode_button_options()
{
    $config = array(
        'config' => array(
            'title' => __('Button options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'button',
        ),
        'options' => array(
            array(
                'name' => 'style',
                'label' => __('Style', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a style', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'style1',
                'options' => array(
                    'style1' => __('Small', TCR_ADMIN_TEXT_DOMAIN),
                    'style2' => __('Medium', TCR_ADMIN_TEXT_DOMAIN),
                    'style3' => __('Large', TCR_ADMIN_TEXT_DOMAIN),
                    'style4' => __('Huge', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'href',
                'label' => __('Link URL', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text'
            ),
            array(
                'name' => 'popup',
                'label' => __('Open link in new tab/window', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Button text', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => ''
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  LIST
 */
add_shortcode('list', 'tcr_shortcode_list');

function tcr_shortcode_list($atts, $content = '')
{
    extract(shortcode_atts(array(
        'style' => 'bullet',
        'layout' => ''
    ), $atts));

    $classes = array('fancy-list', 'fancy-list-' . $style);

    if ($layout) {
        $classes[] = $layout;
    }

    return '<div class="' . join(' ', $classes) . '">' . do_shortcode($content) . '</div>';
}

function tcr_render_shortcode_list_options()
{
    $example = "<ul>\n    <li>Example</li>\n    <li>Example</li>\n</ul>";

    $config = array(
        'config' => array(
            'title' => __('List options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'list',
        ),
        'options' => array(
            array(
                'name' => 'style',
                'label' => __('Style', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a style', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'bullet',
                'options' => array(
                    'bullet' => __('Bullet', TCR_ADMIN_TEXT_DOMAIN),
                    'tick' => __('Tick', TCR_ADMIN_TEXT_DOMAIN),
                    'arrow' => __('Arrow', TCR_ADMIN_TEXT_DOMAIN),
                    'plus' => __('Plus', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'layout',
                'label' => __('Layout', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Side by side (inline) or new line for each (stacked)', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'stacked',
                'options' => array(
                    '' => __('Stacked', TCR_ADMIN_TEXT_DOMAIN),
                    'inline' => __('Inline', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('List HTML', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter the HTML for your list, including the %s and %s tags. Example below.', TCR_ADMIN_TEXT_DOMAIN), '&lt;ul&gt;', '&lt;li&gt;'),
                'after_description' => '<pre class="tcr-sc-example">' . esc_html($example) . '</pre>',
                'type' => 'textarea',
                'default' => ''
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  MENU
 */
add_shortcode('menu', 'tcr_shortcode_menu');

function tcr_shortcode_menu($atts, $content = '')
{
    extract(shortcode_atts(array(
        'style' => 'bullet',
        'layout' => ''
    ), $atts));

    $classes = array('fancy-list', 'fancy-menu');

    if ($style) {
        $classes[] = 'fancy-list-' . $style;
    }

    if ($layout) {
        $classes[] = $layout;
    }

    return '<div class="' . join(' ', $classes) . '">' . do_shortcode($content) . '</div>';
}

function tcr_render_shortcode_menu_options()
{
    $example = "<ul>\n    <li><a href=\"http://www.example.com\">Example</a></li>\n    <li><a href=\"http://www.example.com\">Example</a></li>\n</ul>";

    $config = array(
        'config' => array(
            'title' => __('Menu options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'menu'
        ),
        'options' => array(
            array(
                'name' => 'style',
                'label' => __('Style', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a style', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'bullet',
                'options' => array(
                    '' => __('None', TCR_ADMIN_TEXT_DOMAIN),
                    'bullet' => __('Bullet', TCR_ADMIN_TEXT_DOMAIN),
                    'tick' => __('Tick', TCR_ADMIN_TEXT_DOMAIN),
                    'arrow' => __('Arrow', TCR_ADMIN_TEXT_DOMAIN),
                    'plus' => __('Plus', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'layout',
                'label' => __('Layout', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Side by side (inline) or new line for each (stacked)', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'stacked',
                'options' => array(
                    '' => __('Stacked', TCR_ADMIN_TEXT_DOMAIN),
                    'inline' => __('Inline', TCR_ADMIN_TEXT_DOMAIN)
                )

            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Menu HTML', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter the HTML for your menu, including the %s and %s tags. Example below.', TCR_ADMIN_TEXT_DOMAIN), '&lt;ul&gt;', '&lt;li&gt;'),
                'after_description' => '<pre class="tcr-sc-example">' . esc_html($example) . '</pre>',
                'type' => 'textarea',
                'default' => ''
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  TABLE
 */
add_shortcode('table', 'tcr_shortcode_table');

function tcr_shortcode_table($atts, $content = '')
{
    extract(shortcode_atts(array(
        'id' => '',
        'width' => ''
    ), $atts));

    $id = $id ? 'id="' . $id . '"' : '';

    if ($width) {
        if (is_numeric($width)) {
            $width = $width . 'px';
        }

        $width =  ' style="width:' . $width . ';"';
    } else {
        $width = '';
    }

    return '<div ' . $id . ' class="fancy-table"' . $width . '>' . do_shortcode($content) . '</div>';
}

function tcr_render_shortcode_table_options()
{
    $example = "<table>\n    <tr>\n        <th>Column 1 heading</th>\n        <th>Column 2 heading</th>\n    </tr>\n    <tr>\n        <td>Cell 1-1</td>\n        <td>Cell 1-2</td>\n    </tr>\n    <tr>\n        <td>Cell 2-1</td>\n        <td>Cell 2-2</td>\n    </tr>\n</table>";

    $config = array(
        'config' => array(
            'title' => __('Table options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'table',
        ),
        'options' => array(
            array(
                'name' => 'enclosed_content',
                'label' => __('Table HTML', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter the full HTML for your table, including the %s tag. Example below.', TCR_ADMIN_TEXT_DOMAIN), '&lt;table&gt;'),
                'after_description' => '<pre class="tcr-sc-example">' . esc_html($example) . '</pre>',
                'type' => 'textarea',
                'default' => ''
            ),
            array(
                'name' => 'id',
                'label' => __('ID', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Set the table wrapper ID for CSS/JavaScript purposes', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150'
            ),
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter a CSS width for your table e.g. %s or %s', TCR_ADMIN_TEXT_DOMAIN), '<span class="tcr-bold">300px</span>', '<span class="tcr-bold">25%</span>'),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  DROPCAP
 */
add_shortcode('dropcap', 'tcr_shortcode_dropcap');

function tcr_shortcode_dropcap($atts, $content = '')
{
    extract(shortcode_atts(array(

    ), $atts));

    return '<span class="dropcap">' . do_shortcode($content) . '</span>';
}

function tcr_render_shortcode_dropcap_options()
{
    $config = array(
        'config' => array(
            'title' => __('Dropcap options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'dropcap',
        ),
        'options' => array(
            array(
                'name' => 'enclosed_content',
                'label' => __('Dropcap character', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Enter the character you want to have as the dropcap', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-25'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  TABS
 */
add_shortcode('tabs', 'tcr_shortcode_tabs');

function tcr_shortcode_tabs($atts, $content = '')
{
    extract(shortcode_atts(array(
        'style' => 'button',
        'animation' => '',
        'width' => ''
    ), $atts));

    global $tcrTabs;
    $tcrTabs = array();

    do_shortcode($content);

    if ($width) {
        if (is_numeric($width)) {
            $width = $width . 'px';
        }

        $width =  ' style="width:' . $width . ';"';
    } else {
        $width = '';
    }

    $out = '<div class="tabs tabs-' . $style . ' ' . $animation . '"' . $width . '>';
    $out .= '<ul class="tabs-nav">';

    for ($i = 0, $c = count($tcrTabs); $i < $c; $i++) {
        $out .= '<li><a>' . $tcrTabs[$i]['title'] . '</a></li>';
    }

    $out .= '</ul>';

    for ($i = 0; $i < $c; $i++) {
        $out .= '<div class="tab-content"><div class="tab-content-inner">' . do_shortcode($tcrTabs[$i]['content']) . '</div></div>';
    }

    $out .= '</div>'; // .tabs

    unset($GLOBALS['tcrTabs']);

    return $out;
}

add_shortcode('tab', 'tcr_shortcode_tab');

function tcr_shortcode_tab($atts, $content = '')
{
    extract(shortcode_atts(array(
        'title' => ''
    ), $atts));

    global $tcrTabs;
    $tcrTabs[] = array('title' => $title, 'content' => $content);
}

function tcr_render_shortcode_tabs_options()
{
    $config = array(
        'config' => array(
            'title' => __('Tabs options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'tabs',
        ),
        'options' => array(
            array(
                'name' => 'animation',
                'label' => __('Animation', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Choose the animation of the tab transition', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'options' => array(
                    '' => __('None', TCR_ADMIN_TEXT_DOMAIN),
                    'sliding' => __('Sliding', TCR_ADMIN_TEXT_DOMAIN),
                )
            ),
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter a CSS width for your tabs e.g. %s or %s. Leave blank for full width', TCR_ADMIN_TEXT_DOMAIN), '<span class="tcr-bold">300px</span>', '<span class="tcr-bold">25%</span>'),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  TOGGLE
 */
add_shortcode('toggle', 'tcr_shortcode_toggle');

function tcr_shortcode_toggle($atts, $content = '')
{
    extract(shortcode_atts(array(
        'width' => ''
    ), $atts));

    if ($width) {
        if (is_numeric($width)) {
            $width = $width . 'px';
        }

        $width =  ' style="width:' . $width . ';"';
    } else {
        $width = '';
    }

    return '<div class="accordion toggle"' . $width . '>' . do_shortcode($content) . '</div>';
}

add_shortcode('toggle_content', 'tcr_shortcode_toggle_content');

function tcr_shortcode_toggle_content($atts, $content = '')
{
    extract(shortcode_atts(array(
        'title' => ''
    ), $atts));

    $out = '<h3><a>' . $title . '</a></h3>';
    $out .= '<div class="accordion-content-wrap"><div class="accordion-content clearfix">' . do_shortcode($content) . '</div></div>';
    return $out;
}

function tcr_render_shortcode_toggle_options()
{
    $config = array(
        'config' => array(
            'title' => __('Toggle options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'toggle',
        ),
        'options' => array(
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter a CSS width for your toggles e.g. %s or %s. Leave blank for full width', TCR_ADMIN_TEXT_DOMAIN), '<span class="tcr-bold">300px</span>', '<span class="tcr-bold">25%</span>'),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  ACCORDION
 */
add_shortcode('accordion', 'tcr_shortcode_accordion');

function tcr_shortcode_accordion($atts, $content = '')
{
    extract(shortcode_atts(array(
        'width' => ''
    ), $atts));

    if ($width) {
        if (is_numeric($width)) {
            $width = $width . 'px';
        }

        $width =  ' style="width:' . $width . ';"';
    } else {
        $width = '';
    }

    return '<div class="accordion"' . $width . '>' . do_shortcode($content) . '</div>';
}

add_shortcode('accordion_toggle', 'tcr_shortcode_accordion_toggle');

function tcr_shortcode_accordion_toggle($atts, $content = '')
{
    extract(shortcode_atts(array(
        'title' => ''
    ), $atts));

    $out = '<h3><a>' . $title . '</a></h3>';
    $out .= '<div class="accordion-content-wrap"><div class="accordion-content clearfix">' . do_shortcode($content) . '</div></div>';
    return $out;
}

function tcr_render_shortcode_accordion_options()
{
    $config = array(
        'config' => array(
            'title' => __('Accordion options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'accordion',
        ),
        'options' => array(
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter a CSS width for your accordion e.g. %s or %s. Leave blank for full width', TCR_ADMIN_TEXT_DOMAIN), '<span class="tcr-bold">300px</span>', '<span class="tcr-bold">25%</span>'),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  GALLERIA
 */
add_shortcode('galleria', 'tcr_shortcode_galleria');

function tcr_shortcode_galleria($atts, $content = '')
{
    extract(shortcode_atts(array(
        'transition' => 'fade',
        'speed' => '5000',
        'height' => '0',
        'width' => '0',
        'image_crop' => '0',
        'show_counter' => '0',
        'show_imagenav' => '0',
        'pause_on_interaction' => '1',
        'lightbox' => '0'
    ), $atts));

    global $post, $tcr;
    $tcr['galleria'] = true;

    $out = '';

    if (!isset($tcr['galleria_id'])) {
        $tcr['galleria_id'] = 0;
    }

    $galleriaId = 'galleria' . ++$tcr['galleria_id'];

    // Force height and width to be numeric
    $width = (int) $width;
    $height = (int) $height;

    // If there isn't a specified width, set it to the content area width
    if (!$width) {
        $width = $tcr['layout'] == 'full-width' ? 900 : 622;
    }

    // If there isn't a specified height, set it to 2/3 of the width
    if (!$height) {
        $height = round($width * (2/3));
    }

    if ($image_crop == '1') {
        $image_crop = 'true';
    } elseif ($image_crop == '0') {
        $image_crop = 'false';
    } else {
        $image_crop = '"' . $image_crop . '"';
    }

    $show_counter = $show_counter == '0' ? 'false' : 'true';
    $show_imagenav = $show_imagenav == '0' ? 'false' : 'true';
    $pause_on_interaction = $pause_on_interaction == '0' ? 'false' : 'true';

    if ($lightbox) {
        $lightbox = ', extend: function(options) {
    this.bind(Galleria.IMAGE, function(e) {
        jQuery(e.imageTarget).click(this.proxy(function() {
            this.openLightbox();
        }));
    });
}';
    } else {
        $lightbox = '';
    }

    $out .= '<div id="' . $galleriaId . '" class="galleria-shortcode" style="width: ' . $width . 'px; height: ' . $height . 'px;">';

    $out .= do_shortcode($content);

    $out .= '</div>';

    tcr_add_footer_js('jQuery(document).ready(function($) {
    if (!!window.Galleria) {
        Galleria.loadTheme("' . TCR_URL . '/js/galleria/themes/classic/galleria.classic.min.js");
        Galleria.run("#' . $galleriaId . '", {
            autoplay: ' . $speed . ',
            thumbCrop: true,
            imageCrop: ' . $image_crop . ',
            showCounter: ' . $show_counter . ',
            showImagenav: ' . $show_imagenav . ',
            pauseOnInteraction: ' . $pause_on_interaction . ',
            transition: "' . $transition . '"'
            . $lightbox . '
        });
    }
});');

    return $out;
}

function tcr_render_shortcode_galleria_options()
{
    $config = array(
        'config' => array(
            'title' => __('Galleria options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'galleria'
        ),
        'options' => array(
            array(
                'name' => 'transition',
                'label' => __('Transition', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Type of animation between images', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'fade',
                'options' => array(
                    'fade' => __('Fade', TCR_ADMIN_TEXT_DOMAIN),
                    'flash' => __('Flash', TCR_ADMIN_TEXT_DOMAIN),
                    'pulse' => __('Pulse', TCR_ADMIN_TEXT_DOMAIN),
                    'slide' => __('Slide', TCR_ADMIN_TEXT_DOMAIN),
                    'fadeslide' => __('Fade-slide', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'speed',
                'label' => __('Autoplay speed', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('The time to wait before changing image', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('In milliseconds, 1000 = 1 second', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '5000',
                'class' => 'tcr-width-50 tcr-range-slider',
                'attributes' => 'data-from="0" data-to="20000" data-step="100" data-dimension="' . _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN) . '"'
            ),
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The width of the gallery in pixels, if set to 0 the gallery will fill the content area', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '0',
                'class' => 'tcr-range-slider',
                'attributes' => 'data-from="0" data-to="900"'
            ),
            array(
                'name' => 'height',
                'label' => __('Height', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The height of the gallery in pixels, if set to 0 the height will be set automatically', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '0',
                'class' => 'tcr-range-slider',
                'attributes' => 'data-from="0" data-to="700"'
            ),
            array(
                'name' => 'image_crop',
                'label' => __('Image crop', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Defines how the main image will be cropped inside its container. See the %1$sGalleria documentation%2$s.', TCR_ADMIN_TEXT_DOMAIN), '<a target="_blank" href="http://galleria.io/docs/options/imageCrop/">', '</a>'),
                'type' => 'select',
                'default' => '1',
                'options' => array(
                    '0' => __('false', TCR_ADMIN_TEXT_DOMAIN),
                    '1' => __('true', TCR_ADMIN_TEXT_DOMAIN),
                    'height' => __('Height', TCR_ADMIN_TEXT_DOMAIN),
                    'width' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                    'landscape' => __('Landscape', TCR_ADMIN_TEXT_DOMAIN),
                    'portrait' => __('Portrait', TCR_ADMIN_TEXT_DOMAIN),
                )
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Image HTML', TCR_ADMIN_TEXT_DOMAIN),
                'description' => sprintf(__('Enter your image HTML. You can use the %1$s shortcode to insert images e.g.%2$s', TCR_ADMIN_TEXT_DOMAIN), '[image]', '<br /></br >[image]http://www.example.com/image.jpg[/image]</br >[image]http://www.example.com/image2.jpg[/image]'),
                'type' => 'textarea',
                'default' => ''
            ),
            array(
                'name' => 'show_counter',
                'label' => __('Show counter', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the image counter', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'show_imagenav',
                'label' => __('Show image navigation', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'pause_on_interaction',
                'label' => __('Pause on interaction', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The slideshow will pause when the user interacts with the gallery', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'lightbox',
                'label' => __('Lightbox', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Use a lightbox when the user clicks on an image', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0',
                'toggle' => 'yn'
            ),
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  IMAGE
 */
add_shortcode('image', 'tcr_shortcode_image');

function tcr_shortcode_image($atts, $content = '')
{
    extract(shortcode_atts(array(
        'width' => '',
        'height' => '',
        'alt' => '',
        'title' => '',
        'id' => '',
        'class' => ''
    ), $atts));

    $attributes = array();

    if ($alt) {
        $attributes['alt'] = $alt;
    }

    if ($title) {
        $attributes['title'] = $title;
    }

    if ($id) {
        $attributes['id'] = $id;
    }

    if ($class) {
        $attributes['class'] = $class;
    }

    if ($content) {
        if ($width == '' && $height == '') {
            // No size specified, display the raw image
            return tcr_get_image_tag($content, $attributes);
        } else {
            // Size specified, resize
            return tcr_get_image_tag(tcr_get_image_src($content, array('width' => $width, 'height' => $height)), $attributes);
        }
    }
}

function tcr_render_shortcode_image_options()
{
    $attributesExample = 'alt="My image"';

    $config = array(
        'config' => array(
            'title' => __('Image options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'image'
        ),
        'options' => array(
            array(
                'name' => 'enclosed_content',
                'label' => __('Image URL', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Enter the URL of the image.', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-400'
            ),
            array(
                'name' => 'width',
                'label' => __('Image width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Resize the image to the given width. If empty, the original image width will be used.', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '',
                'optional' => true
            ),
            array(
                'name' => 'height',
                'label' => __('Image height', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Resize the image to the given height. If empty, the original image height will be used.', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '',
                'optional' => true
            ),
            array(
                'name' => 'alt',
                'label' => __('Alt', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The alt attribute of the img tag', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            ),
            array(
                'name' => 'title',
                'label' => __('Title', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The title attribute of the img tag', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            ),
            array(
                'name' => 'id',
                'label' => __('ID', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The id attribute of the img tag', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            ),
            array(
                'name' => 'class',
                'label' => __('Class', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The class attribute of the img tag', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150',
                'optional' => true
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

add_shortcode('image_frame', 'tcr_shortcode_image_frame');

function tcr_shortcode_image_frame($atts, $content = '')
{
    extract(shortcode_atts(array(
        'type' => 'style1'
    ), $atts));

    return '<div class="image-frame ' . $type . '">' . do_shortcode($content) . '</div>';
}

function tcr_render_shortcode_image_frames_options()
{
    $example = "<img src=\"http://www.example.com/image.png\" alt=\"Image\" />";

    $config = array(
        'config' => array(
            'title' => __('Image frame options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'image_frame'
        ),
        'options' => array(
            array(
                'name' => 'type',
                'label' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a style', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'style1',
                'options' => array(
                    'style1' => __('Style 1', TCR_ADMIN_TEXT_DOMAIN),
                    'style2' => __('Style 2', TCR_ADMIN_TEXT_DOMAIN),
                    'style3' => __('Style 3', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Image HTML', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Enter your image HTML. Example below.', TCR_ADMIN_TEXT_DOMAIN),
                'after_description' => '<pre class="tcr-sc-example">' . esc_html($example) . '</pre>',
                'type' => 'textarea',
                'default' => ''
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

add_shortcode('section_break', 'tcr_shortcode_section_break');

function tcr_shortcode_section_break($atts, $content = '')
{
    extract(shortcode_atts(array(
        'type' => 'small'
    ), $atts));

    return '<div class="section-break ' . $type . '"></div>';
}

function tcr_render_shortcode_section_break_options()
{
    $config = array(
        'config' => array(
            'title' => __('Section break options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'section_break'
        ),
        'options' => array(
            array(
                'name' => 'type',
                'label' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a style', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'small',
                'options' => array(
                    'line' => __('Line', TCR_ADMIN_TEXT_DOMAIN),
                    'small' => __('Small', TCR_ADMIN_TEXT_DOMAIN),
                    'big' => __('Big', TCR_ADMIN_TEXT_DOMAIN)
                )
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

add_shortcode('fancy_header', 'tcr_shortcode_fancy_header');

function tcr_shortcode_fancy_header($atts, $content = '')
{
    extract(shortcode_atts(array(
        'type' => 'style1'
    ), $atts));

    return '<h1 class="fancy-header-' . $type . '">' . do_shortcode($content) . '</h1>';
}

function tcr_render_shortcode_fancy_header_options()
{
    $config = array(
        'config' => array(
            'title' => __('Fancy header options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'fancy_header'
        ),
        'options' => array(
            array(
                'name' => 'type',
                'label' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a style', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'style1',
                'options' => array(
                    'style1' => __('Box', TCR_ADMIN_TEXT_DOMAIN),
                    'style2' => __('Section', TCR_ADMIN_TEXT_DOMAIN),
                    'style3' => __('Underline', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Header text', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-150'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  PORTFOLIO
 */

add_shortcode('portfolio', 'tcr_shortcode_portfolio');

function tcr_shortcode_portfolio($atts, $content = '')
{
    $options = shortcode_atts(array(
        'type' => 'lightbox',
        'columns' => '3',
        'layout' => 'full',
        'categories' => '',
        'sortable' => '1',
        'show_title' => '1',
        'link_title' => '1',
        'show_description' => '1',
        'description_length' => '',
        'show_read_more' => '1',
        'read_more' => '',
        'height' => '0',
        'width' => '0',
        'paging' => '0',
        'orderby' => 'menu_order',
        'order' => 'ASC',
        'max' => -1,
        'paged' => null
    ), $atts);

    extract($options);

    global $tcr, $wp_filter;
    $the_content_filter_backup = $wp_filter['the_content'];
    $output = '';

    $imageSizes = array(
        '1' => array(
            'full' => array('width' => 900, 'height' => 563),
            'with-sidebar' => array('width' => 622, 'height' => 389),
            'widget' => array('width' => 240, 'height' => 150)
        ),
        '2' => array(
            'full' => array('width' => 440, 'height' => 275),
            'with-sidebar' => array('width' => 301, 'height' => 188),
            'widget' => array('width' => 115, 'height' => 72)
        ),
        '3' => array(
            'full' => array('width' => 293, 'height' => 183),
            'with-sidebar' => array('width' => 200, 'height' => 125),
            'widget' => array('width' => 73, 'height' => 46)
        ),
        '4' => array(
            'full' => array('width' => 217, 'height' => 136),
            'with-sidebar' => array('width' => 148, 'height' => 93),
            'widget' => array('width' => 59, 'height' => 37)
        ),
        '5' => array(
            'full' => array('width' => 172, 'height' => 108),
            'with-sidebar' => array('width' => 116, 'height' => 73),
            'widget' => array('width' => 47, 'height' => 29)
        ),
        '6' => array(
            'full' => array('width' => 141, 'height' => 88),
            'with-sidebar' => array('width' => 95, 'height' => 59),
            'widget' => array('width' => 33, 'height' => 21)
        ),
        'grid' => array(
            'full' => array('width' => 99, 'height' => 62),
            'with-sidebar' => array('width' => 76, 'height' => 48),
            'widget' => array('width' => 59, 'height' => 59)
        )
    );

    if (!in_array($layout, array('full', 'with-sidebar', 'widget'))) {
        $layout = 'full';
    }

    switch ($columns) {
        case '1':
            $columnClass = 'one-column';
            $imageSize = $imageSizes['1'][$layout];
            break;
        case '2':
            $columnClass = 'two-column';
            $imageSize = $imageSizes['2'][$layout];
            break;
        case '3':
        default:
            $columnClass = 'three-column';
            $imageSize = $imageSizes['3'][$layout];
            break;
        case '4':
            $columnClass = 'four-column';
            $imageSize = $imageSizes['4'][$layout];
            break;
        case '5':
            $columnClass = 'five-column';
            $imageSize = $imageSizes['5'][$layout];
            break;
        case '6':
            $columnClass = 'six-column';
            $imageSize = $imageSizes['6'][$layout];
            break;
        case 'grid':
            $columnClass = 'grid';
            $imageSize = $imageSizes['grid'][$layout];
            break;
    }

    if ($height) {
        $imageSize['height'] = absint($height);
    }

    // Custom excerpt length
    if ($description_length) {
        $excerptLength = new ExcerptLength($description_length);
        add_filter('excerpt_length', array($excerptLength, 'getLength'));
    }

    $classes = array('portfolio', "$type-portfolio", "portfolio-{$columnClass}", "$type-portfolio-{$columnClass}", 'clearfix');

    if ($layout == 'with-sidebar') {
        $classes[] = 'portfolio-with-sidebar';
    } elseif ($layout == 'widget') {
        $classes[] = 'portfolio-widget';
    }

    $output .= '<div class="' . join(' ', $classes) . '" data-options=\'' . esc_attr(json_encode($options)) . '\'>';

    // We can't use paging and sortable at the same time
    if ($paging == '1') {
        $sortable = '0';
    }

    $categories = $categories ? explode(',', $categories) : array();
    $filterCats = count($categories);

    if ($sortable == '1') {
        $tcr['quicksand'] = true;
        $output .= '<div class="portfolio-filter">';
        $output .= '<a class="basic-button" class="active-filter" href="#" data-filter="all"><span>' . __('All', TCR_ADMIN_TEXT_DOMAIN) . '</span></a>';

        $terms = array();
        if ($filterCats) {
            foreach ($categories as $categoryId) {
                $tmpTerm = get_term_by('id', $categoryId, 'portfolio_category');
                if ($tmpTerm != false) {
                    $terms[] = $tmpTerm;
                }
            }
        } else {
            $terms = get_terms('portfolio_category');
        }

        foreach ($terms as $term) {
            $output .= '<a class="basic-button" href="#" data-filter="' . esc_attr($term->slug) . '"><span>' . esc_html($term->name) . '</span></a>';
        }
        $output .= '</div>';
    }

    $query = array(
        'post_type' => 'portfolio',
        'orderby' => $orderby,
        'order' => $order,
        'posts_per_page' => (int) $max,
        'ignore_sticky_posts' => 1
    );

    if ($paging == '1') {
        if ($paged == null) {
            $paged = tcr_get_paged_var();
        }
        $query['paged'] = $paged;
    }

    if ($filterCats) {
        $query['tax_query'] = array(
            array(
                'taxonomy' => 'portfolio_category',
                'field' => 'id',
                'terms' => $categories
            )
        );
    }

    $items = new WP_Query($query);
    $index = 0;
    $numCols = (int) $columns;

    if (!isset($tcr['portfolio_id'])) {
        $tcr['portfolio_id'] = 1;
    }

    $baseRel = 'portfolio' . $tcr['portfolio_id'];
    $sereneVideoBaseRel = 'video' . $tcr['portfolio_id'];
    $captions = array();

    if ($items->have_posts()) {
        $output .= '<div class="portfolio-items clearfix">';

        if ($type == 'serene') {
            $tcr['serene'] = true;
        }

        while ($items->have_posts()) {
            $items->the_post();

            $terms = get_the_terms(get_the_ID(), 'portfolio_category');
            $slugs = array();
            if (is_array($terms)) {
                foreach ($terms as $term) {
                    $slugs[] = esc_attr($term->slug);
                }
            }

            $itemType = tcr_get_post_meta(get_the_ID(), 'type', 'image');

            $output .= '<div class="portfolio-item portfolio-item-type-' . $itemType . ' clearfix" data-id="' . get_the_ID() . '" data-types=\'' . join(',', $slugs) . '\'>';

            if (has_post_thumbnail()) {
                $thumbnailId = get_post_thumbnail_id();
                $thumbnailSrc = tcr_get_image_src($thumbnailId, $imageSize);
                $data = array();
                $target = '';
                $rel = $baseRel;
                $captionAttributes = array();
                $title = '';
                $imgAttributes = array();

                switch ($itemType) {
                    case 'image':
                        $popupImage = tcr_get_post_meta(get_the_ID(), 'image');
                        if (is_array($popupImage) && isset($popupImage[0]['url'])) {
                            $href = tcr_get_image_src(site_url() . $popupImage[0]['url']);
                        } else {
                            $href = tcr_get_image_src($thumbnailId);
                        }
                        $aClasses = ' ' . $type;

                        $title = tcr_get_post_meta(get_the_ID(), 'title');
                        if ($title) {
                            if ($type == 'serene') {
                                $captionAttributes[] = 'data-title="' . $title . '"';
                            } else {
                                $imgAttributes['alt'] = $title;
                            }
                        }

                        $caption = tcr_get_post_meta(get_the_ID(), 'caption');
                        if ($caption) {
                            $captionId =  'portfolio-caption-' . $tcr['portfolio_id'] . '-' . $index;
                            $captionAttributes[] = 'data-caption="#' . $captionId . '"';
                            $captions[$captionId] = $caption;
                        }

                        if ($type == 'serene') {
                            $captionPosition = tcr_get_post_meta(get_the_ID(), 'caption_position');
                            if ($captionPosition) {
                                $captionAttributes[] = 'data-caption-position="' . $captionPosition . '"';
                            }
                        }
                        break;
                    case 'video':
                        $href = tcr_get_post_meta(get_the_ID(), 'video', tcr_get_image_src($thumbnailId));
                        $data['width'] = (int) tcr_get_post_meta(get_the_ID(), 'video_width', $tcr['options']['portfolio_video_width']);
                        $data['height'] = (int) tcr_get_post_meta(get_the_ID(), 'video_height', $tcr['options']['portfolio_video_height']);
                        $aClasses = ' lightbox';
                        if ($type == 'serene') {
                            $rel = $sereneVideoBaseRel;
                        }
                        break;
                    case 'portfolio':
                        $href = get_permalink();
                        $aClasses = '';
                        break;
                    case 'link';
                    $href = tcr_get_post_meta(get_the_ID(), 'link');
                    $target = tcr_get_post_meta(get_the_ID(), 'link_target');
                    if ($target) {
                        $target = ' target="' . $target . '"';
                    }
                    $aClasses = '';
                    break;
                }

                $output .= '<div class="portfolio-image">';
                $output .= '<a class="portfolio-thumb-link' . $aClasses . '" rel="' . $rel . '" href="'.esc_url($href).'"' . $target . ' data-options=\'' . esc_attr(json_encode($data)) . '\' ' . join(' ', $captionAttributes) . '>';
                $output .= tcr_get_image_tag($thumbnailSrc, $imgAttributes);
                $output .= '</a>';
                $output .= '</div>';
            }

            $show_title = tcr_get_post_meta(get_the_ID(), 'show_title', $show_title);
            $show_description = tcr_get_post_meta(get_the_ID(), 'show_description', $show_description);
            $description = get_the_excerpt();

            if ($show_title == '1' || ($show_description == '1' && $description) || $show_read_more == '1') {
                $output .= '<div class="portfolio-details clearfix">';

                $show_title = tcr_get_post_meta(get_the_ID(), 'show_title', $show_title);
                if ($show_title == '1') {
                    if ($link_title == '1') {
                        $output .= '<h4 class="portfolio-item-title"><span><a href="' . get_permalink() . '">' . get_the_title() . '</a></span></h4>';
                    } else {
                        $output .= '<h4 class="portfolio-item-title"><span>' . get_the_title() . '</span></h4>';
                    }
                }

                $show_description = tcr_get_post_meta(get_the_ID(), 'show_description', $show_description);
                if ($show_description == '1') {
                    $output .= '<p class="portfolio-item-description">' . $description . '</p>';
                }

                if ($show_read_more == '1') {
                    $read_more = $read_more ? $read_more : tcr_get_post_meta(get_the_ID(), 'read_more', $tcr['options']['general_read_more_text']);
                    $output .= '<div class="portfolio-read-more"><a class="basic-button" href="' . get_permalink() . '">' . $read_more . '</a></div>';
                }

                $output .= '</div>'; // .portfolio-details
            }

            $output .= '</div>'; // .portfolio-item

            $index++;
        } // end while

        $output .= '</div>'; // .portfolio-items

        if ($paging == '1') {
            ob_start();
            if (function_exists('wp_pagenavi')) {
                wp_pagenavi(array(
                    'query' => $items
                ));
            } else {
                tcr_pagenavi('', '', $items, $paged);
            }
            $output .= ob_get_clean();
        }

        if (count($captions)) {
            $output .= '<div class="portfolio-captions">';
            foreach ($captions as $captionId => $captionHTML) {
                $output .= '<div id="' . $captionId . '">' . $captionHTML . '</div>';
            }
            $output .= '</div>'; // .portfolio-captions
        }
    } else {
        $output .= '<div class="portfolio-empty">' . tcr_esc_html__('no_portfolio_items', __('No portfolio items found.', TCR_TEXT_DOMAIN)) . '</div>';
    } // end have_posts()

    $output .= '</div>'; // .portfolio

    // Reset custom excerpt length
    if ($description_length) {
        remove_filter('excerpt_length', array($excerptLength, 'getLength'));
    }

    wp_reset_postdata();
    $wp_filter['the_content'] = $the_content_filter_backup;
    $tcr['portfolio_id']++;

    return $output;
}

function tcr_render_shortcode_portfolio_options()
{
    $config = array(
        'config' => array(
            'title' => __('Portfolio options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'portfolio',
            'type' => 'self-closing'
        ),
        'options' => array(
            array(
                'name' => 'type',
                'label' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Method of displaying the enlarged image', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'lightbox',
                'options' => array(
                    'lightbox' => __('Lightbox', TCR_ADMIN_TEXT_DOMAIN) . ' (Fancybox)',
                    'serene' => __('Full Screen', TCR_ADMIN_TEXT_DOMAIN) . ' (Serene)'
                )
            ),
            array(
                'name' => 'columns',
                'label' => __('Number of columns', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => '3',
                'options' => array(
                    '1' => __('One Column', TCR_ADMIN_TEXT_DOMAIN),
                    '2' => __('Two Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '3' => __('Three Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '4' => __('Four Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '5' => __('Five Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '6' => __('Six Columns', TCR_ADMIN_TEXT_DOMAIN),
                    'grid' => __('Grid', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'layout',
                'label' => __('Layout', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Select the layout of the area that will be displaying your portfolio', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('The width of the thumbnail images will be determined by your choice', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'full',
                'options' => array(
                    'full' => __('Full Width Page', TCR_ADMIN_TEXT_DOMAIN),
                    'with-sidebar' => __('Page With Sidebar', TCR_ADMIN_TEXT_DOMAIN),
                    'widget' => __('In Sidebar', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'categories',
                'label' => __('Categories', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Select one or multiple', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'multiselect',
                'default' => '',
                'options' => tcr_get_portfolio_category_options(),
                'attributes' => array('data-placeholder="' . __('Select categories', TCR_ADMIN_TEXT_DOMAIN) . '"'),
                'class' => 'tcr-chosen-multi'
            ),
            array(
                'name' => 'sortable',
                'label' => __('Sortable', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Make the portfolio sortable using QuickSand. Does not work if Paging is enabled.', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1'
            ),
            array(
                'name' => 'paging',
                'label' => __('Paging', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Portfolio items will be spread over multiple pages', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0'
            ),
            array(
                'name' => 'max',
                'label' => __('Number of items', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Number of portfolio items to show, or items per page if paging is on, -1 to show all', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '9',
                'class' => 'tcr-width-50'
            ),
            array(
                'name' => 'paged',
                'label' => __('Start page', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('If left blank it will be the first page', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'wrap_class' => 'tcr-hidden'
            ),
            array(
                'name' => 'orderby',
                'label' => __('Order by', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'menu_order',
                'options' => array(
                    'none' => __('None', TCR_ADMIN_TEXT_DOMAIN),
                    'ID' => __('ID', TCR_ADMIN_TEXT_DOMAIN),
                    'author' => __('Author', TCR_ADMIN_TEXT_DOMAIN),
                    'title' => __('Title', TCR_ADMIN_TEXT_DOMAIN),
                    'date' => __('Date', TCR_ADMIN_TEXT_DOMAIN),
                    'modified' => __('Modified', TCR_ADMIN_TEXT_DOMAIN),
                    'parent' => __('Parent', TCR_ADMIN_TEXT_DOMAIN),
                    'rand' => __('Random', TCR_ADMIN_TEXT_DOMAIN),
                    'comment_count' => __('Comment Count', TCR_ADMIN_TEXT_DOMAIN),
                    'menu_order' => __('Menu Order', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'order',
                'label' => __('Order', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'ASC',
                'options' => array(
                    'ASC' => __('ASC', TCR_ADMIN_TEXT_DOMAIN),
                    'DESC' => __('DESC', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'show_title',
                'label' => __('Show title', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the title of the portfolio item', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'link_title',
                'label' => __('Link title', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Link the portfolio title to the portfolio item page', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'show_description',
                'label' => __('Show description', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the portfolio item description (excerpt)', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'description_length',
                'label' => __('Description excerpt length', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The number of words in the description excerpt, leave blank to use the default', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            ),
            array(
                'name' => 'show_read_more',
                'label' => __('Show "Read More" button', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'read_more',
                'label' => __('"Read More" button text', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Leave blank to use the default', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => ''
            ),
            array(
                'name' => 'height',
                'label' => __('Image height', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Set the image height in pixels, if set to 0 it will be set automatically', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '0',
                'class' => 'tcr-range-slider',
                'attributes' => 'data-from="0" data-to="500"'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

function tcr_get_portfolio_category_options()
{
    $portfolioCategories = get_terms('portfolio_category', array('hide_empty' => false));
    $options = array();

    foreach($portfolioCategories as $pc) {
        $options[$pc->term_id] = $pc->name;
    }

    return $options;
}

/**
 *  BLOG SHORTCODE
 */
add_shortcode('blog', 'tcr_shortcode_blog');

function tcr_shortcode_blog($atts, $content = '')
{
    $options = shortcode_atts(array(
        'columns' => '3',
        'posts' => '',
        'categories' => '',
        'category__and' => '',
        'category__not_in' => '',
        'author' => '',
        'show_title' => '1',
        'show_meta' => '1',
        'show_date' => '',
        'show_description' => '1',
        'description_length' => '',
        'full_description' => '0',
        'show_read_more' => '1',
        'read_more' => '',
        'image' => '1',
        'image_type' => '',
        'image_width' => '0',
        'image_height' => '0',
        'paging' => '0',
        'max' => -1,
        'paged' => null,
        'offset' => 0
    ), $atts);

    extract($options);

    global $tcr, $wp_filter;
    $the_content_filter_backup = $wp_filter['the_content'];
    $output = '';

    $query = array(
        'post_type' => 'post',
        'posts_per_page' => (int) $max,
        'ignore_sticky_posts' => 1
    );

    if($posts) {
        $query['post__in'] = explode(',', $posts);
    }

    if ($categories) {
        $query['cat'] = $categories;
    }

    if ($category__and) {
        $query['category__and'] = explode(',', $category__and);
    }

    if($category__not_in) {
        $query['category__not_in'] = explode(',', $category__not_in);
    }

    if($author) {
        $query['author'] = $author;
    }

    if ((int) $offset != 0) {
        $query['offset'] = (int) $offset;
    }

    if ($paging == '1') {
        if ($paged == null) {
            $paged = tcr_get_paged_var();
        }
        $query['paged'] = $paged;

    }

    if ($image_type) {
        $featured_image_type = $image_type;
    } else {
        $featured_image_type = $tcr['options']['blog_featured_image_type'];
    }

    $columns = (int) $columns;
    if ($columns < 1) {
        $columns = 1;
    } elseif ($columns > 6) {
        $columns = 6;
    }

    $columnClasses = array('half', 'third', 'fourth', 'fifth', 'sixth');
    if ($columns != 1) {
        $class = $columnClasses[$columns - 2];
    }

    $items = new WP_Query($query);
    $index = 0;

    if ($items->have_posts()) {
        // Custom excerpt length
        if ($description_length) {
            $excerptLength = new ExcerptLength($description_length);
            add_filter('excerpt_length', array($excerptLength, 'getLength'));
        }

        $output .= '<div class="blog-shortcode-wrap clearfix">';

        while ($items->have_posts()) {
            $index++;
            $items->the_post();

            if ($columns != 1) {
                if ($index % $columns != 0) {
                    $output .= '<div class="one_' . $class . '">';
                } else {
                    $output .= '<div class="one_' . $class . ' last">';
                }
            }

            $output .= '<div id="post-' . get_the_ID() . '" class="entry entry-image-' . $featured_image_type . '">';

            if ($image == '1' && $featured_image_type != 'below') {
                $output .= tcr_blog_featured_image($featured_image_type, $image_width, $image_height);
            }

            if ($show_date == '') {
                $show_date = $tcr['options']['blog_show_date_circle'] ? '1' : '0';
            }

            if ($show_title == '1' || $show_meta == '1' || $show_date == '1') {
                $hideDate = ($show_date == '0') ? 'hide-date' : '';
                $output .= '<div class="entry-info ' . $hideDate . '">';

                if ($show_title == '1') {
                    $output .= '<h1 class="entry-title"><a href="' . get_permalink() .'" title="' . sprintf(tcr_esc_attr__('permalink_to', __('Permalink to %s', TCR_TEXT_DOMAIN)), the_title_attribute('echo=0')) . '">' . get_the_title(). '</a></h1>';
                }

                if ($show_date == '1') {
                    $output .= '<div class="date">';
                    $output .= '<div class="day"><h2>' . get_the_date('j') . '</h2></div>';
                    $output .= '<div class="month">' . get_the_date('M') . '</div>';
                    $output .= '</div>';
                }

                if ($show_meta == '1') {
                    $output .= '<div class="entry-meta">' . tcr_posted_on() . '</div>';
                }

                $output .= '</div>';
            }

            if ($image == '1' && $featured_image_type == 'below') {
                $output .= tcr_blog_featured_image($featured_image_type, $image_width, $image_height);
            }

            if ($show_description == '1') {
                $output .= '<div class="entry-content clearfix">';

                if ($full_description == '1') {
                    global $more;
                    $more = 0;
                    $content = apply_filters('the_content', get_the_content(false));
                    $content = str_replace(']]>', ']]&gt;', $content);
                    $output .= $content;
                } else {
                    $output .= apply_filters('the_excerpt', get_the_excerpt());
                }

                if ($show_read_more == '1') {
                    $read_more = $read_more ? $read_more : tcr_get_post_meta(get_the_ID(), 'read_more', $tcr['options']['general_read_more_text']);
                    $output .= '<div class="blog-read-more"><a class="basic-button" href="' . get_permalink() . '">' . $read_more . '</a></div>';
                }

                $output .= '</div>'; // .entry-content
            }

            $output .= '</div>'; // #post-#

            if ($columns != 1) {
                if ($index % $columns != 0) {
                    $output .= '</div>';
                } else {
                    $output .= '</div><div class="clear"></div>';
                }
            }
        } // end while have_posts()

        if ($paging == '1') {
            ob_start();
            if (function_exists('wp_pagenavi')) {
                wp_pagenavi(array(
                    'query' => $items
                ));
            } else {
                tcr_pagenavi('', '', $items, $paged);
            }
            $output .= ob_get_clean();
        }

        $output .= '</div>'; // .blog-shortcode-wrap

        // Reset custom excerpt length
        if ($description_length) {
            remove_filter('excerpt_length', array($excerptLength, 'getLength'));
        }
    } // end if have_posts()

    wp_reset_postdata();
    $wp_filter['the_content'] = $the_content_filter_backup;

    return $output;
}

function tcr_render_shortcode_blog_options()
{
    $config = array(
        'config' => array(
            'title' => __('Blog options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'blog',
            'type' => 'self-closing'
        ),
        'options' => array(
            array(
                'name' => 'columns',
                'label' => __('Number of columns', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => '3',
                'options' => array(
                    '1' => __('One Column', TCR_ADMIN_TEXT_DOMAIN),
                    '2' => __('Two Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '3' => __('Three Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '4' => __('Four Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '5' => __('Five Columns', TCR_ADMIN_TEXT_DOMAIN),
                    '6' => __('Six Columns', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'posts',
                'label' => __('Posts', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Shows only these specific posts', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'multiselect',
                'default' => '',
                'options' => tcr_get_all_post_options(),
                'attributes' => array('data-placeholder="' . __('Select posts', TCR_ADMIN_TEXT_DOMAIN) . '"'),
                'class' => 'tcr-chosen-multi'
            ),
            array(
                'name' => 'categories',
                'label' => __('Categories', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Select one or multiple', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Shows only posts that are in any of these categories', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'multiselect',
                'default' => '',
                'options' => tcr_get_all_category_options(),
                'attributes' => array('data-placeholder="' . __('Select categories', TCR_ADMIN_TEXT_DOMAIN) . '"'),
                'class' => 'tcr-chosen-multi'
            ),
            array(
                'name' => 'category__and',
                'label' => __('All categories', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Select one or multiple', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Shows only posts that are in all of these categories', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'multiselect',
                'default' => '',
                'options' => tcr_get_all_category_options(),
                'attributes' => array('data-placeholder="' . __('Select categories', TCR_ADMIN_TEXT_DOMAIN) . '"'),
                'class' => 'tcr-chosen-multi'
            ),
            array(
                'name' => 'category__not_in',
                'label' => __('Exclude categories', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Select one or multiple', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Do not show posts in these categories', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'multiselect',
                'default' => '',
                'options' => tcr_get_all_category_options(),
                'attributes' => array('data-placeholder="' . __('Select categories', TCR_ADMIN_TEXT_DOMAIN) . '"'),
                'class' => 'tcr-chosen-multi'
            ),
            array(
                'name' => 'author',
                'label' => __('Authors', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Select one or multiple', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Shows only posts by these authors', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'multiselect',
                'default' => '',
                'options' => tcr_get_all_author_options(),
                'attributes' => array('data-placeholder="' . __('Select authors', TCR_ADMIN_TEXT_DOMAIN) . '"'),
                'class' => 'tcr-chosen-multi'
            ),
            array(
                'name' => 'show_title',
                'label' => __('Show title', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the title of the blog post', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'show_meta',
                'label' => __('Show post meta', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the post meta data (author, date etc)', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'show_date',
                'label' => __('Show date', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the date circle', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'tritoggle',
                'default' => '',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'show_description',
                'label' => __('Show description', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the post description', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'description_length',
                'label' => __('Description excerpt length', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The number of words in the description excerpt, leave blank to use the default', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '',
                'class' => 'tcr-width-50'
            ),
            array(
                'name' => 'full_description',
                'label' => __('Full description', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('When enabled, the full post content will be shown, otherwise the excerpt will be shown', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0'
            ),
            array(
                'name' => 'show_read_more',
                'label' => __('Show "Read More" button', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'read_more',
                'label' => __('"Read More" button text', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Leave blank to use the default', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => ''
            ),
            array(
                'name' => 'image',
                'label' => __('Show image', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Show the post featured image', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '1',
                'toggle' => 'yn'
            ),
            array(
                'name' => 'image_type',
                'label' => __('Image type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Select the image positioning', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Featured image type', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => '',
                'options' => array(
                    '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
                    'below' => __('Below title (full width)', TCR_ADMIN_TEXT_DOMAIN),
                    'above' => __('Above title (full width)', TCR_ADMIN_TEXT_DOMAIN),
                    'left' => __('Float left', TCR_ADMIN_TEXT_DOMAIN),
                    'right' => __('Float right', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'image_width',
                'label' => __('Image width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The width of the featured image, set to 0 for full width', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '0',
                'class' => 'tcr-range-slider',
                'attributes' => 'data-from="0" data-to="900"'
            ),
            array(
                'name' => 'image_height',
                'label' => __('Image height', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The height of the featured image, set to 0 to automatically scale', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '0',
                'class' => 'tcr-range-slider',
                'attributes' => 'data-from="0" data-to="500"'
            ),
            array(
                'name' => 'paging',
                'label' => __('Paging', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Posts will be spread over multiple pages', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0'
            ),
            array(
                'name' => 'max',
                'label' => __('Number of posts', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Number of posts to show, or posts per page if paging is On, -1 to show all', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => -1,
                'class' => 'tcr-width-50'
            ),
            array(
                'name' => 'offset',
                'label' => __('Offset', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Number of post to displace or pass over', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'class' => 'tcr-width-50'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  CYCLE
 */
add_shortcode('cycle', 'tcr_shortcode_cycle');

function tcr_shortcode_cycle($atts, $content = '')
{
    extract(shortcode_atts(array(
        'controls' => '1',
        'fx' => 'fade',
        'speed_in' => '1000',
        'speed_out' => '0',
        'timeout' => '0',
        'width' => '0',
        'height' => '0'
    ), $atts));

    $wrapStyles = array();
    $wrapCss = '';

    $data = array(
        'fx' => $fx,
        'speedIn' => absint($speed_in),
        'speedOut' => absint($speed_out),
        'timeout' => absint($timeout)
    );

    if ($width == '0') {
        $width = '';
    }

    if ($height == '0') {
        $height = '';
    }

    if (strlen($width)) {
        if (is_numeric($width)) {
            $width .= 'px';
        }
        $data['width'] = $wrapStyles['width'] = $width;
    }

    if (strlen($height)) {
        if (is_numeric($height)) {
            $height .= 'px';
        }
        $data['height'] = $wrapStyles['height'] = $height;
    }

    if (count($wrapStyles)) {
        $wrapCss = 'style="';
        foreach ($wrapStyles as $property => $value) {
            $wrapCss .= $property . ': ' . $value . '; ';
        }
        $wrapCss = substr($wrapCss, 0, -2) . '"';
    }

    $output = '<div class="cycle" data-options=\'' . json_encode($data) . '\' '. $wrapCss .'>';

    if ($controls == '1') {
        $output .= '<div class="cycle-controls-wrap">';
        $output .= '    <div class="cycle-controls">';
        $output .= '        <a class="cycle-backward">&larr;</a>';
        $output .= '        <a class="cycle-forward">&rarr;</a>';
        $output .= '    </div>';
        $output .= '</div>';
    }

    $output .= '<div class="cycle-slides">';
    $output .= do_shortcode($content);
    $output .= '</div>'; // .cycle-slides
    $output .= '</div>'; // .cycle

    return $output;
}

add_shortcode('cycle_slide', 'tcr_shortcode_cycle_slide');

function tcr_shortcode_cycle_slide($atts, $content = '')
{
    return '<div class="cycle-slide">' . do_shortcode($content) . '</div>';
}

function tcr_render_shortcode_cycle_options()
{
    $config = array(
        'config' => array(
            'title' => __('Cycle options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'cycle'
        ),
        'options' => array(
            array(
                'name' => 'fx',
                'label' => __('Transition fx', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'fade',
                'options' => array(
                    'blindX' => 'blindX',
                    'blindY' => 'blindY',
                    'blindZ' => 'blindZ',
                    'cover' => 'cover',
                    'curtainX' => 'curtainX',
                    'curtainY' => 'curtainY',
                    'fade' => 'fade',
                    'fadeZoom' => 'fadeZoom',
                    'growX' => 'growX',
                    'growY' => 'growY',
                    'none' => 'none',
                    'scrollUp' => 'scrollUp',
                    'scrollDown' => 'scrollDown',
                    'scrollLeft' => 'scrollLeft',
                    'scrollRight' => 'scrollRight',
                    'scrollHorz' => 'scrollHorz',
                    'scrollVert' => 'scrollVert',
                    'shuffle' => 'shuffle',
                    'slideX' => 'slideX',
                    'slideY' => 'slideY',
                    'toss' => 'toss',
                    'turnUp' => 'turnUp',
                    'turnDown' => 'turnDown',
                    'turnLeft' => 'turnLeft',
                    'turnRight' => 'turnRight',
                    'uncover' => 'uncover',
                    'wipe' => 'wipe',
                    'zoom' => 'zoom',
                )
            ),
            array(
                'name' => 'speed_in',
                'label' => __('Transition "in" speed', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The speed of the "in" transition,in milliseconds, 1000 = 1 second', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '1000',
                'class' => 'tcr-width-50 tcr-range-slider',
                'attributes' => 'data-from="0" data-to="5000" data-step="100" data-dimension="' . _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN) . '"'
            ),
            array(
                'name' => 'speed_out',
                'label' => __('Transition "out" speed', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The speed of the "out" transition in milliseconds', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '0',
                'class' => 'tcr-width-50 tcr-range-slider',
                'attributes' => 'data-from="0" data-to="5000" data-step="100" data-dimension="' . _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN) . '"'
            ),
            array(
                'name' => 'timeout',
                'label' => __('Timeout', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('How long each slide should show in milliseconds, set to 0 to disable auto advance', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'default' => '0',
                'class' => 'tcr-width-50 tcr-range-slider',
                'attributes' => 'data-from="0" data-to="10000" data-step="100" data-dimension="' . _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN) . '"'
            ),
            array(
                'name' => 'width',
                'label' => __('Width', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Container width, set to 0 for full width', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '0',
                'class' => 'tcr-width-50 tcr-range-slider',
                'attributes' => 'data-from="0" data-to="900"'
            ),
            array(
                'name' => 'height',
                'label' => __('Height', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('Container height, set to 0 for auto height', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'pixel',
                'default' => '0',
                'class' => 'tcr-width-50 tcr-range-slider',
                'attributes' => 'data-from="0" data-to="500"'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  IMPACT HEADER
 */
add_shortcode('impact_header', 'tcr_shortcode_impact_header');

function tcr_shortcode_impact_header($atts, $content = '')
{
    extract(shortcode_atts(array(
        'type' => 'only-heading',
        'subheading' => '',
        'button_text' => '',
        'button_link' => '',
        'button_external' => '0'
    ), $atts));

    $buttonClasses = array('impact-link');

    if ($button_external == '1') {
        $buttonClasses[] = 'external';
    }

    $output = '<div class="impact-header-outer">';
    $output .= '<div class="impact-header clearfix ' . $type . '">';

    switch ($type) {
        case 'only-heading':
        default:
            $output .= '<div class="text-wrap"><h1>' . do_shortcode($content) . '</h1></div>';
            break;
        case 'heading-button':
            $output .= '<div class="text-wrap"><h1>' . do_shortcode($content) . '</h1></div>';
            $output .= '<div class="impact-header-link-wrap">';
            $output .= '<a href="' . esc_url($button_link) . '" class="' . join(' ', $buttonClasses) . '"><span>' . $button_text . '</span></a>';
            $output .= '</div>';
            break;
        case 'heading-subheading':
            $output .= '<div class="text-wrap"><h1>' . do_shortcode($content) . '</h1><h4>' . do_shortcode($subheading) . '</h4></div>';
            break;
        case 'heading-subheading-button':
            $output .= '<div class="text-wrap"><h1>' . do_shortcode($content) . '</h1><h4>' . do_shortcode($subheading) . '</h4></div>';
            $output .= '<div class="impact-header-link-wrap">';
            $output .= '<a href="' . esc_url($button_link) . '" class="' . join(' ', $buttonClasses) . '"><span>' . $button_text . '</span></a>';
            $output .= '</div>';
            break;
    }

    $output .= '</div>'; // .impact-header-outer
    $output .= '</div>'; // .impact-header

    return $output;
}

function tcr_render_shortcode_impact_header_options()
{
    $config = array(
        'config' => array(
            'title' => __('Impact header options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'impact_header'
        ),
        'options' => array(
            array(
                'name' => 'type',
                'label' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose a layout', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'only-heading',
                'options' => array(
                    'only-heading' => __('Only Heading', TCR_ADMIN_TEXT_DOMAIN),
                    'heading-button' => __('Heading & Button', TCR_ADMIN_TEXT_DOMAIN),
                    'heading-subheading' => __('Heading & Sub-heading', TCR_ADMIN_TEXT_DOMAIN),
                    'heading-subheading-button' => __('Heading, Sub-heading & Button', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Heading text', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'class' => 'tcr-width-300'
            ),
            array(
                'name' => 'subheading',
                'label' => __('Sub-heading text', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'class' => 'tcr-width-300'
            ),
            array(
                'name' => 'button_text',
                'label' => __('Button text', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'class' => 'tcr-width-200'
            ),
            array(
                'name' => 'button_link',
                'label' => __('Button link', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Add the link URL including http://', TCR_ADMIN_TEXT_DOMAIN),
                'description' => __('The URL that the button should link to', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'text',
                'class' => 'tcr-width-300'
            ),
            array(
                'name' => 'button_external',
                'label' => __('Button link opens new tab/window', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'toggle',
                'default' => '0',
                'toggle' => 'yn'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}

/**
 *  NOTE BLOCK
 */
add_shortcode('note_block', 'tcr_shortcode_note_block');

function tcr_shortcode_note_block($atts, $content = '')
{
    extract(shortcode_atts(array(
        'align' => 'left'
    ), $atts));

    $classes = array('content-style', 'clearfix', "$align-note-block");

    return '<div class="' . join(' ', $classes) . '">' . do_shortcode($content) . '</div>';
}

function tcr_render_shortcode_note_block_options()
{
    $config = array(
        'config' => array(
            'title' => __('Note block options', TCR_ADMIN_TEXT_DOMAIN),
            'shortcode' => 'note_block'
        ),
        'options' => array(
            array(
                'name' => 'align',
                'label' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
                'tooltip' => __('Choose the note block alignment', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'select',
                'default' => 'left',
                'options' => array(
                    'left' => __('Left', TCR_ADMIN_TEXT_DOMAIN),
                    'right' => __('Right', TCR_ADMIN_TEXT_DOMAIN)
                )
            ),
            array(
                'name' => 'enclosed_content',
                'label' => __('Content', TCR_ADMIN_TEXT_DOMAIN),
                'type' => 'textarea'
            )
        )
    );

    $generator = new ShortcodeOptionsGenerator($config['config'], $config['options']);
    $generator->render();
}