<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Hook functions
 */
function tcr_head()
{
    do_atomic('head');
}

function tcr_body_start()
{
    do_atomic('body_start');
}

function tcr_before_header()
{
    do_atomic('before_header');
}

function tcr_header()
{
    do_atomic('header');
}

function tcr_after_header()
{
    do_atomic('after_header');
}

function tcr_before_content_style()
{
    do_atomic('before_content_style');
}

function tcr_before_content()
{
    do_atomic('before_content');
}

function tcr_after_content_style()
{
    do_atomic('after_content_style');
}

function tcr_after_content()
{
    do_atomic('after_content');
}

function tcr_sidebar_start()
{
    do_atomic('sidebar_start');
}

function tcr_sidebar_end()
{
    do_atomic('sidebar_end');
}

function tcr_before_footer()
{
    do_atomic('before_footer');
}

function tcr_footer()
{
    do_atomic('footer');
}

function tcr_after_footer()
{
    do_atomic('after_footer');
}

function tcr_body_end()
{
    do_atomic('body_end');
}

/**
 * Action hook function with support for context
 * @param $tag
 * @param $arg
 */
function do_atomic($tag = '', $arg = '')
{
    if (empty($tag))
        return false;

    // Get the prefix
    $pre = TCR_PREFIX;

    // Get the args passed into the function excluding $tag
    $args = func_get_args();
    array_splice($args, 0, 1);

    // Do actions on the basic hook
    do_action_ref_array("{$pre}_{$tag}", $args);

    // Loop through context array and fire actions on a contextual scale
    $contexts = tcr_get_context();
    foreach ($contexts as $context) {
        do_action_ref_array("{$pre}_{$context}_{$tag}", $args);
    }
}

function apply_atomic($tag = '', $arg = '')
{
    if (empty($tag))
        return false;

    // Get the prefix
    $pre = TCR_PREFIX;

    // Get the args passed into the function excluding $tag
    $args = func_get_args();
    array_splice($args, 0, 1);

    // Apply filters on the basic hook
    $value = $args[0] = apply_filters_ref_array("{$pre}_{$tag}", $args);

    // Loop through context array and apply filters on a contextual scale
    $contexts = tcr_get_context();
    foreach ($contexts as $context) {
        $value = $args[0] = apply_filters_ref_array("{$pre}_{$context}_{$tag}", $args);
    }

    // Return the final value once all filters have been applied
    return $value;
}

function apply_atomic_shortcode($tag = '', $value = '')
{
    return do_shortcode(apply_atomic($tag, $value));
}

function tcr_get_context()
{
    global $tcr;

    // Check the cache first
    if (isset($tcr['context']) && is_array($tcr['context'])) {
        return $tcr['context'];
    }

    $tcr['context'] = array();
    $object = get_queried_object();
    $object_id = get_queried_object_id();

    // Front page of the site
    if (is_front_page())
        $tcr['context'][] = 'home';

    // Blog page
    if (is_home()) {
        $tcr['context'][] = 'blog';
    }

    // Singular views
    elseif (is_singular()) {
        $tcr['context'][] = 'singular';
        $tcr['context'][] = "singular-{$object->post_type}";
        $tcr['context'][] = "singular-{$object->post_type}-{$object_id}";
    }

    // Archive views
    elseif (is_archive()) {
        $tcr['context'][] = 'archive';

        // Taxonomy archives
        if (is_tax() || is_category() || is_tag()) {
            $tcr['context'][] = 'taxonomy';
            $tcr['context'][] = "taxonomy-{$object->taxonomy}";
            $tcr['context'][] = "taxonomy-{$object->taxonomy}-" . sanitize_html_class($object->slug, $object->term_id);
        }

        // Post type archives
        elseif (is_post_type_archive()) {
            $post_type = get_post_type_object(get_query_var('post_type'));
            $tcr['context'][] = "archive-{$post_type->name}";
        }

        // User/author archives
        elseif (is_author()) {
            $tcr['context'][] = 'user';
            $tcr['context'][] = 'user-' . sanitize_html_class(get_the_author_meta('user_nicename', $object_id), $object_id);
        }

        // Time/Date archives
        else {
            if (is_date()) {
                $tcr['context'][] = 'date';
                if (is_year())
                    $tcr['context'][] = 'year';
                if (is_month())
                    $tcr['context'][] = 'month';
                if (get_query_var('w'))
                    $tcr['context'][] = 'week';
                if (is_day())
                    $tcr['context'][] = 'day';
            }
            if (is_time()) {
                $tcr['context'][] = 'time';
                if (get_query_var('hour'))
                    $tcr['context'][] = 'hour';
                if (get_query_var('minute'))
                    $tcr['context'][] = 'minute';
            }
        }
    }

    // Search results
    elseif (is_search()) {
        $tcr['context'][] = 'search';
    }

    // Error 404 pages
    elseif (is_404()) {
        $tcr['context'][] = 'error-404';
    }

    $tcr['context'] = array_map('esc_attr', $tcr['context']);
    return $tcr['context'];
}