<?php
/**
 * The template for displaying posts in the Status Post Format on index and archive pages
 *
 * Learn more: http://codex.wordpress.org/Post_Formats
 *
 * @package Storm
 * @since Storm 1.0
 */
global $tcr;
$showFeaturedImage = apply_atomic('blog_featured_image', tcr_get_post_meta(get_the_ID(), 'featured_image', $tcr['options']['blog_featured_image']));
$featuredImageType = apply_atomic('blog_featured_image_type', $tcr['options']['blog_featured_image_type']);
?>
<div id="post-<?php the_ID(); ?>" <?php post_class("entry entry-image-$featuredImageType"); ?>>

    <?php
	if ($showFeaturedImage && $featuredImageType != 'below') {
	    echo tcr_blog_featured_image($featuredImageType, $tcr['layout']);
	}
	?>

	<div class="entry-info <?php if (!$tcr['options']['blog_show_date_circle']) echo 'hide-date'; ?>">
    	<h1 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf(tcr_esc_attr__('permalink_to', __('Permalink to %s', TCR_TEXT_DOMAIN)), the_title_attribute('echo=0')); ?>"><?php the_title(); ?></a></h1>

    	<?php if (get_post_type() == 'post') : ?>
    		<?php if ($tcr['options']['blog_show_date_circle']) : ?>
            	<div class="date">
                    <div class="day"><h2><?php echo get_the_date('j'); ?></h2></div>
                    <div class="month"><?php echo get_the_date('M'); ?></div>
                </div>
            <?php endif; ?>
        	<div class="entry-meta">
        	    <?php echo tcr_posted_on(); ?>
        	</div><!-- .entry-meta -->
    	<?php endif; ?>
    </div><!-- .entry-info -->

    <?php
	if ($showFeaturedImage && $featuredImageType == 'below') {
	    echo tcr_blog_featured_image($featuredImageType, $tcr['layout']);
	}
	?>

    <div class="entry-content clearfix">
        <?php if (is_search()) : ?>
    		<?php the_excerpt(); ?>
        <?php else : ?>
            <div class="avatar"><?php echo get_avatar(get_the_author_meta('ID'), apply_atomic('status_avatar', '65')); ?></div>

            <?php
                global $tcr;
                the_content($tcr['options']['general_read_more_text']);
            ?>
        <?php endif; ?>
    </div><!-- .entry-content -->
    <?php edit_post_link(__('Edit', TCR_ADMIN_TEXT_DOMAIN), '<div class="entry-meta clearfix"><span class="edit-link">', '</span></div><!-- .entry-meta -->'); ?>

</div><!-- #post-## -->
