<?php
/**
 * The template for displaying content in the single.php template. Displaying the single post of all post formats.
 *
 * @package Storm
 * @since Storm 1.0
 */
global $tcr;
$showFeaturedImage = apply_atomic('blog_featured_image', tcr_get_post_meta(get_the_ID(), 'featured_image', $tcr['options']['blog_featured_image']));
$featuredImageType = apply_atomic('blog_featured_image_type', tcr_get_post_meta(get_the_ID(), 'featured_image_type', $tcr['options']['blog_featured_image_type']));
?>
<div id="post-<?php the_ID(); ?>" <?php post_class("entry entry-image-$featuredImageType"); ?>>

    <?php
    if ($showFeaturedImage) {
        echo tcr_blog_featured_image($featuredImageType, $tcr['layout']);
    }
    ?>

	<div class="entry-content clearfix">
		<?php
		    the_content();
		    tcr_link_pages();
	    ?>
	</div><!-- .entry-content -->

	<div class="entry-meta clearfix">
		<?php
			$categoriesList = get_the_category_list(', ');
			$tagList = get_the_tag_list('', ', ');

            if (strlen($categoriesList)) {
			    printf('<span class="entry-meta-cats-wrap"><span class="entry-meta-cats">%1$s</span> %2$s</span>',
			        tcr__('categories_colon', __('Categories:', TCR_TEXT_DOMAIN)),
    				$categoriesList
    			);
			}

			if (strlen($tagList)) {
			    printf('<span class="entry-meta-tags-wrap"><span class="entry-meta-tags">%1$s</span> %2$s</span>',
			        tcr__('tags_colon', __('Tags:', TCR_TEXT_DOMAIN)),
    				$tagList
    			);
			}
		?>
		<?php edit_post_link(__('Edit', TCR_ADMIN_TEXT_DOMAIN), '<span class="edit-link">', '</span>'); ?>
	</div><!-- .entry-meta -->
</div><!-- #post-## -->
