<?php
/**
 * The template for displaying content in the single-portfolio.php template. Displaying the content of a single portfolio item.
 *
 * @package Storm
 * @since Storm 1.0
 */
global $tcr;
$showFeaturedImage = apply_atomic('portfolio_featured_image', tcr_get_post_meta(get_the_ID(), 'featured_image', $tcr['options']['portfolio_featured_image']));
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <?php
    if ($showFeaturedImage) {
        echo tcr_portfolio_featured_image($tcr['layout']);
    }
    ?>

    <div class="entry-content clearfix">
        <?php
            the_content();
            tcr_link_pages();
        ?>
    </div><!-- .entry-content -->

    <div class="entry-meta">
        <?php
            $categoriesList = get_the_category_list(', ');
            $tagList = get_the_tag_list('', ', ');

            if (strlen($categoriesList)) {
                printf('<span class="entry-meta-cats-wrap"><span class="entry-meta-cats">%1$s</span> %2$s</span>',
                    tcr__('categories_colon', __('Categories:', TCR_TEXT_DOMAIN)),
                    $categoriesList
                );
            }

            if (strlen($tagList)) {
                printf('<span class="entry-meta-tags-wrap"><span class="entry-meta-tags">%1$s</span> %2$s</span>',
                    tcr__('tags_colon', __('Tags:', TCR_TEXT_DOMAIN)),
                    $tagList
                );
            }
        ?>
        <?php edit_post_link(__('Edit', TCR_ADMIN_TEXT_DOMAIN), '<span class="edit-link">', '</span>'); ?>
    </div><!-- .entry-meta -->
</div><!-- #post-## -->