<?php
/**
 * The template for displaying comments
 *
 * @package Storm
 * @since Storm 1.0
 */
if (!defined('ABSPATH')) exit; // Prevent direct script access
if (post_password_required()) return; // Do not show comments if the post is password protected
if (!post_type_supports(get_post_type(), 'comments')) return; // Return if the post type doesn't support comments
global $tcr;
?>
<?php if (have_comments()) : ?>

	<div id="comments" class="comments clearfix">

        <?php if ($tcr['options']['blog_comments_layout'] == 'tabs') : // Comments and pingbacks in separate tabs ?>
            <?php $trackbackCount = count($comments_by_type['pings']); ?>
            <div class="comment-tabs-wrap">
                <ul id="comment-tabs-nav">
                    <li><a class="pointer"><?php printf(tcr_comment_count(), number_format_i18n(count($comments_by_type['comment']))); ?></a></li>
                    <?php if ($trackbackCount) : ?>
                        <li><a class="pointer"><?php printf(tcr_trackback_count(), number_format_i18n($trackbackCount)); ?></a></li>
                    <?php endif; ?>
                </ul>

                <div class="comment-tab comment-tab-comments">
                	<h3 class="comments-title"><?php tcr_esc_html_e('comments', __('Comments', TCR_TEXT_DOMAIN)); ?></h3>
                    <ol class="commentlist">
                        <?php wp_list_comments(array('type' => 'comment', 'callback' => 'tcr_comment')); ?>
                    </ol><!-- .commentlist -->

                    <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
                        <div class="comments-pagination-wrap clearfix">
                            <?php paginate_comments_links(); ?>
                        </div><!-- .comments-pagination-wrap .clearfix -->
                    <?php endif; ?>
                </div>

                <?php if ($trackbackCount) : ?>
                    <div class="comment-tab comment-tab-pings">
                    	<h3 class="comments-title"><?php tcr_esc_html_e('trackbacks', __('Trackbacks', TCR_TEXT_DOMAIN)); ?></h3>
                        <ol class="commentlist pinglist">
                            <?php wp_list_comments(array('type' => 'pings', 'callback' => 'tcr_ping')); ?>
                        </ol><!-- .commentlist .pinglist -->
                    </div>
                <?php endif; ?>
            </div>


        <?php else : // Normal comments layout ?>

            <h3 class="comments-title"><?php comments_number(); ?></h3>

            <ol class="commentlist">
                <?php wp_list_comments(array('type' => 'all', 'callback' => 'tcr_comment_list')); ?>
            </ol><!-- .commentlist -->

            <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
                <div class="comments-pagination-wrap clearfix">
                    <div class="comments-previous-page"><?php previous_comments_link(tcr__('older_comments', __('&larr; Older Comments', TCR_TEXT_DOMAIN))); ?></div>
                    <div class="comments-next-page"><?php next_comments_link(tcr__('newer_comments', __('Newer Comments &rarr;', TCR_TEXT_DOMAIN))); ?></div>
                </div><!-- .comments-pagination-wrap .clearfix -->
            <?php endif; ?>

        <?php endif; ?>

    </div><!-- #comments .comments .clearfix -->
<?php endif; ?>

<?php if (comments_open()) : ?>
<div class="comment-reply-wrap accordion toggle">
    <h3><?php tcr_esc_html_e('leave_reply', __('Leave a Reply', TCR_TEXT_DOMAIN)); ?></h3>
    <div class="comment-form-wrap accordion-content-wrap">
    <?php
        $commenter = wp_get_current_commenter();
        $req = get_option('require_name_email');
        $aria_req = ($req ? ' aria-required="true"' : '');

        $args = array(
            'fields' => apply_filters('comment_form_default_fields', array(
                'author' => '<div class="element-wrapper author-element inside-label clearfix">' .
                                '<label for="author">' . tcr_esc_html__('name', __('Name', TCR_TEXT_DOMAIN)) . ($req ? ' <span class="required">*</span>' : '') .'</label>' .
                                '<div class="input-wrapper">' .
                                    '<input type="text" id="author" name="author" value="' . esc_attr($commenter['comment_author']) . '"' . $aria_req . ' tabindex="1" />' .
                                '</div>' .
                            '</div>',
                'email' => '<div class="element-wrapper email-element inside-label clearfix">' .
                                '<label for="email">' . tcr_esc_html__('email', __('Email', TCR_TEXT_DOMAIN)) . ($req ? ' <span class="required">*</span>' : '') .'</label>' .
                                '<div class="input-wrapper">' .
                                    '<input type="text" id="email" name="email" value="' . esc_attr($commenter['comment_author_email']) . '"' . $aria_req . ' tabindex="2" />' .
                                '</div>' .
                            '</div>',
                'url' => '<div class="element-wrapper url-element inside-label clearfix">' .
                                '<label for="url">' . tcr_esc_html__('website', __('Website', TCR_TEXT_DOMAIN)) . '</label>' .
                                '<div class="input-wrapper">' .
                                    '<input type="text" id="url" name="url" value="' . esc_attr($commenter['comment_author_url']) . '" tabindex="3" />' .
                                '</div>' .
                            '</div>'
            )),
            'comment_field' => '<div class="element-wrapper comment-element inside-label clearfix">' .
                                    '<label for="comment">' . tcr_esc_html__('comment', __('Comment', TCR_TEXT_DOMAIN)) . '</label>' .
                                    '<div class="input-wrapper">' .
                                        '<textarea id="comment" name="comment" tabindex="4" aria-required="true"></textarea>' .
                                    '</div>' .
                                '</div>',
            'comment_notes_before' => '',
            'comment_notes_after' => '',
            'title_reply' => ''
        );

        comment_form($args);
    ?>
    </div><!-- .comment-form-wrap accordion-content-wrap -->
</div><!-- .comment-reply-wrap accordion toggle -->
<?php else : ?>
    <p class="nocomments"><?php tcr_esc_html_e('comments_closed', __('Comments are closed.', TCR_TEXT_DOMAIN)); ?></p>
<?php endif; ?>