<?php
/**
 * The template for displaying posts from a single author
 *
 * @package Storm
 * @since Storm 1.0
 */
global $tcr;
get_header(); ?>

<?php tcr_breadcrumbs(); ?>

<?php if (have_posts()) : ?>
    <?php
        the_post(); // Queue the first post, that way we know who the author is
        rewind_posts(); // Reset the loop
    ?>

	<?php if ($tcr['options']['blog_show_author_description'] && get_the_author_meta('description')) : ?>
	<div id="author-info">
		<div id="author-avatar">
			<?php echo get_avatar(get_the_author_meta('user_email'), apply_atomic('author_bio_avatar_size', 60)); ?>
		</div><!-- #author-avatar -->
		<div id="author-description">
			<h2><?php printf(tcr__('about_author', __('About %s', TCR_TEXT_DOMAIN)), get_the_author()); ?></h2>
			<?php the_author_meta( 'description' ); ?>
		</div><!-- #author-description	-->
	</div><!-- #author-info -->
	<?php endif; ?>

    <?php while (have_posts()) : the_post(); ?>

        <?php get_template_part('content', get_post_format()); ?>

    <?php endwhile; ?>

    <?php tcr_content_nav('content-nav-below'); ?>

<?php else : ?>

    <?php tcr_404(); ?>

<?php endif; ?>

<?php get_footer(); ?>