/*
 * ThemeCatcher Shortcodes JavaScript
 * 
 * Copyright www.themecatcher.net
 * All rights reserved.
 */
;(function ($, window) {    
    $(document).ready(function () {
    	var $outer = $('<div id="tcr-shortcode-outer"/>').appendTo('body');
    	
    	// Load the shortcode overlay when button is clicked
    	$('.tcr-shortcode-trigger').live('click', function () {	    
    		var $overlay = $('<div class="tcr-shortcode-overlay"/>'),
    		$wrap = $('<div class="tcr-shortcode-wrap"/>').appendTo($overlay),
    		$loading = $('<div class="tcr-shortcode-loading"/>').appendTo($wrap),
    		$content = $('<div class="tcr-shortcode-content"/>').appendTo($wrap),
    		$buttonWrap = $('<div class="tcr-overlay-buttons"/>').appendTo($wrap),
    	    closeShortcodePopup = function () {
    	        $(document).unbind('click.tcr-shortcode');
    	        $(window).unbind('resize.tcr-shortcode');
    	        $overlay.remove();
    	    },
    	    insertShortcode = function () {
    	        var sc = ShortcodeGenerator.render();
    	        
    	        if (sc) {   
    	            ShortcodeGenerator.sendToEditor(sc);
    	        }
    	    },
    	    insertCloseShortcode = function () {
    	        insertShortcode();
    	        closeShortcodePopup();
    	    };
    		
    		$('<div class="tcr-overlay-button tcr-overlay-button-close"/>').click(function () {
    		    closeShortcodePopup();
    		}).appendTo($buttonWrap).attr('title', tcrL10n.close);
    		
    		$('<div class="tcr-overlay-button tcr-overlay-button-insert"/>').click(function () {
    		    insertShortcode();
            }).appendTo($buttonWrap).attr('title', tcrL10n.insert);
    		
    		$('<div class="tcr-overlay-button tcr-overlay-button-insert-close"/>').click(function () {
    		    insertCloseShortcode();
            }).appendTo($buttonWrap).attr('title', tcrL10n.insert_close);
    				
    		$content.load($(this).attr('href') , function () {
    		    $loading.remove();
    			$('.tcr-chosen-multi', $content).width(400).chosen();
    			
    			$('input.tcr-option-toggle, select.tcr-option-tritoggle').toggleSwitch({
    	            onText: tcrL10n.on,
    	            offText: tcrL10n.off,
    	            defaultText: tcrL10n._default
    	        });
    	        
    	        $('input.tcr-option-toggle-yn, select.tcr-option-tritoggle-yn').toggleSwitch({
    	            defaultText: tcrL10n._default,
    	            onText: tcrL10n.yes,
    	            offText: tcrL10n.no
    	        });
    	        
    	        $('#tcr-sc-type-select').change(function (e) {
    	            var type = $(this).val();       
    	            $('.tcr-sc-options, #tcr-sc-preview').hide();
    	            
    	            if (type) {
    	                $('#tcr-sc-preview, #tcr-sc-options-' + type).show();
    	            }
    	        });
    
    	        $('#tcr-insert-shortcode').click(function (e) {
    	            insertShortcode();
    	        });
    	        
    	        $('#tcr-insert-close-shortcode').click(function (e) {
    	            insertCloseShortcode();
    	        });
    	        
    	        $('#tcr-close-shortcode').click(function (e) {
    	            closeShortcodePopup();
    	        });
    	        
    	        // Layout variation select
    	        $('#tcr-sc-select-layouts').change(function (e) {
    	            var val = $(this).val(),
    	            show = 1;
    	            
    	            $('.tcr-sc-layout-content-wrap', '#tcr-sc-options-layouts').hide();     
    	            
    	            switch (val) {
    	                case 'two_column':
    	                case 'one_third_two_thirds':
    	                case 'two_thirds_one_third':
    	                case 'one_fourth_three_fourths':
    	                case 'three_fourths_one_fourth':
    	                case 'four_fifths_one_fifth':
    	                case 'one_fifth_four_fifths':
    	                case 'two_fifths_three_fifths':
    	                case 'three_fifths_two_fifths':
    	                case 'one_sixth_five_sixths':
    	                case 'five_sixth_one_sixths':
    	                    show = 2;
    	                    break;
    	                case 'three_column':
    	                case 'two_fourths_one_half':
    	                case 'one_fourth_one_half_one_fourth':
    	                case 'one_half_two_fourths':
    	                    show = 3;
    	                    break;
    	                case 'four_column':
    	                case 'three_sixths_one_half':
    	                case 'one_half_three_sixths':
    	                    show = 4;
    	                    break;
    	                case 'five_column':
    	                    show = 5;
    	                    break;
    	                case 'six_column':
    	                    show = 6;
    	                    break;
    	            }
    	            
    	            if (show > 0) {
    	                for (var i = 0; i < show; i++) {
    	                    $('#tcr-sc-layout-content-wrap-' + (i+1)).show();
    	                }
    	            }
    	        });
    	        
    	        var paneHTML = '<div class="tcr-sc-pane">\
                    <div class="tcr-sc-pane-remove" title="' + tcrL10n.removeTab + '">X</div>\
                    <div class="tcr-sc-pane-outer tcr-clearfix">\
                        <div class="tcr-sc-pane-label">\
                            <h4>' + tcrL10n.title + '</h4>\
                        </div>\
                        <div class="tcr-sc-pane-inner">\
                            <input type="text" />\
                        </div>\
                    </div>\
                    <div class="tcr-sc-pane-outer tcr-clearfix">\
                        <div class="tcr-sc-pane-label">\
                            <h4>' + tcrL10n.content + '</h4>\
                        </div>\
                        <div class="tcr-sc-pane-inner">\
                            <textarea></textarea>\
                        </div>\
                    </div>\
                </div>';
    	            
        	    // Tabs
        	    $('#tcr-sc-add-tab').click(function (e) {
        	        e.preventDefault();
        	        $('#tcr-sc-tabs-wrap').append(paneHTML);
        	    });
        
        	    // Toggles
        	    $('#tcr-sc-add-toggle').click(function (e) {
        	        e.preventDefault();
        	        $('#tcr-sc-toggles-wrap').append($(paneHTML).find('.tcr-sc-pane-remove').attr('title', tcrL10n.removeToggle).end());
        	    });
        
        	    // Accordion
        	    $('#tcr-sc-add-accordion').click(function (e) {
        	        e.preventDefault();
        	        $('#tcr-sc-accordions-wrap').append($(paneHTML).find('.tcr-sc-pane-remove').attr('title', tcrL10n.removeToggle).end());
        	    });
        
        	    var contentPaneHTML = '<div class="tcr-sc-pane">\
                    <div class="tcr-sc-pane-remove" title="' + tcrL10n.removeSlide + '">X</div>\
                    <div class="tcr-sc-pane-outer tcr-clearfix">\
                        <div class="tcr-sc-pane-label">\
                            <h4>' + tcrL10n.content + '</h4>\
                        </div>\
                        <div class="tcr-sc-pane-inner">\
                            <textarea></textarea>\
                        </div>\
                    </div>\
                </div>';    	    
        
        	    // Cycle
        	    $('#tcr-sc-add-cycle').click(function (e) {
        	        e.preventDefault();
        	        $('#tcr-sc-cycle-slides-wrap').append(contentPaneHTML);
        	    });
        
        	    $outer.delegate('.tcr-sc-pane-remove', 'click', function (e) {
        	        e.preventDefault();
        	        $(this).parent().remove();
        	    });
        
        	    // Quotes
        	    $('#tcr-sc-select-quotes').change(function () {
        	        $('#tcr-sc-options-blockquote').hide();
        	        $('#tcr-sc-options-pullquote').hide();
        	        var val = $(this).val();
        	        
        	        if (val) {
        	            $('#tcr-sc-options-' + val + '').show();
        	        }
        	    });
    	        
    	        // Preview
        	    $('.tcr-sc-preview-outer').each(function () {
        	        var $previewOuter = $(this),
        	        $root = $previewOuter.parent(),
        	        $iframe = $previewOuter.find('.tcr-sc-preview-content-frame'),
        	        refreshPreview = function () {
        	            $previewOuter.show();
        	            $iframe.attr('src', tcrL10n.shortcodePreviewUrl + '&s=' + encodeURIComponent(ShortcodeGenerator.render()));
        	        };
        	        
        	        $('input[type="text"], textarea', $root).blur(refreshPreview);
        	        $('select', $root).change(refreshPreview);
        	        $('input[type="checkbox"]', $root).change(refreshPreview); // ToggleSwitch plugin triggers change event on checkboxes
        	        $('.tcr-sc-preview-refresh', $previewOuter).click(refreshPreview);
        	    });
        	    
    	        // Prevent the form submitting
    	        $('#tcr-shortcode-form').submit(function (e) {
    	            e.preventDefault();
    	        });
    	        
    	        // Show paging options for portfolio shortcode
    	        $('#tcr-sc-portfolio-paging').change(function (e) {
    	            if ($(this).is(':checked')) {
    	                $('#tcr-sc-portfolio-paged').parent().parent().show();
    	            } else {
    	                $('#tcr-sc-portfolio-paged').parent().parent().hide();
    	            }
    	        });
    	        
    	        // Show excerpt length field
    	        $('#tcr-sc-portfolio-show_description').change(function (e) {
    	            if ($(this).is(':checked')) {
    	                $('#tcr-sc-portfolio-description_length').parent().parent().show();
    	            } else {
    	                $('#tcr-sc-portfolio-description_length').parent().parent().hide();
    	            }
    	        });
    	        
    	        // Tooltips
    	        $('.tcr-tip-icon, .tcr-tooltip').qtip({
    	            text: false,
    	            style: {
    	                classes: 'ui-tooltip-op ui-tooltip-dark',
    	                border: { color: '#000000' },
    	                tip: {
    	                    color: 'false'
    	                }
    	            },
    	            position: {
    	                my: 'bottom center',
    	                at: 'top center'
    	            }
    	        });
    	        
    	        $('.tcr-tooltip-wrap').qtip({
    	            style: {
    	                classes: 'ui-tooltip-op ui-tooltip-dark',
    	                border: { color: '#000000' },
    	                tip: {
    	                    color: 'false'
    	                }
    	            },
    	            position: {
    	                my: 'bottom center',
    	                at: 'top center'
    	            },
    	            content: {
    	                text: function (api) {
    	                    return $(this).find('.tcr-tooltip-content').html();
    	                }
    	            }
    	        });
    	        
    	        // Range slider
                $('.tcr-range-slider').each(function () {
                    var $this = $(this),
                    defaults = {
                        limits: false,
                        skin: 'round_plastic',
                        step: 1,
                        dimension: tcrL10n.px         
                    },
                    options = {
                        from: $this.data('from'),
                        to: $this.data('to'),
                        step: $this.data('step'),
                        dimension: $this.data('dimension')
                    };
                    
                    $this.slider($.extend({}, defaults, options));
                    
                    $this.bind('blur', function () {
                        $this.slider('value', $this.val());
                    });
                });
    		}); // End .load() content
    		
    		$outer.append($overlay).bind('click', function (e) {
    			if (e.target.className !== 'tcr-shortcode-overlay') {
    				// Stop click events bubbling
    				e.stopPropagation();
    			}
    		});
    		
    		$(document).bind('click.tcr-shortcode', function (e) {
    			if (e.which == 3) { // Prevent a rightclick closing the popup
    				return;
    			}
    			
    			closeShortcodePopup();
    		});
    				
    		$(window).bind('resize.tcr-shortcode', function () {
    			var $shortcodeWrap = $('.tcr-shortcode-wrap'),
    			height = $(window).height(),
    			adminBarHeight = 0;
    
    			if ($('body.admin-bar').length) {
    				adminBarHeight = 28;
    			}
    
    			if ($shortcodeWrap.length) {
    				$shortcodeWrap.height(height - 85 - adminBarHeight);
    				$shortcodeWrap.css({'top': 40 + adminBarHeight + 'px',marginTop: 0});
    			};
    			
    			
    		}).resize();
    		
    		return false;
    	});
    	
    	var ShortcodeGenerator = window.ShortcodeGenerator = {		
    		/**
    		 * Render the selected shortcode
    		 * 
    		 * @returns string
    		 */
    		render: function () {
    			var type = $('#tcr-sc-type-select').val(),
    			o = '',
    			code = '',
    			enclosing = 'self-closing',
    			content = '',
    			atts = '',
    			nl = ((typeof tinyMCE != "undefined") && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden()) ? '<br />' : '\n';
    			
    			switch (type) {
    				case 'columns':
    					code = $('#tcr-sc-select-columns').val();
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-columns-content').val();
    					if ($('#tcr-sc-columns-last').is(':checked')) {
    						code += '_last';
    					}
    					break;
    				case 'layouts':
    					var layout = $('#tcr-sc-select-layouts').val(),
    					$c1 = $('#tcr-sc-layout-content-1'),
    					$c2 = $('#tcr-sc-layout-content-2'),
    					$c3 = $('#tcr-sc-layout-content-3'),
    					$c4 = $('#tcr-sc-layout-content-4'),
    					$c5 = $('#tcr-sc-layout-content-5'),
    					$c6 = $('#tcr-sc-layout-content-6');
    					
    					switch (layout) {
    						case 'two_column':							
    							o = '[one_half]' + $c1.val() + '[/one_half]' +
    								'[one_half_last]' + $c2.val() + '[/one_half_last]';
    							break;
    						case 'three_column':
    							o = '[one_third]' + $c1.val() + '[/one_third]' +
    								'[one_third]' + $c2.val() + '[/one_third]' +
    								'[one_third_last]' + $c3.val() + '[/one_third_last]';
    							break;
    						case 'four_column':
    							o = '[one_fourth]' + $c1.val() + '[/one_fourth]' +
    								'[one_fourth]' + $c2.val() + '[/one_fourth]' +
    								'[one_fourth]' + $c3.val() + '[/one_fourth]' +
    								'[one_fourth_last]' + $c4.val() + '[/one_fourth_last]';
    							break;
    						case 'five_column':
    							o = '[one_fifth]' + $c1.val() + '[/one_fifth]' +
    								'[one_fifth]' + $c2.val() + '[/one_fifth]' +
    								'[one_fifth]' + $c3.val() + '[/one_fifth]' +
    								'[one_fifth]' + $c4.val() + '[/one_fifth]' +
    								'[one_fifth_last]' + $c5.val() + '[/one_fifth_last]';
    							break;
    						case 'six_column':
    							o = '[one_sixth]' + $c1.val() + '[/one_sixth]' +
    								'[one_sixth]' + $c2.val() + '[/one_sixth]' +
    								'[one_sixth]' + $c3.val() + '[/one_sixth]' +
    								'[one_sixth]' + $c4.val() + '[/one_sixth]' +
    								'[one_sixth]' + $c5.val() + '[/one_sixth]' +
    								'[one_sixth_last]' + $c6.val() + '[/one_sixth_last]';
    							break;
    						case 'one_third_two_thirds':
    							o = '[one_third]' + $c1.val() + '[/one_third]' +
    								'[two_thirds_last]' + $c2.val() + '[/two_thirds_last]';
    							break;
    						case 'two_thirds_one_third':
    							o = '[two_thirds]' + $c1.val() + '[/two_thirds]' +
    								'[one_third_last]' + $c2.val() + '[/one_third_last]';
    							break;
    						case 'one_fourth_three_fourths':
    							o = '[one_fourth]' + $c1.val() + '[/one_fourth]' +
    								'[three_fourths_last]' + $c2.val() + '[/three_fourths_last]';
    							break;
    						case 'three_fourths_one_fourth':
    							o = '[three_fourths]' + $c1.val() + '[/three_fourths]' +
    								'[one_fourth_last]' + $c2.val() + '[/one_fourth_last]';
    							break;
    						case 'two_fourths_one_half':
    							o = '[one_fourth]' + $c1.val() + '[/one_fourth]' +
    								'[one_fourth]' + $c2.val() + '[/one_fourth]' +
    								'[one_half_last]' + $c3.val() + '[/one_half_last]';
    							break;
    						case 'one_fourth_one_half_one_fourth':
    							o = '[one_fourth]' + $c1.val() + '[/one_fourth]' +
    								'[one_half]' + $c2.val() + '[/one_half]' +
    								'[one_fourth_last]' + $c3.val() + '[/one_fourth_last]';
    							break;
    						case 'one_half_two_fourths':
    							o = '[one_half]' + $c1.val() + '[/one_half]' +
    								'[one_fourth]' + $c2.val() + '[/one_fourth]' +
    								'[one_fourth_last]' + $c3.val() + '[/one_fourth_last]';
    							break;
    						case 'four_fifths_one_fifth':
    							o = '[four_fifths]' + $c1.val() + '[/four_fifths]' +
    								'[one_fifth_last]' + $c2.val() + '[/one_fifth_last]';
    							break;
    						case 'one_fifth_four_fifths':
    							o = '[one_fifth]' + $c1.val() + '[/one_fifth]' +
    								'[four_fifths_last]' + $c2.val() + '[/four_fifths_last]';
    							break;
    						case 'two_fifths_three_fifths':
    							o = '[two_fifths]' + $c1.val() + '[/two_fifths]' +
    								'[three_fifths_last]' + $c2.val() + '[/three_fifths_last]';
    							break;
    						case 'three_fifths_two_fifths':
    							o = '[three_fifths]' + $c1.val() + '[/three_fifths]' +
    								'[two_fifths_last]' + $c2.val() + '[/two_fifths_last]';
    							break;
    						case 'one_sixth_five_sixths':
    							o = '[one_sixth]' + $c1.val() + '[/one_sixth]' +
    								'[five_sixths_last]' + $c2.val() + '[/five_sixths_last]';
    							break;
    						case 'five_sixth_one_sixths':
    							o = '[five_sixths]' + $c1.val() + '[/five_sixths]' +
    								'[one_sixth_last]' + $c2.val() + '[/one_sixth_last]';
    							break;
    						case 'three_sixths_one_half':
    							o = '[one_sixth]' + $c1.val() + '[/one_sixth]' +
    								'[one_sixth]' + $c2.val() + '[/one_sixth]' +
    								'[one_sixth]' + $c3.val() + '[/one_sixth]' +
    								'[one_half_last]' + $c4.val() + '[/one_half_last]';
    							break;
    						case 'one_half_three_sixths':
    							o = '[one_half]' + $c1.val() + '[/one_half]' +
    								'[one_sixth]' + $c2.val() + '[/one_sixth]' +
    								'[one_sixth]' + $c3.val() + '[/one_sixth]' +
    								'[one_sixth_last]' + $c4.val() + '[/one_sixth_last]';
    							break;
    					}
    					
    					break;
    				case 'blog':
    					code = 'blog';
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'portfolio':
    					code = 'portfolio';
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'quotes':
    					var variation = $('#tcr-sc-select-quotes').val();
    					
    					switch (variation) {
    						case 'blockquote':
    						case 'pullquote':
    							code = variation;
    							enclosing = 'enclosing';
    							content = $('#tcr-sc-' + variation + '-enclosed_content').val();
    							atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + variation);
    							break;
    					}
    					break;
    				case 'boxes':
    					code = 'box';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-box-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'section_breaks':
    					code = 'section_break';
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'buttons':
    					code = 'button';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-button-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'lists':
    					code = 'list';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-list-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'menus':
                        code = 'menu';
                        enclosing = 'enclosing';
                        content = $('#tcr-sc-menu-enclosed_content').val();
                        atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
                        break;
    				case 'tables':
    					code = 'table';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-table-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'dropcaps':
    					code = 'dropcap';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-dropcap-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'tabs':
    					var $tabs = $('.tcr-sc-pane', '#tcr-sc-options-tabs');
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-tabs');
    					
    					o = '[tabs' + (atts ? ' ' + atts : '') + ']' + nl;
    					
    					$.each($tabs, function () {
    						var $this = $(this),
    						title = $this.find('input[type="text"]').val(),
    						content = $this.find('textarea').val();
    						
    						o += '[tab title="' + title + '"]' + content + '[/tab]' + nl;
    					});	
    					
    					o += '[/tabs]' + nl;
    					break;
    				case 'toggles':
    					var $toggles = $('.tcr-sc-pane', '#tcr-sc-options-toggles');
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-toggles');
    					
    					o = '[toggle' + (atts ? ' ' + atts : '') + ']' + nl;
    										
    					$.each($toggles, function () {
    						var $this = $(this),
    						title = $this.find('input[type="text"]').val(),
    						content = $this.find('textarea').val();
    						
    						o += '[toggle_content title="' + title + '"]' + content + '[/toggle_content]' + nl;
    					});	
    					
    					o += '[/toggle]' + nl;
    					break;
    				case 'accordion':
    					var $panes = $('.tcr-sc-pane', '#tcr-sc-options-accordion');
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-accordion');
    					
    					o = '[accordion' + (atts ? ' ' + atts : '') + ']' + nl;
    					
    					$.each($panes, function () {
    						var $this = $(this),
    						title = $this.find('input[type="text"]').val(),
    						content = $this.find('textarea').val();
    						
    						o += '[accordion_toggle title="' + title + '"]' + content + '[/accordion_toggle]' + nl;
    					});	
    					
    					o += '[/accordion]' + nl;
    					break;
    				case 'cycle':
                        var $panes = $('.tcr-sc-pane', '#tcr-sc-options-cycle');
                        atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-cycle');
                        
                        o = '[cycle' + (atts ? ' ' + atts : '') + ']' + nl;
                        
                        $.each($panes, function () {
                            var $this = $(this),
                            content = $this.find('textarea').val();
                            
                            o += '[cycle_slide]' + content + '[/cycle_slide]' + nl;
                        }); 
                        
                        o += '[/cycle]' + nl;
                        break;
    				case 'galleria':
    					code = 'galleria';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-galleria-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'image':
                        code = 'image';
                        enclosing = 'enclosing';
                        content = $('#tcr-sc-image-enclosed_content').val();
                        atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
                        break;
    				case 'image_frames':
    					code = 'image_frame';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-image_frame-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'fancy_headers':
    					code = 'fancy_header';
    					enclosing = 'enclosing';
    					content = $('#tcr-sc-fancy_header-enclosed_content').val();
    					atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
    					break;
    				case 'impact_headers':
                        code = 'impact_header';
                        enclosing = 'enclosing';
                        content = $('#tcr-sc-impact_header-enclosed_content').val();
                        atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
                        break;
    				case 'note_block':
    				    code = 'note_block';
    				    enclosing = 'enclosing';
    				    content = $('#tcr-sc-note_block-enclosed_content').val();
    				    atts = ShortcodeGenerator.fieldsToAtts('#tcr-sc-options-' + type);
                        break;
    				case '':
    				default:
    					return;				
    			}
    			
    			// If we've created output already, return it
    			if (o) return o;
    						
    			if (!code) return;
    			
    			o = '[' + code + (atts ? ' ' + atts : '') + ']';			
    						
    			switch (enclosing) {
    				case 'enclosing':
    					o += (content || ' ') + '[/' + code + ']';
    					break;
    				case 'both':
    					o += content.length ? content + '[/' + code + ']' : '';
    					break;
    			}
    			
    			return o;
    		},
    				
    		/**
    		 * Generates an attributes array from a group of generated shortcode
    		 * options fields.
    		 * 
    		 * @param string wrapperSelector The jQuery selector for the fields wrapper
    		 * @return array
    		 */
    		fieldsToAtts: function (wrapperSelector) {
    			var atts = [];
    			
    			$.each($(wrapperSelector).find('.tcr-shortcode-field-outer'), function (i, field) {
    				var $field = $(field),
    				config = $field.data('config'),
    				value = ShortcodeGenerator.getAttributeValue(config, $field);
    				
    				if (value != config['default'] && config.name != 'enclosed_content') {
    					atts.push(config.name + '="' + value + '"');
    				}			
    			});
    			
    			return atts.join(' ');
    		},
    		
    		/**
    		 * Get the value of an attribute
    		 * 
    		 * @param array config The field config
    		 * @param jQuery $field The field wrapper
    		 * @returns string
    		 */
    		getAttributeValue: function (config, $field) {
    			var value = '';
    			
    			switch (config.type) {
    				case 'text':
    				case 'textarea':
    				case 'select':
    				default:
    					value = $('#' + config.selector).val();
    					break;
    				case 'toggle':
    					value = $('#' + config.selector).is(':checked') ? '1' : '0';
    					break;
    				case 'multiselect':
    					var val = $('#' + config.selector).val();
    					if (val != null) {
    						value = val.toString();
    					}
    					break;
    			}
    			
    			return value;
    		},
    		
    		/**
    		 * Send the content to the editor
    		 * 
    		 * @param string h
    		 */
    		sendToEditor: function (h) {
    			var activeEditor, ed, mce = typeof(tinymce) != 'undefined', qt = typeof(QTags) != 'undefined',
    			widgetTarget = $('#tcr-widget-target').val();
    						
    			if (widgetTarget) {
    				var sel, startPos, endPos, scrollTop, text, canvas = document.getElementById(widgetTarget);
    
    				if ( !canvas )
    					return false;
    
    				if ( document.selection ) { //IE
    					canvas.focus();
    					sel = document.selection.createRange();
    					sel.text = h;
    					canvas.focus();
    				} else if ( canvas.selectionStart || canvas.selectionStart == '0' ) { // FF, WebKit, Opera
    					text = canvas.value;
    					startPos = canvas.selectionStart;
    					endPos = canvas.selectionEnd;
    					scrollTop = canvas.scrollTop;
    
    					canvas.value = text.substring(0, startPos) + h + text.substring(endPos, text.length);
    
    					canvas.focus();
    					canvas.selectionStart = startPos + h.length;
    					canvas.selectionEnd = startPos + h.length;
    					canvas.scrollTop = scrollTop;
    				} else {
    					canvas.value += h;
    					canvas.focus();
    				}
    				return true;
    			} else if ( !activeEditor ) {
    				if ( mce && tinymce.activeEditor ) {
    					ed = tinymce.activeEditor;
    					activeEditor = ed.id;
    				} else if ( !qt ) {
    					return false;
    				}
    			} else if ( mce ) {
    				if ( tinymce.activeEditor && (tinymce.activeEditor.id == 'mce_fullscreen' || tinymce.activeEditor.id == 'wp_mce_fullscreen') )
    					ed = tinymce.activeEditor;
    				else
    					ed = tinymce.get(activeEditor);
    			}
    
    			
    			if ( ed && !ed.isHidden() ) {
    				// restore caret position on IE
    				if ( tinymce.isIE && ed.windowManager.insertimagebookmark )
    					ed.selection.moveToBookmark(ed.windowManager.insertimagebookmark);
    
    				if ( h.indexOf('[caption') === 0 ) {
    					if ( ed.plugins.wpeditimage )
    						h = ed.plugins.wpeditimage._do_shcode(h);
    				} else if ( h.indexOf('[gallery') === 0 ) {
    					if ( ed.plugins.wpgallery )
    						h = ed.plugins.wpgallery._do_gallery(h);
    				} else if ( h.indexOf('[embed') === 0 ) {
    					if ( ed.plugins.wordpress )
    						h = ed.plugins.wordpress._setEmbed(h);
    				}
    
    				ed.execCommand('mceInsertContent', false, h);
    			} else if ( qt ) {
    				QTags.insertContent(h);
    			} else {
    				document.getElementById(activeEditor).value += h;
    			}
    		}
    	};	
    }); // End document.ready
})(jQuery, window);