/*
 * ThemeCatcher Options Panel JavaScript
 * 
 * Copyright www.themecatcher.net
 * All rights reserved.
 */
;(function ($, window) {
	window.ThemeCatcher = ThemeCatcher = {
		$form: null,
		hooks: {},	
		options: {},
		
		/**
		 * Initialise options panel
		 * @param array options
		 */
		init: function (options) {			
			ThemeCatcher.$form = $('#tcr');
			if (!ThemeCatcher.$form.length) return;
			
			ThemeCatcher.options = options;
						
			// Prevent the enter key from submitting the form
			ThemeCatcher.$form.submit(function(e) { e.preventDefault(); }).attr('autocomplete', 'off');
			
			$('#tcr-tabs-nav').fptabs('#tcr-tabs > div', { current: 'tcr-current' });
			            
			$('.tcr-sub-tabs-nav').each(function (i) {
			    $(this).fptabs($('.tcr-sub-tabs').eq(i).find('> div'), { current: 'tcr-current' });
			});
			
			// Toggle buttons			
			$('input.tcr-toggle, select.tcr-tritoggle').toggleSwitch({
	            onText: tcrL10n.on,
	            offText: tcrL10n.off,
	            defaultText: tcrL10n._default
	        });
	        
	        $('input.tcr-toggle-yn, select.tcr-tritoggle-yn').toggleSwitch({
	            defaultText: tcrL10n._default,
	            onText: tcrL10n.yes,
	            offText: tcrL10n.no
	        });
	        
	        // Range slider
	        $('.tcr-range-slider').each(function () {
	            var $this = $(this),
	            defaults = {
	                limits: false,
	                skin: 'round_plastic',
	                step: 1,
	                dimension: tcrL10n.px                
	            },
	            options = {
    	            from: $this.data('from'),
    	            to: $this.data('to'),
    	            step: $this.data('step'),
    	            dimension: $this.data('dimension')
	            };
	            
	            $this.slider($.extend({}, defaults, options));
	            
	            $this.bind('blur', function () {
                    $this.slider('value', $this.val());
                });
	        });
	        
	        // Layout selector
	        $('.tcr-layout-selector').each(function () {
	            var $select = $(this),
	            $options = $select.find('option'),
	            activeClass = 'tcr-layout-select-active',
	            $wrap = $('<div class="tcr-layout-selector"/>');
	            
	            $options.each(function () {
	                var $this = $(this),
	                $layout = $('<div class="tcr-layout-option"/>').appendTo($wrap).click(function () {
	                    $wrap.find('> div').removeClass(activeClass);
	                    $layout.addClass(activeClass);
	                    $select.val($this.val());
	                }).append('<img src="' + tcrL10n.themeAdminUrl + '/images/select-layout-' + ($this.val() || 'default') + '.png" alt="" />')
	                .attr('title', $this.text());
	                
	                if ($this.is(':selected')) {
	                    $layout.addClass(activeClass);
	                }
	            });

	            $select.hide().after($wrap);
	        });
	        
	        // Texture selector
	        $('.tcr-texture-selector').each(function () {
	            var $select = $(this),
                $options = $select.find('option'),
                activeClass = 'tcr-texture-select-active',
                $wrap = $('<div class="tcr-texture-selector"/>');
                
                $options.each(function () {
                    var $this = $(this);
                    
                    var $layout = $('<div class="tcr-texture-option"/>').appendTo($wrap).click(function () {
                        $wrap.find('> div').removeClass(activeClass);
                        $layout.addClass(activeClass);
                        $select.val($this.val());
                    }).append('<img src="' + tcrL10n.themeAdminUrl + '/images/textures/' + ($this.val() || 'default') + '.gif" alt="" />')
                    .attr('title', $this.text());
                    
                    if ($this.is(':selected')) {
                        $layout.addClass(activeClass);
                    }
                });

                $select.hide().after($wrap);
	        });
	        
	        // Tooltips
	        $('.tcr-tip-icon, .tcr-tooltip').qtip({
                text: false,
                style: {
                    classes: 'ui-tooltip-op ui-tooltip-dark',
                    border: { color: '#000000' },
                    tip: {
                        color: 'false'
                    }
                },
                position: {
                    my: 'bottom center',
                    at: 'top center'
                }
            });
	        
	        $('.tcr-tooltip-wrap').qtip({
                style: {
                    classes: 'ui-tooltip-op ui-tooltip-dark',
                    border: { color: '#000000' },
                    tip: {
                        color: 'false'
                    }
                },
                position: {
                    my: 'bottom center',
                    at: 'top center'
                },
                content: {
                    text: function (api) {
                        return $(this).find('.tcr-tooltip-content').html();
                    }
                }
	        });
	        
	        $('.tcr-facebook, .tcr-support, .tcr-tc-portfolio').qtip('option', {
	            'position.my': 'center right',
	            'position.at': 'center left'
	        })
			
			// Background uploader
			var $backgroundUploadButton = $('#background_upload'),
			$backgroundUploadSpinner = $('.tcr-upload-bg-button-wrap .tcr-loading');
			
			tcr.addUploader({
				button_height: $backgroundUploadButton.actual('outerHeight'),
		        button_width: $backgroundUploadButton.actual('outerWidth'),
				button_placeholder_id: 'background_upload_browse',
				file_types: '*.gif; *.jpg; *.jpeg; *.png',
				file_types_description: tcrL10n.imageFiles,
				file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
					if (numFilesQueued > 0) {
						this.startUpload();
						$backgroundUploadSpinner.show();
					}
				},
				upload_success_handler: function (file, response, serverResponse) {
					if (response == null) {
                        console.log(file);
                        console.log(response);
                        console.log(serverResponse);
                        alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.');
			    	} else {
			    	    try {
			    	        response = JSON.parse(response);    		
    			    		if (typeof response === 'object' && response.type === 'success') {
    				    		var url = tcrL10n.timthumbUrl + '?src=' + tcrL10n.siteUrl + response.data.url + '&w=148&h=83&q=100',
				    			$img = $('<img/>'),
				    			$div = $('<div class="tcr-uploaded-image tcr-bg-image"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div class="tcr-delete-uploaded-image" title="' + tcrL10n.deleteImage + '"></div><div title="' + tcrL10n.editSettings + '" class="tcr-edit-background-image"></div></div></div></div>')
				    				    .data({
				    				    	'tcr-url': response.data.url,
			    				    		'tcr-file': response.data.file,
			    				    		'tcr-title': '',
			    				    		'tcr-caption': '',
			    				    		'tcr-caption-position': ''
	    				    			})
				    				    .hide()
				    				    .append($img);
    				    		
    				    		$('#background_backgrounds').append($div);
    
    				    		$img.load(function () {
    				    			$img.unbind('load');
    				    			$(this).parent().fadeIn('slow');
    				    		}).attr('src', url);
    			    		}
			    	    } catch (ex) {
			    	        console.log(ex);
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
			    	    }
			    	}
				},
				queue_complete_handler: function () {
					$backgroundUploadSpinner.hide();
				},
				post_params: {
					action: 'tcr_swfupload_upload_ajax',
		    		_wpnonce: tcrL10n.swfuploadNonce
				}
			});
			
			$('.tcr-bg-image .tcr-delete-uploaded-image').live('click', function () {
			    $(this).closest('.tcr-bg-image').remove();
			});
			
			// Editing background
			var $currentlyEditingBg,
			$bgSettingsForm = $('#tcr-background-settings-overlay'),
			$bgTitle = $('#tcr-background-title'),
			$bgCaption = $('#tcr-background-caption'),
			$bgCaptionPosition = $('#tcr-background-caption-position'),
			closeBgSettings = function () {
				$bgSettingsForm.hide();
				$bgTitle.add($bgCaption).add($bgCaptionPosition).val('');
				$(document).unbind('keyup.edit-background-image');
			},
			saveBgSettings = function () {
			    $currentlyEditingBg.data({
                    'tcr-title': $bgTitle.val(),
                    'tcr-caption': $bgCaption.val(),
                    'tcr-caption-position': $bgCaptionPosition.val()
                });             
                closeBgSettings();
			},
			$buttonWrap = $('<div class="tcr-overlay-buttons"/>').appendTo($('#tcr-background-settings'));
			
			$('.tcr-bg-image .tcr-edit-background-image').live('click', function (e) {
				$bgSettingsForm.show();
				$currentlyEditingBg = $(this).closest('.tcr-bg-image');
				$bgTitle.val($currentlyEditingBg.data('tcr-title'));
				$bgCaption.val($currentlyEditingBg.data('tcr-caption'));
				$bgCaptionPosition.val($currentlyEditingBg.data('tcr-caption-position'));
				$(document).bind('keyup.edit-background-image', function (e) {
					if (e.keyCode === 27) {
						closeBgSettings();
					}
				});
			});
			
			$('#tcr-background-caption-save').click(function () {
			    saveBgSettings();
			});
			
			$('#tcr-background-caption-cancel').click(closeBgSettings);
			
			$('<div class="tcr-overlay-button tcr-overlay-button-close"/>').click(function () {
			    closeBgSettings();
	        }).appendTo($buttonWrap).attr('title', tcrL10n.cancel);
	        
	        $('<div class="tcr-overlay-button tcr-overlay-button-save"/>').click(function () {
	            saveBgSettings();
	        }).appendTo($buttonWrap).attr('title', tcrL10n.save);
	        
			// Make the uploaded background sortable
			$('#background_backgrounds').sortable({
			    placeholder: 'tcr-uploaded-image tcr-bg-image tcr-sortable-placeholder'
			});
			
			// Background image groups
			var getNextGroupId = function () {
			    var groupId = $('#tcr-background-groups .tcr-background-group').length;
			    
			    while($('#background_group_name_' + groupId).length) {
			        groupId++;
                }
                
                return groupId;
			},
			$tcrBackgroundGroups = $('#tcr-background-groups');	
			
			$('#tcr-add-background-group-button').click(function () {
			    var groupId = getNextGroupId();
			    
			    var $group = $('<div id="tcr-background-group-' + groupId + '" class="tcr-background-group tcr-upload-holder tcr-clearfix">\
                        <div class="tcr-background-group-inner tcr-clearfix">\
                        <div class="tcr-delete-background-group" title="TODO' + tcrL10n.delete_group + '"></div>\
                        <div class="tcr-edit-background-group" title="TODO' + tcrL10n.edit_group + '"></div>\
                        <div class="tcr-background-group-name">\
                            <span class="tcr-background-group-name-inner">' + tcrL10n.untitled + '</span>\
                            <input type="text" class="tcr-background-group-name-input tcr-width-150" value="' + tcrL10n.untitled + '" />\
                        </div>\
                        <div class="tcr-background-group-settings">\
                            <div class="tcr-background-group-upload-wrap tcr-clearfix">\
                                <div class="tcr-swfupload-button tcr-background-group-upload">' + tcrL10n.upload + '<div id="background_group_browse_' + groupId + '"></div></div>\
                                <div class="tcr-loading"></div>\
                            </div>\
                            <div class="tcr-background-group-images">\
                            </div>\
                        </div>\
                    </div>\
                </div>');
			    
			    $tcrBackgroundGroups.append($group);
			    
			    $group.find('.tcr-edit-background-group').click()
			    .end().find('.tcr-background-group-name-input').focus();
			    
			    ThemeCatcher.addBackgroundGroupUploader($group);
			    
			    $group.find('.tcr-background-group-images').sortable();
			    
			    return false;
			});
			
			// Set up uploaders for existing background groups
			$('.tcr-background-group').each(function () {
			    ThemeCatcher.addBackgroundGroupUploader($(this));
			});
			
			// Existing uploaded backgrounds sortable
			$('.tcr-background-group-images').sortable();
			
			$tcrBackgroundGroups.delegate('.tcr-edit-background-group', 'click', function () {
			    var $editButton = $(this),
			    $root = $editButton.closest('.tcr-background-group'),
                $settings = $root.find('.tcr-background-group-settings'),
                $nameLabel = $root.find('.tcr-background-group-name-inner'),
                $nameInput = $root.find('.tcr-background-group-name-input');
                
                if ($editButton.hasClass('tcr-open')) {
                    $settings.add($nameInput).hide();
                    $nameLabel.text($nameInput.val()).show();
                    $editButton.removeClass('tcr-open');
                } else {
                    $nameLabel.hide();
                    $settings.add($nameInput).show();
                    $editButton.addClass('tcr-open');
                }
			});
			
			$tcrBackgroundGroups.delegate('.tcr-delete-background-group', 'click', function () {
			    $(this).closest('.tcr-background-group').remove();
			});
						
			// Background video data check
			$('#background_video').bind('blur', function () {
				var url = $(this).val();
				
				if (url) {
					var vimeoPattern = /http(s)?:\/\/(www\.)?vimeo.com\/(\d+)($|\/)/,
					vimeoMatch = url.match(vimeoPattern);

					if (vimeoMatch) {
						var videoId = vimeoMatch[3];
						if (videoId) {
							$.getJSON('http://vimeo.com/api/v2/video/' + videoId + '.json?callback=?', function (response) {
								if (response !== null && typeof response[0] === 'object' && response[0].width && response[0].height) {
									$('#background_video_width').val(response[0].width);
									$('#background_video_height').val(response[0].height);
								}
							});
						}						
					}
				} else {
				    $('#background_video_width').val('');
                    $('#background_video_height').val('');
				}
			});
			
			// Background audio
	        var getNextTrackId = function () {
	            var trackId = $('#tcr-audio-tracks > .tcr-audio-track').length;

	            while($('#background_audio_track_m4a_' + trackId).length) {
	                trackId++;
	            }
	            
	            return trackId;
	        },
	        $tcrAudioTracks = $('#tcr-audio-tracks');
	        
	        $('#tcr-add-audio-track-button').click(function () {
	            var trackId = getNextTrackId();
	            
	            var $track = $('<div id="tcr-audio-track-' + trackId + '" class="tcr-audio-track tcr-clearfix">\
	                <div class="tcr-audio-track-inner">\
	                    <div class="tcr-delete-audio-track" title="' + tcrL10n.deleteTrack + '"></div>\
	                    <div class="tcr-edit-audio-track" title="' + tcrL10n.editTrack + '"></div>\
	                    <div class="tcr-drag-audio-track" title="' + tcrL10n.moveTrack + '"></div>\
	                    <div class="tcr-audio-track-name">\
	                        <span class="tcr-audio-track-name-inner">' + tcrL10n.untitled + '</span>\
	                        <input type="text" class="tcr-audio-track-name-input tcr-width-150" value="' + tcrL10n.untitled + '" />\
	                    </div>\
	                    <div class="tcr-audio-track-settings">\
	                        <table class="tcr-audio-track-settings">\
	                            <tr class="tcr-audio-format-title">\
	                                <th colspan="2">' + tcrL10n.m4aFileUrl + '</th>\
								</tr>\
								<tr class="tcr-audio-format">\
	                                <td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-m4a" value="" /></td>\
	                                <td class="tcr-audio-format-upload-td">\
	                                    <div class="tcr-upload-audio-track-button-wrap tcr-clearfix">\
	                                        <div class="tcr-upload-audio-format-button tcr-swfupload-button">' + tcrL10n.upload + '<div id="background_audio_format_m4a_' + trackId + '"></div></div>\
	                                        <div class="tcr-loading"></div>\
	                                    </div>\
	                                </td>\
	                            </tr>\
	                            <tr class="tcr-audio-format-title">\
	                                <th colspan="2">' + tcrL10n.mp3FileUrl + '</th>\
								</tr>\
								<tr class="tcr-audio-format">\
	                                <td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-mp3" value="" /></td>\
	                                <td class="tcr-audio-format-upload-td">\
	                                    <div class="tcr-upload-audio-track-button-wrap tcr-clearfix">\
	                                        <div class="tcr-upload-audio-format-button tcr-swfupload-button">' + tcrL10n.upload + '<div id="background_audio_format_mp3_' + trackId + '"></div></div>\
	                                        <div class="tcr-loading"></div>\
	                                    </div>\
	                                </td>\
	                            </tr>\
	                            <tr class="tcr-audio-format-title">\
	                                <th colspan="2">' + tcrL10n.oggFileUrl + '</th>\
								</tr>\
								<tr class="tcr-audio-format">\
	                                <td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-ogg" value="" /></td>\
	                                <td class="tcr-audio-format-upload-td">\
	                                    <div class="tcr-upload-audio-track-button-wrap tcr-clearfix">\
	                                        <div class="tcr-upload-audio-format-button tcr-swfupload-button">' + tcrL10n.upload + '<div id="background_audio_format_ogg_' + trackId + '"></div></div>\
	                                        <div class="tcr-loading"></div>\
	                                    </div>\
	                                </td>\
	                            </tr>\
	                        </table>\
	                    </div>\
	                </div>\
	            </div>');
	            
	            $tcrAudioTracks.append($track);
	            
	            $track.find('.tcr-edit-audio-track').click()
	            .end().find('.tcr-audio-format-m4a').focus();
	            
	            ThemeCatcher.addAudioUploaders($track);
	            
	            return false;
	        });
	        
	        // Make the tracks sortable
	        $tcrAudioTracks.sortable({
	            handle: '.tcr-drag-audio-track'
	        });
	        	        
	        // Edit audio track
	        $tcrAudioTracks.delegate('.tcr-edit-audio-track', 'click', function () {
	            var $editButton = $(this),
	            $root = $editButton.closest('.tcr-audio-track'),
	            $settings = $root.find('.tcr-audio-track-settings'),
	            $nameLabel = $root.find('.tcr-audio-track-name-inner'),
                $nameInput = $root.find('.tcr-audio-track-name-input');
	            
	            if ($editButton.hasClass('tcr-open')) {
                    $settings.add($nameInput).hide();
                    $nameLabel.show();
                    $editButton.removeClass('tcr-open');
                } else {
                    $nameLabel.hide();
                    $settings.add($nameInput).show();
                    $editButton.addClass('tcr-open');
                }
	        });
	        
	        // Change track name when typed
	        $tcrAudioTracks.delegate('.tcr-audio-track-name-input', 'keyup blur', function () {
	            var $this = $(this);
	            $this.siblings('.tcr-audio-track-name-inner').text($this.val());
            });
	        
	        // Delete audio track
	        $tcrAudioTracks.delegate('.tcr-delete-audio-track', 'click', function () {
	            $(this).closest('.tcr-audio-track').remove();
	        });
	        
	        // Set up audio uploaders
	        $('.tcr-audio-track').each(function () {
	            ThemeCatcher.addAudioUploaders($(this));
	        });
						
			// Logo uploader
			var $logoUploadButton = $('#general_logo_upload'),
			$logoUploadSpinner = $('.tcr-upload-logo-button-wrap .tcr-loading');
			
			tcr.addUploader({
				button_height: $logoUploadButton.actual('outerHeight'),
		        button_width: $logoUploadButton.actual('outerWidth'),
				button_placeholder_id: 'general_logo_upload_browse',
                file_types: '*.gif; *.jpg; *.jpeg; *.png',
                file_types_description: tcrL10n.imageFiles,
				file_queue_limit: 1,
				file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
				    if (numFilesQueued > 0) {
						this.startUpload();
						$logoUploadSpinner.show();			
					}
				},
				upload_success_handler: function (file, response, serverResponse) {
					if (response == null) {
                        console.log(file);
                        console.log(response);
                        console.log(serverResponse);
                        alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.'); 
			    	} else {
			    		try {
				    		response = JSON.parse(response);
				    		if (typeof response === 'object' && response.type === 'success') {
				    			$('#general_logo').val(response.data.url);
				    			
					    		var url = tcrL10n.timthumbUrl + '?src=' + tcrL10n.siteUrl + response.data.url + '&w=100&q=100',
					    			$img = $('<img/>'),
					    			$div = $('<div class="tcr-uploaded-image tcr-logo"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div class="tcr-delete-uploaded-image" title="' + tcrL10n.deleteImage + '"></div></div></div></div>').hide().append($img);
					    		
					    		$('#general_logo_upload_holder').html($div).show();
			
					    		$img.load(function () {
					    			$img.unbind('load');
					    			$(this).parent().fadeIn('slow');
					    		}).attr('src', url);
				    		}
			    		} catch (ex) {
			    		    console.log(ex);
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
			    		}
			    	}
				},
				file_queue_error_handler: function () {
				    alert(tcrL10n.uploadTooManyFiles);
				    $logoUploadSpinner.hide();
				},
				upload_complete_handler: function () {
					$logoUploadSpinner.hide();
				},
				post_params: {
					action: 'tcr_swfupload_upload_ajax',
		    		_wpnonce: tcrL10n.swfuploadNonce
				}
			});
			
			$('.tcr-logo .tcr-delete-uploaded-image').live('click', function () {
				$('#general_logo').val('');
				$(this).closest('.tcr-logo').remove();
				$('#general_logo_upload_holder').hide();
			});
			
			// Favicon uploader
            var $faviconUploadButton = $('#general_favicon_upload'),
            $faviconUploadSpinner = $('.tcr-upload-favicon-button-wrap .tcr-loading');
            
            tcr.addUploader({
                button_height: $faviconUploadButton.actual('outerHeight'),
                button_width: $faviconUploadButton.actual('outerWidth'),
                button_placeholder_id: 'general_favicon_upload_browse',
                file_types: '*.ico; *.gif; *.jpg; *.jpeg; *.png',
                file_types_description: tcrL10n.imageFiles,
                file_queue_limit: 1,
                file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
                    if (numFilesQueued > 0) {
                        this.startUpload();
                        $faviconUploadSpinner.show();          
                    }
                },
                upload_success_handler: function (file, response, serverResponse) {
                    if (response == null) {
                        console.log(file);
                        console.log(response);
                        console.log(serverResponse);
                        alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.'); 
                    } else {
                        try {
                            response = JSON.parse(response);
                            if (typeof response === 'object' && response.type === 'success') {
                                $('#general_favicon').val(response.data.url);
                            }
                        } catch (ex) {
                            console.log(ex);
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
                        }
                    }
                },
                file_queue_error_handler: function () {
                    alert(tcrL10n.uploadTooManyFiles);
                    $faviconUploadSpinner.hide();
                },
                upload_complete_handler: function () {
                    $faviconUploadSpinner.hide();
                },
                post_params: {
                    action: 'tcr_swfupload_upload_ajax',
                    _wpnonce: tcrL10n.swfuploadNonce
                }
            });
			
			// Color pickers
			$('.tcr-colorpicker').each(function () {
			    var $this = $(this),
			    $indicator = $('<div class="tcr-color-indicator"/>').insertAfter($this);
			    
			    $this.ColorPicker({			
                    onSubmit: function(hsb, hex, rgb, el) {
                        $(el).val('#' + hex);
                        $indicator.css('background-color', '#' + hex);
                        $(el).ColorPickerHide();
                    },
                    onBeforeShow: function () {
                        $(this).ColorPickerSetColor(this.value);
                    },
                    onChange: function (hsb, hex, rgb) {
                        $($(this).data('colorpicker').el).val('#'+hex);
                        $indicator.css('background-color', '#' + hex);
                    }
                })
                .bind('keyup blur', function(){
                    var val = $this.val();
                    $this.ColorPickerSetColor(val);
                    $indicator.css('background-color', $this.val());
                });
			    
			    $indicator.click(function () {
			        $this.click();
			    });
			    
			    if ($this.val()) {
			        $indicator.css('background-color', $this.val());
			    }
			});
			
			// Fonts
			var $fontSelect = $('#general_font'),
			$allFontPreviews = $('.tcr-font-preview');
			
			$allFontPreviews.filter('[data-tcr-font="' + $fontSelect.val() + '"]').addClass('tcr-selected-font');
			
			$fontSelect.change(function () {
			    $allFontPreviews.removeClass('tcr-selected-font')
			                    .filter('[data-tcr-font="' + $fontSelect.val() + '"]')
			                    .addClass('tcr-selected-font');
			});
			
			$allFontPreviews.click(function () {
                var $this = $(this);
                $allFontPreviews.removeClass('tcr-selected-font');
                $this.addClass('tcr-selected-font');
                $fontSelect.val($this.data('tcr-font'));
            });						
			
			$('#background_video_complete').change(function () {
			    if ($(this).val() == 'redirect') {
                    $('#background_video_redirect_wrap').show();
                } else {
                    $('#background_video_redirect_wrap').hide();
                }
			}).change();
									
			$('#tcr-start-export').click(function () {
				ThemeCatcher.update();
				
				var onSuccess = function (response) {
					$('#tcr-export-textarea-wrap').show();
					$('#advanced_export').val(response.data);
				},
				onError = function () {
					console.log(arguments);
					alert('An error occurred fetching the export data. You may find more information in the browser console.');
				};
				
				$.ajax({
					type: 'POST',
					url: ajaxurl,
					data: {
						action: 'tcr_export_options_ajax',
						options: JSON.stringify(ThemeCatcher.options),
						_ajax_nonce: tcrL10n.exportNonce
					},			        
					dataType: 'json',
					success: function (response) {
						if (response === null) {						
							if (typeof onError === 'function') {
								onError.apply(this, arguments);
							}
						} else if (typeof response === 'object') {
							if (response.type == 'success') {
								if (typeof onSuccess === 'function') {
									onSuccess.apply(this, arguments);
								}
							} else if (response.type == 'error') {
								if (typeof onError === 'function') {
									onError.apply(this, arguments);
								}
							}
						} else {
							if (typeof onError === 'function') {
								onError.apply(this, arguments);
							}
						}
					},
					error: function () {
						if (typeof onError === 'function') {
							onError.apply(this, arguments);
						}
					}
				});
				return false;
			});
			
			$('#advanced_export').click(function () {
				$(this).select();
			});
			
			$('#tcr-start-import').click(function () {			    
			    var $status = $('#tcr-import-status').html(''),
			    onError = function () {
                    console.log(arguments);
                    alert('An error occurred when importing the data. You may find more information in the browser console.');
                },
			    onSuccess = function (response) {
			        $status.append('<p>'+ tcrL10n.flushingRewriteRules + '...</p>');
			        
			        $.ajax({
                        type: 'POST',
                        url: ajaxurl,
                        data: {
                            action: 'tcr_flush_rewrite_rules_ajax'
                        },
                        success: function () {
                            $status.append('<p>'+ tcrL10n.reloadingPage + '...</p>');
                            setTimeout(function () {
                                window.location = '?page=ThemeCatcher&message=import';
                            }, 1000);                            
                        },
                        error: function () {
                            onError.apply(this, arguments);
                        }
                    });
                    
                };
                
                $status.append('<p>'+ tcrL10n.startingImport + '...</p>');
                
                $.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: {
                        action: 'tcr_import_options_ajax',
                        options: $('#advanced_import').val(),
                        _ajax_nonce: tcrL10n.importNonce
                    },                  
                    dataType: 'json',
                    success: function (response) {
                        if (response === null) {                        
                            if (typeof onError === 'function') {
                                onError.apply(this, arguments);
                            }
                        } else if (typeof response === 'object') {
                            if (response.type == 'success') {
                                if (typeof onSuccess === 'function') {
                                    onSuccess.apply(this, arguments);
                                }
                            } else if (response.type == 'error') {
                                $status.append('<p>'+response.message+'</p>');
                            }
                        } else {
                            if (typeof onError === 'function') {
                                onError.apply(this, arguments);
                            }
                        }
                    },
                    error: function () {
                        if (typeof onError === 'function') {
                            onError.apply(this, arguments);
                        }
                    }
                });
                return false;
			});
			
			$('.tcr-save').click(function () {
			    ThemeCatcher.update();
			    
			    var $button = $(this).removeClass('tcr-save-save').addClass('tcr-save-saving');
	            
	            var onSuccess = function (response) {
	                $button.removeClass('tcr-save-saving').addClass('tcr-save-saved');
	                $('#tcr-options-saved').fadeIn(200).show(0, function () {	                    
	                    setTimeout(function () { 
	                        $('#tcr-options-saved').fadeOut(200);
	                        $button.removeClass('tcr-save-saved').addClass('tcr-save-save');
                        }, 800);
	                });
	                
	                if (response.flush) {
	                    $.ajax({
	                        type: 'POST',
	                        url: ajaxurl,
	                        data: {
	                            action: 'tcr_flush_rewrite_rules_ajax'
	                        }
	                    });
	                }
	            },
	            onError = function () {
	                $button.removeClass('tcr-save-saving').addClass('tcr-save-save');
	                console.log(arguments);
	                alert('An error occurred saving the options. You may find more information in the browser console.');
	            };
	            
	            $.ajax({
	                type: 'POST',
	                url: ajaxurl,
	                data: {
	                   action: 'tcr_save_options_ajax',
	                   _ajax_nonce: tcrL10n.saveNonce,
	                   options: JSON.stringify(ThemeCatcher.options)
	                },
	                dataType: 'json',
	                success: function (response) {
	                    if (response === null) {                        
	                        if (typeof onError === 'function') {
	                            onError.apply(this, arguments);
	                        }
	                    } else if (typeof response === 'object') {
	                        if (response.type == 'success') {
	                            if (typeof onSuccess === 'function') {
	                                onSuccess.apply(this, arguments);
	                            }
	                        } else if (response.type == 'error') {
	                            if (typeof onError === 'function') {
	                                onError.apply(this, arguments);
	                            }
	                        }
	                    }
	                },
	                error: function () {
	                    if (typeof onError === 'function') {
	                        onError.apply(this, arguments);
	                    }
	                }
	            });
	            
	            return false;
			});
			
			$('#tcr-reset-options').click(function () {
			    if (confirm(tcrL10n.confirmResetOptions)) {
	                var onSuccess = function (response) {                   
	                    $.ajax({
	                        type: 'POST',
	                        url: ajaxurl,                        
	                        data: {
	                            action: 'tcr_flush_rewrite_rules_ajax'
	                        },
	                        success: function () {
                                window.location = '?page=ThemeCatcher&message=reset';                            
	                        }
	                    });
	                    
	                },
	                onError = function () {
	                    console.log(arguments);
	                    alert('An error occurred resetting the options. You may find more information in the browser console.');
	                };
	                                
	                $.ajax({
	                    type: 'POST',
	                    url: ajaxurl,
	                    data: {
	                        action: 'tcr_reset_options_ajax',
	                        _ajax_nonce: tcrL10n.resetNonce
	                    },                  
	                    dataType: 'json',
	                    success: function (response) {
	                        if (response === null) {                        
	                            if (typeof onError === 'function') {
	                                onError.apply(this, arguments);
	                            }
	                        } else if (typeof response === 'object') {
	                            if (response.type == 'success') {
	                                if (typeof onSuccess === 'function') {
	                                    onSuccess.apply(this, arguments);
	                                }
	                            } else if (response.type == 'error') {
	                                if (typeof onError === 'function') {
	                                    onError.apply(this, arguments);
	                                }
	                            }
	                        } else {
	                            if (typeof onError === 'function') {
	                                onError.apply(this, arguments);
	                            }
	                        }
	                    },
	                    error: function () {
	                        if (typeof onError === 'function') {
	                            onError.apply(this, arguments);
	                        }
	                    }
	                });
	            }
			    
			    return false;
			});
			
			$('#tcr-reset-translations').click(function () {
			    if (confirm(tcrL10n.confirmResetTranslations)) {
			        $('input[name^="translate_"]', ThemeCatcher.$form).val('');
			    }
			});			
		}, // end init()
				
		/**
		 * Update the JavaScript object to match the form values
		 */
		update: function () {			
			ThemeCatcher.options = ThemeCatcher.$form.serializeObject();
			
			// Background images
			var backgrounds = [];
			$('#background_backgrounds > div').each(function () {
			    var $image = $(this);
				backgrounds.push({url: $image.data('tcr-url'), file: $image.data('tcr-file'), title: $image.data('tcr-title'), caption: $image.data('tcr-caption'), captionPosition: $image.data('tcr-caption-position')});
			});
			ThemeCatcher.options['background_backgrounds'] = backgrounds;
			
			// Background groups
			var groups = [];
			$('.tcr-background-group').each(function () {
			    var $group = $(this),
			    backgrounds = [];
			    
			    $group.find('.tcr-background-group-images > div').each(function () {
			        var $image = $(this);
			        backgrounds.push({url: $image.data('tcr-url'), file: $image.data('tcr-file'), title: $image.data('tcr-title'), caption: $image.data('tcr-caption'), captionPosition: $image.data('tcr-caption-position')});
			    });
			    
			    groups.push({
			        name: $group.find('.tcr-background-group-name-input').val(),
			        backgrounds: backgrounds
			    });
			});
			ThemeCatcher.options['background_groups'] = groups;
			
			// Audio tracks
			var tracks = [];
			$('#tcr-audio-tracks > div').each(function () {
				var $track = $(this);
				tracks.push({name: $track.find('.tcr-audio-track-name-input').val(), m4a: $track.find('.tcr-audio-format-m4a').val(), mp3: $track.find('.tcr-audio-format-mp3').val(), oga: $track.find('.tcr-audio-format-ogg').val()});
			});
			ThemeCatcher.options['background_audio'] = tracks;			
		},
		
		/**
         * Set up the audio uploaders for the given track
         * 
         * @param object $track
         */
		addAudioUploaders: function ($track) {
            $track.find('.tcr-audio-format').each(function () {
                var $root = $(this),
                $input = $root.find('.tcr-audio-format-input'),
                $uploadButton = $root.find('.tcr-upload-audio-format-button'),
                placeholderId = $uploadButton.find('div:first-child').attr('id'),
                $progress = $('<div class="tcr-audio-upload-progress"></div>');
    
                tcr.addUploader({
                    button_height: $uploadButton.actual('outerHeight'),
                    button_width: $uploadButton.actual('outerWidth'),
                    button_placeholder_id: placeholderId,
                    file_queue_limit: 1,
                    file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
                        if (numFilesQueued > 0) {
                            this.startUpload();
                            $input.after($progress);
                        }
                    },
                    upload_success_handler: function (file, response, serverResponse) {
                        if (response == null) {
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.');                        
                        } else {
                            try {
                                response = JSON.parse(response);
                                if (typeof response === 'object' && response.type === 'success') {
                                    $input.val(response.data.url);
                                }
                            } catch (ex) {
                                console.log(ex);
                                console.log(file);
                                console.log(response);
                                console.log(serverResponse);
                                alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
                            }
                        }
                    },
                    upload_progress_handler: function (file, bytesCompleted, totalBytes) {
                        if (totalBytes > 0) {
                            var progress = ((bytesCompleted/totalBytes) * 100);
                            $progress.width(progress + '%');
                        }
                    },                    
                    upload_complete_handler: function () {
                        $progress.remove();
                    },
                    file_queue_error_handler: function () {
                        alert(tcrL10n.uploadTooManyFiles);
                        $progress.remove();
                    },
                    post_params: {
                        action: 'tcr_swfupload_upload_audio_ajax',
                        _wpnonce: tcrL10n.swfuploadNonce
                    }
                });         
            });
        },
        
        /**
         * Set up the image uploader for the given background group
         * 
         * @param object $group
         */
        addBackgroundGroupUploader: function ($group) {
            var $uploadButton = $group.find('.tcr-background-group-upload'),
            placeholderId = $uploadButton.find('div').attr('id'),
            $backgroundUploadSpinner = $group.find('.tcr-background-group-upload-wrap .tcr-loading'),
            $uploadHolder = $group.find('.tcr-background-group-images');

            tcr.addUploader({
                button_height: $uploadButton.actual('outerHeight'),
                button_width: $uploadButton.actual('outerWidth'),
                button_placeholder_id: placeholderId,
                file_types: '*.gif; *.jpg; *.jpeg; *.png',
                file_types_description: tcrL10n.imageFiles,
                file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
                    if (numFilesQueued > 0) {
                        this.startUpload();
                        $backgroundUploadSpinner.show();
                    }
                },
                upload_success_handler: function (file, response, serverResponse) {
                    if (response == null) {
                        console.log(file);
                        console.log(response);
                        console.log(serverResponse);
                        alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.');                        
                    } else {
                        try {
                            response = JSON.parse(response);
                            if (typeof response === 'object' && response.type === 'success') {
                                var url = tcrL10n.timthumbUrl + '?src=' + tcrL10n.siteUrl + response.data.url + '&w=148&h=83&q=100',
                                $img = $('<img/>'),
                                $div = $('<div class="tcr-uploaded-image tcr-bg-image"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div class="tcr-delete-uploaded-image" title="' + tcrL10n.deleteImage + '"></div><div title="' + tcrL10n.editSettings + '" class="tcr-edit-background-image"></div></div></div></div>')
                                        .data({
                                            'tcr-url': response.data.url,
                                            'tcr-file': response.data.file,
                                            'tcr-title': '',
                                            'tcr-caption': '',
                                            'tcr-caption-position': ''
                                        })
                                        .hide()
                                        .append($img);

                                $uploadHolder.append($div);
    
                                $img.load(function () {
                                    $img.unbind('load');
                                    $(this).parent().fadeIn('slow');
                                }).attr('src', url);
                            }
                        } catch (ex) {
                            console.log(ex);
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
                        }
                    }
                },
                queue_complete_handler: function () {
                    $backgroundUploadSpinner.hide();
                },
                post_params: {
                    action: 'tcr_swfupload_upload_ajax',
                    _wpnonce: tcrL10n.swfuploadNonce
                }
            });
        }        
	}; // End ThemeCatcher object
		
	// Convert the form to a serialized object
	$.fn.serializeObject = function() {
	    var o = {};
	    var a = this.serializeArray();
	    $.each(a, function() {
	        if (o[this.name]) {
	            if (!o[this.name].push) {
	                o[this.name] = [o[this.name]];
	            }
	            o[this.name].push(this.value || '');
	        } else {
	            o[this.name] = this.value || '';
	        }
	    });
	    return o;
	};	
})(jQuery, window);