/*
 * ThemeCatcher Metabox JavaScript
 * 
 * Copyright www.themecatcher.net
 * All rights reserved.
 */
;(function ($) {
    $(document).ready(function () {	
    	// Background uploader
    	if ($('#_tcr_backgrounds_upload_browse').length) {
    		var $backgroundUploadButton = $('#_tcr_backgrounds_upload_button'),
    		$backgroundUploadSpinner = $backgroundUploadButton.parent().find('.tcr-loading');
    		
    		var updatePostBackgrounds = function () {
    			// Background images
    			var backgrounds = [];
    			$('#_tcr_backgrounds_uploaded > div').each(function () {
    				backgrounds.push({url: $(this).data('tcr-url'), file: $(this).data('tcr-file'), title: $(this).data('tcr-title'), caption: $(this).data('tcr-caption'), captionPosition: $(this).data('tcr-caption-position')});
    			});
    			$('#_tcr_backgrounds').val(JSON.stringify(backgrounds));
    		};
    		
    		tcr.addUploader({
    			button_height: $backgroundUploadButton.actual('outerHeight'),
    	        button_width: $backgroundUploadButton.actual('outerWidth'),
    			button_placeholder_id: '_tcr_backgrounds_upload_browse',
                file_types: '*.gif; *.jpg; *.jpeg; *.png',
                file_types_description: tcrL10n.imageFiles,
    			file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
    				if (numFilesQueued > 0) {
    					this.startUpload();
    					$backgroundUploadSpinner.show();
    				}
    			},
    			upload_success_handler: function (file, response, serverResponse) {
    				if (response == null) {
    				    console.log(file);
                        console.log(response);
                        console.log(serverResponse);
                        alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.');
    		    	} else {
    		    	    try {
        		    		response = JSON.parse(response);
        		    		if (typeof response === 'object' && response.type === 'success') {
        			    		var url = tcrL10n.timthumbUrl + '?src=' + tcrL10n.siteUrl + response.data.url + '&w=148&h=83&q=100',
        			    			$img = $('<img/>'),
        			    			$div = $('<div class="tcr-uploaded-image tcr-bg-image"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div class="tcr-delete-uploaded-image" title="' + tcrL10n.deleteImage + '"></div><div title="' + tcrL10n.editSettings + '" class="tcr-edit-background-image"></div></div></div></div>')
        	    				    .data({
            				    		'tcr-url': response.data.url,
            				    		'tcr-file': response.data.file,
            				    		'tcr-title': '',
            				    		'tcr-caption': '',
            				    		'tcr-caption-position': ''
        	    				    })
        	    				    .hide()
        	    				    .append($img);
        			    		
        			    		$('#_tcr_backgrounds_uploaded').append($div);
        			    		
        			    		updatePostBackgrounds();
        	
        			    		$img.load(function () {
        			    			$img.unbind('load');
        			    			$(this).parent().fadeIn('slow');
        			    		}).attr('src', url);
        		    		}
    		    	    } catch (ex) {
                            console.log(ex);
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
                        }
    		    	}
    			},
    			upload_complete_handler: function () {
    				$backgroundUploadSpinner.hide();
    			},
    			post_params: {
    				action: 'tcr_swfupload_upload_ajax',
    	    		_wpnonce: tcrL10n.swfuploadNonce
    			}
    		});
    		
    		$('#_tcr_backgrounds_uploaded .tcr-delete-uploaded-image').live('click', function () {
    		    $(this).closest('.tcr-bg-image').remove();
    			updatePostBackgrounds();
    		});
    		
    		// Editing background
    		var $currentlyEditingBg,
    		$bgSettingsForm = $('#tcr-background-settings-overlay'),
    		$bgTitle = $('#tcr-background-title'),
    		$bgCaption = $('#tcr-background-caption'),
    		$bgCaptionPosition = $('#tcr-background-caption-position'),
    		closeBgSettings = function () {
    			$bgSettingsForm.hide();
    			$bgTitle.add($bgCaption).add($bgCaptionPosition).val('');
    			$(document).unbind('keyup.edit-background-image');
    		},
    		saveBgSettings = function () {
    		    $currentlyEditingBg.data({
                    'tcr-title': $bgTitle.val(),
                    'tcr-caption': $bgCaption.val(),
                    'tcr-caption-position': $bgCaptionPosition.val()
                });             
                closeBgSettings();
                updatePostBackgrounds();
    		},
    		$buttonWrap = $('<div class="tcr-overlay-buttons"/>').appendTo($('#tcr-background-settings'));
    		
    		$('.tcr-bg-image .tcr-edit-background-image').live('click', function (e) {
    			$bgSettingsForm.show();
    			$currentlyEditingBg = $(this).closest('.tcr-bg-image');
    			$bgTitle.val($currentlyEditingBg.data('tcr-title'));
    			$bgCaption.val($currentlyEditingBg.data('tcr-caption'));
    			$bgCaptionPosition.val($currentlyEditingBg.data('tcr-caption-position'));
    			$(document).bind('keyup.edit-background-image', function (e) {
    				if (e.keyCode === 27) {
    					closeBgSettings();
    				}
    			});
    		});
    		
    		$('#tcr-background-caption-save').click(function () {
    		    saveBgSettings();
    		});
    		
    		$('#tcr-background-caption-cancel').click(closeBgSettings);
    		
    		$('<div class="tcr-overlay-button tcr-overlay-button-close"/>').click(function () {
                closeBgSettings();
            }).appendTo($buttonWrap).attr('title', tcrL10n.cancel);
            
            $('<div class="tcr-overlay-button tcr-overlay-button-save"/>').click(function () {
                saveBgSettings();
            }).appendTo($buttonWrap).attr('title', tcrL10n.save);
    		
    		if (typeof $.fn.sortable === 'function') {
    			$('#_tcr_backgrounds_uploaded').sortable({
    				stop: updatePostBackgrounds
    			});
    		}
    	}
    	
    	// Tooltips
        $('.tcr-tip-icon, .tcr-tooltip').qtip({
            text: false,
            style: {
                classes: 'ui-tooltip-op ui-tooltip-dark',
                border: { color: '#000000' },
                tip: {
                    color: 'false'
                }
            },
            position: {
                my: 'bottom center',
                at: 'top center'
            }
        });
        
        $('.tcr-tooltip-wrap').qtip({
            style: {
                classes: 'ui-tooltip-op ui-tooltip-dark',
                border: { color: '#000000' },
                tip: {
                    color: 'false'
                }
            },
            position: {
                my: 'bottom center',
                at: 'top center'
            },
            content: {
                text: function (api) {
                    return $(this).find('.tcr-tooltip-content').html();
                }
            }
        });
        
        // Layout selector
        $('.tcr-layout-selector').each(function () {
            var $select = $(this),
            $options = $select.find('option'),
            activeClass = 'tcr-layout-select-active',
            $wrap = $('<div class="tcr-layout-selector"/>');
            
            $options.each(function () {
                var $this = $(this),
                $layout = $('<div class="tcr-layout-option"/>').appendTo($wrap).click(function () {
                    $wrap.find(' > div').removeClass(activeClass);
                    $layout.addClass(activeClass);
                    $select.val($this.val());
                }).append('<img src="' + tcrL10n.themeAdminUrl + '/images/select-layout-' + ($this.val() || 'default') + '.png" alt="" />')
                .attr('title', $this.text());;
                
                if ($this.is(':selected')) {
                    $layout.addClass(activeClass);
                }
            });
    
            $select.hide().after($wrap);
        });
        
        // Texture selector
        $('.tcr-texture-selector').each(function () {
            var $select = $(this),
            $options = $select.find('option'),
            activeClass = 'tcr-texture-select-active',
            $wrap = $('<div class="tcr-texture-selector"/>');
            
            $options.each(function () {
                var $this = $(this);
                
                var $layout = $('<div class="tcr-texture-option"/>').appendTo($wrap).click(function () {
                    $wrap.find('> div').removeClass(activeClass);
                    $layout.addClass(activeClass);
                    $select.val($this.val());
                }).append('<img src="' + tcrL10n.themeAdminUrl + '/images/textures/' + ($this.val() || 'default') + '.gif" alt="" />')
                .attr('title', $this.text());
                
                if ($this.is(':selected')) {
                    $layout.addClass(activeClass);
                }
            });
    
            $select.hide().after($wrap);
        });
    	
    	// Background video data check
        $('#_tcr_background_video').bind('blur', function () {
            var url = $(this).val();
            
            if (url) {
                var vimeoPattern = /http(s)?:\/\/(www\.)?vimeo.com\/(\d+)($|\/)/,
                vimeoMatch = url.match(vimeoPattern);
    
                if (vimeoMatch) {
                    var videoId = vimeoMatch[3];
                    if (videoId) {
                        $.getJSON('http://vimeo.com/api/v2/video/' + videoId + '.json?callback=?', function (response) {
                            if (response !== null && typeof response[0] === 'object' && response[0].width && response[0].height) {
                                $('#_tcr_background_video_width').val(response[0].width);
                                $('#_tcr_background_video_height').val(response[0].height);
                            }
                        });
                    }                       
                }
            } else {
                $('#_tcr_background_video_width').val('');
                $('#_tcr_background_video_height').val('');
            }
        });
    	
    	// Portfolio lightbox image uploader
    	if ($('#_tcr_image_upload_browse').length) {
    		var $imageUploadButton = $('#_tcr_image_upload_button'),
    		$imageUploadSpinner = $imageUploadButton.parent().find('.tcr-loading');
    		
    		var refreshUploads = function () {
    			var uploads = [];
    			$('#_tcr_image_uploaded > div').each(function () {
    				uploads.push({url: $(this).data('tcr-url'), file: $(this).data('tcr-file')});
    			});
    			$('#_tcr_image').val(JSON.stringify(uploads));
    		};
    		
    		tcr.addUploader({
    			button_height: $imageUploadButton.actual('outerHeight'),
    	        button_width: $imageUploadButton.actual('outerWidth'),
    			button_placeholder_id: '_tcr_image_upload_browse',
                file_types: '*.gif; *.jpg; *.jpeg; *.png',
                file_types_description: tcrL10n.imageFiles,
    			file_queue_limit: 1,
    			file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
    				if (numFilesQueued > 0) {
    					this.startUpload();
    					$imageUploadSpinner.show();
    				}
    			},
    			upload_success_handler: function (file, response, serverResponse) {
    				if (response == null) {
    				    console.log(file);
                        console.log(response);
                        console.log(serverResponse);
                        alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.');
    		    	} else {
    		    	    try {
        		    		response = JSON.parse(response);
        		    		if (typeof response === 'object' && response.type === 'success') {
        			    		var url = tcrL10n.timthumbUrl + '?src=' + tcrL10n.siteUrl + response.data.url + '&w=148&h=83&q=100',
        			    			$img = $('<img/>'),
        				    		$div = $('<div class="tcr-uploaded-image"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div class="tcr-delete-uploaded-image" title="' + tcrL10n.deleteImage + '"></div></div></div></div>')
        	    				    .data({'tcr-url': response.data.url, 'tcr-file': response.data.file})
        	    				    .hide()
        	    				    .append($img);
        			    		$('#_tcr_image_uploaded').html($div);
        			    		
        			    		refreshUploads();
        	
        			    		$img.load(function () {
        			    			$img.unbind('load');
        			    			$(this).parent().fadeIn('slow');
        			    		}).attr('src', url);
        		    		}
    		    	    } catch (ex) {
                            console.log(ex);
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
                        }
    		    	}
    			},
                file_queue_error_handler: function () {
                    alert(tcrL10n.uploadTooManyFiles);
                    $imageUploadSpinner.hide();
                },
    			upload_complete_handler: function () {
    				$imageUploadSpinner.hide();
    			},
    			post_params: {
    				action: 'tcr_swfupload_upload_ajax',
    	    		_wpnonce: tcrL10n.swfuploadNonce
    			}
    		});
    		
    		$('#_tcr_image_uploaded .tcr-delete-uploaded-image').live('click', function () {
    		    $(this).closest('.tcr-uploaded-image').remove();
    			refreshUploads();
    		});
    	}
    	
    	$('#_tcr_intro_style').change(function () {
    		switch ($(this).val()) {
    			case 'transparent-intro':
    			case 'black-transparent-intro':
    			default:
    				$('#_tcr_intro_title, #_tcr_intro_subtitle').parent().parent().show();
    				break;
    			case 'disabled':
    				$('#_tcr_intro_title, #_tcr_intro_subtitle').parent().parent().hide();
    				break;
    		}
    	}).change();
    	
    	$('#_tcr_type').change(function () {
    		switch ($(this).val()) {
    			case 'image':
    			default:
    				$('#_tcr_video, #_tcr_video_height, #_tcr_video_width, #_tcr_link, #_tcr_link_target').parent().parent().hide();
    				$('#_tcr_image_uploaded, #_tcr_title, #_tcr_caption_position, #_tcr_caption').parent().parent().show();
    				break;
    			case 'video':
    				$('#_tcr_image_uploaded, #_tcr_link, #_tcr_link_target, #_tcr_title, #_tcr_caption_position, #_tcr_caption').parent().parent().hide();
    				$('#_tcr_video, #_tcr_video_height, #_tcr_video_width').parent().parent().show();
    				break;
    			case 'portfolio':
    				$('#_tcr_video, #_tcr_video_height, #_tcr_video_width, #_tcr_link, #_tcr_link_target, #_tcr_image_uploaded, #_tcr_title, #_tcr_caption_position, #_tcr_caption').parent().parent().hide();
    				break;
    			case 'link':
    				$('#_tcr_image_uploaded, #_tcr_video, #_tcr_video_height, #_tcr_video_width, #_tcr_title, #_tcr_caption_position, #_tcr_caption').parent().parent().hide();
    				$('#_tcr_link, #_tcr_link_target').parent().parent().show();
    				break;
    		}
    	}).change();
    	
    	$('#_tcr_background_video_complete').change(function () {
    	    if ($(this).val() == 'redirect') {
    	        $('#_tcr_background_video_redirect').closest('.tcr-meta-box-field-outer').show();
    	    } else {
    	        $('#_tcr_background_video_redirect').closest('.tcr-meta-box-field-outer').hide();
    	    }
    	}).change();
    	
    	if (typeof $.fn.toggleSwitch === 'function') {
    		$('input.tcr-option-toggle, select.tcr-option-tritoggle').toggleSwitch({
    		    onText: tcrL10n.on,
    		    offText: tcrL10n.off,
    			defaultText: tcrL10n._default
    		});
    		
    		$('input.tcr-option-toggle-yn, select.tcr-option-tritoggle-yn').toggleSwitch({
                defaultText: tcrL10n._default,
                onText: tcrL10n.yes,
                offText: tcrL10n.no
            });
    	}
    	
    	// Background audio
        var getNextTrackId = function () {
            var trackId = $('#tcr-audio-tracks > .tcr-audio-track').length;
    
            while($('#background_audio_track_m4a_' + trackId).length) {
                trackId++;
            }
            
            return trackId;
        },
        $tcrAudioTracks = $('#tcr-audio-tracks');
        
        $('#tcr-add-audio-track-button').click(function () {
            var trackId = getNextTrackId();
            
            var $track = $('<div id="tcr-audio-track-' + trackId + '" class="tcr-audio-track tcr-clearfix">\
                <div class="tcr-audio-track-inner">\
                    <div class="tcr-delete-audio-track" title="' + tcrL10n.deleteTrack + '"></div>\
                    <div class="tcr-edit-audio-track" title="' + tcrL10n.editTrack + '"></div>\
                    <div class="tcr-drag-audio-track" title="' + tcrL10n.moveTrack + '"></div>\
                    <div class="tcr-audio-track-name">\
                        <span class="tcr-audio-track-name-inner">' + tcrL10n.untitled + '</span>\
                        <input type="text" class="tcr-audio-track-name-input tcr-width-150" value="' + tcrL10n.untitled + '" />\
                    </div>\
                    <div class="tcr-audio-track-settings">\
                        <table class="tcr-audio-track-settings">\
                            <tr class="tcr-audio-format-title">\
                                <th colspan="2">' + tcrL10n.m4aFileUrl + '</th>\
                            </tr>\
                            <tr class="tcr-audio-format">\
                                <td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-m4a" value="" /></td>\
                                <td class="tcr-audio-format-upload-td">\
                                    <div class="tcr-upload-audio-track-button-wrap tcr-clearfix">\
                                        <div class="tcr-upload-audio-format-button tcr-swfupload-button">' + tcrL10n.upload + '<div id="background_audio_format_m4a_' + trackId + '"></div></div>\
                                        <div class="tcr-loading"></div>\
                                    </div>\
                                </td>\
                            </tr>\
                            <tr class="tcr-audio-format-title">\
                                <th colspan="2">' + tcrL10n.mp3FileUrl + '</th>\
                            </tr>\
                            <tr class="tcr-audio-format">\
                                <td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-mp3" value="" /></td>\
                                <td class="tcr-audio-format-upload-td">\
                                    <div class="tcr-upload-audio-track-button-wrap tcr-clearfix">\
                                        <div class="tcr-upload-audio-format-button tcr-swfupload-button">' + tcrL10n.upload + '<div id="background_audio_format_mp3_' + trackId + '"></div></div>\
                                        <div class="tcr-loading"></div>\
                                    </div>\
                                </td>\
                            </tr>\
                            <tr class="tcr-audio-format-title">\
                                <th colspan="2">' + tcrL10n.oggFileUrl + '</th>\
                            </tr>\
                            <tr class="tcr-audio-format">\
                                <td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-ogg" value="" /></td>\
                                <td class="tcr-audio-format-upload-td">\
                                    <div class="tcr-upload-audio-track-button-wrap tcr-clearfix">\
                                        <div class="tcr-upload-audio-format-button tcr-swfupload-button">' + tcrL10n.upload + '<div id="background_audio_format_ogg_' + trackId + '"></div></div>\
                                        <div class="tcr-loading"></div>\
                                    </div>\
                                </td>\
                            </tr>\
                        </table>\
                    </div>\
                </div>\
            </div>');
            
            $tcrAudioTracks.append($track);
            
            $track.find('.tcr-edit-audio-track').click()
            .end().find('.tcr-audio-format-m4a').focus();
            
            addAudioUploaders($track);
            
            updateAudioTracks();
            
            return false;
        });
        
        // Make the tracks sortable
        $tcrAudioTracks.sortable({
            handle: '.tcr-drag-audio-track',
            stop: updateAudioTracks
        });
        
        // Edit audio track
        $tcrAudioTracks.delegate('.tcr-edit-audio-track', 'click', function () {
            var $editButton = $(this),
            $root = $editButton.closest('.tcr-audio-track'),
            $settings = $root.find('.tcr-audio-track-settings'),
            $nameLabel = $root.find('.tcr-audio-track-name-inner'),
            $nameInput = $root.find('.tcr-audio-track-name-input');
            
            if ($editButton.hasClass('tcr-open')) {
                $settings.add($nameInput).hide();
                $nameLabel.show();
                $editButton.removeClass('tcr-open');
            } else {
                $nameLabel.hide();
                $settings.add($nameInput).show();
                $editButton.addClass('tcr-open');
            }
        });
        
        // Change track name when typed
        $tcrAudioTracks.delegate('.tcr-audio-track-name-input', 'keyup blur', function () {
            var $this = $(this);
            $this.siblings('.tcr-audio-track-name-inner').text($this.val());
            updateAudioTracks();
        });        
        
        // Delete audio track
        $tcrAudioTracks.delegate('.tcr-delete-audio-track', 'click', function () {
            $(this).closest('.tcr-audio-track').remove();
            updateAudioTracks();
        });
        
        // Set up audio uploaders
        $('.tcr-audio-track').each(function () {
            addAudioUploaders($(this));
        });
    	
        /**
         * Set up the audio uploaders for the given track
         * 
         * @param object $track
         */
        function addAudioUploaders($track) {
            $track.find('.tcr-audio-format').each(function () {
                var $root = $(this),
                $input = $root.find('.tcr-audio-format-input'),
                $uploadButton = $root.find('.tcr-upload-audio-format-button'),
                placeholderId = $uploadButton.find('div:first-child').attr('id'),
                $progress = $('<div class="tcr-audio-upload-progress"></div>');
    
                tcr.addUploader({
                    button_height: $uploadButton.actual('outerHeight'),
                    button_width: $uploadButton.actual('outerWidth'),
                    button_placeholder_id: placeholderId,
                    file_queue_limit: 1,
                    file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
                        if (numFilesQueued > 0) {
                            this.startUpload();
                            $input.after($progress);
                        }
                    },
                    upload_success_handler: function (file, response, serverResponse) {
                        if (response == null) {
                            console.log(file);
                            console.log(response);
                            console.log(serverResponse);
                            alert('An error occurred uploading the file (the response was empty). You may find more information in the browser console.');                        
                        } else {
                            try {
                                response = JSON.parse(response);
                                if (typeof response === 'object' && response.type === 'success') {
                                    $input.val(response.data.url);
                                    updateAudioTracks();
                                }
                            } catch (ex) {
                                console.log(ex);
                                console.log(file);
                                console.log(response);
                                console.log(serverResponse);
                                alert('An error occurred uploading the file (could not parse the response in JSON). You may find more information in the browser console.');
                            }
                        }
                    },
                    upload_progress_handler: function (file, bytesCompleted, totalBytes) {
                        if (totalBytes > 0) {
                            var progress = ((bytesCompleted/totalBytes) * 100);
                            $progress.width(progress + '%');
                        }
                    },                    
                    upload_complete_handler: function () {
                        $progress.remove();
                    },
                    file_queue_error_handler: function () {
                        alert(tcrL10n.uploadTooManyFiles);
                        $progress.remove();
                    },
                    post_params: {
                        action: 'tcr_swfupload_upload_audio_ajax',
                        _wpnonce: tcrL10n.swfuploadNonce
                    }
                });         
            });
        }
        
        function updateAudioTracks()
        {
            // Audio tracks
            var tracks = [];
            $('#tcr-audio-tracks > div').each(function () {
                var $track = $(this);
                tracks.push({name: $track.find('.tcr-audio-track-name-input').val(), m4a: $track.find('.tcr-audio-format-m4a').val(), mp3: $track.find('.tcr-audio-format-mp3').val(), oga: $track.find('.tcr-audio-format-ogg').val()});
            });
            $('#_tcr_audio').val(JSON.stringify(tracks));
        }
        
        // Handle manual typing of track URLs
        $tcrAudioTracks.delegate('.tcr-audio-format-input', 'blur', updateAudioTracks);
        
        $('#page_template').change(function () {
            var template = $(this).val(),
            $skipUrl = $('#_tcr_skip_url').closest('.tcr-meta-box-field-outer'),
            $showCaptions = $('#_tcr_always_show_captions').closest('.tcr-meta-box-field-outer'),
            $layout = $('#_tcr_layout').closest('.tcr-meta-box-field-outer'),
            $contentStyle = $('#_tcr_content_style').closest('.tcr-meta-box-field-outer'),
            $introHeading = $('.tcr-intro-settings'),
            $introStyle = $('#_tcr_intro_style').closest('.tcr-meta-box-field-outer'),
            $introTitle = $('#_tcr_intro_title').closest('.tcr-meta-box-field-outer'),
            $introSubtitle = $('#_tcr_intro_subtitle').closest('.tcr-meta-box-field-outer');
            
            if (template == 'template-intro-page.php') {
                $skipUrl.show();
            } else {
                $skipUrl.hide();
            }
            
            if (template == 'template-intro-page.php' || template == 'template-left-note-block.php' || template == 'template-no-content-style.php') {
                $showCaptions.show();
                $layout.add($contentStyle).add($introHeading).add($introStyle).add($introTitle).add($introSubtitle).hide();
            } else {
                $showCaptions.hide();
                $layout.add($contentStyle).add($introHeading).add($introStyle).add($introTitle).add($introSubtitle).show();
            }
        }).change();
    }); // End document.ready()
})(jQuery);