/*
 * Theme Admin JavaScript
 * 
 * Copyright www.themecatcher.net
 * All rights reserved.
 */
;(function ($, window) {    
	// Fix for JSON.stringify if prototype.js is loaded
	if (typeof Array.prototype.toJSON == 'function') {
		delete Array.prototype.toJSON;
	}
	
	window.tcr = {
		addUploader: function (options) {
			if (typeof SWFUpload !== 'undefined') {
				var defaults = {
			        button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,
			        button_cursor: SWFUpload.CURSOR.HAND,
			        flash_url: tcrL10n.swfuploadFlashUrl,
			        upload_url: tcrL10n.swfuploadUploadUrl,
					file_post_name: 'upload',        
			        post_params: {
			        	tcr_swfupload: 1,
			    		auth_cookie: tcrL10n.authCookie,
			    		logged_in_cookie: tcrL10n.loggedInCookie
			        },
			        upload_error_handler: function(file, errorCode, message) {
			        	console.log(file);
			        	console.log(errorCode);
			        	console.log(message);
			        	alert('An error occurred uploading the file. You may find more information in the browser console.');
			        }
				};			
				
				new SWFUpload($.extend(true, {}, defaults, options));
			}
		},
		
		deleteUploadedFile: function (file) {
			$.ajax({
				url: ajaxurl,				
				data: {
					action: 'tcr_delete_file_ajax',
					file: file
				}
			});
		}
	};
	
	$(document).ready(function () {
	    $('.tcr-external-link').live('click', function () {
	        var href = $(this).attr('href');
	        if (href) {
	            window.open(href);
	            return false;
	        }
	    });
	});	
	
	$(window).load(function () {
	    // Image preloading
        $.preloadImages([
             '/images/default-loading.gif',
             '/images/button-grey.png',
             '/images/button-grey-hover.png',
             '/images/button-blue-hover.png',
             '/images/button-orange.png',
             '/images/button-orange-hover.png',
             '/images/add-icon-for-orange-button.png',
             '/images/button-light-hover.png',
             '/images/icons/like1.png',
             '/images/icons/book1.png',
             '/images/icons/support1.png',
             '/images/warning-icon.png',
             '/images/icons/list1.png',
             '/images/icons/globe1.png',
             '/images/icons/screen1.png',
             '/images/icons/megaphone1.png',
             '/images/icons/feet1.png',
             '/images/icons/settings1.png',
             '/images/icons/phone1.png',
             '/images/icons/images1.png',
             '/images/icons/speach1.png',
             '/images/icons/layout1.png',
             '/images/icons/brush1.png',
             '/images/icons/pie-chart1.png',
             '/images/icons/image1.png',
             '/images/icons/sound1.png',
             '/images/icons/movie1.png',
             '/images/icons/fancy-brush1.png',
             '/images/icons/cog1.png',
             '/images/icons/fullscreen1.png',
             '/images/icons/export1.png',
             '/images/icons/import1.png',
             '/images/icons/phonesub1.png',
             '/images/icons/translation1.png',
             '/images/icons/plug1.png',
             '/images/icons/font1.png',
             '/images/small-delete-round.png',
             '/images/20-light-transp.png',
             '/images/plain-light-50.png',
             '/images/delete-bg.png',
             '/images/delete-bg-hover.png',
             '/images/settings-bg.png',
             '/images/settings-bg-hover.png',
             '/images/transparent-bg.png',
             '/images/20-dark-transp.png',
             '/images/success-bg.png',
             '/images/success.png',
             '/images/icons/headphones.png',
             '/images/icons/music-move.png',
             '/images/icons/music-move1.png',
             '/images/icons/music-delete.png',
             '/images/icons/music-delete1.png',
             '/images/icons/music-edit.png',
             '/images/icons/music-edit1.png',
             '/images/pop-up-close.png',
             '/images/pop-up-add.png',
             '/images/pop-up-add-close.png',
             '/images/pop-up-save.png',
             '/images/color-wheel.png',
             '/images/right-on.png',
             '/images/left-on.png',
             '/images/right-on1.png',
             '/images/left-on1.png',
             '/images/left-off.png',
             '/images/right-off.png',
             '/images/left-off1.png',
             '/images/right-off1.png',
             '/images/right-default.png',
             '/images/left-default1.png',
             '/images/right-default1.png',
             '/images/jslider.round.plastic.png',
             '/images/chosen-sprite.png'
         ], tcrL10n.themeAdminUrl);
    }); // End window.load
})(jQuery, window);