<?php
// Prevent direct script access
if (!defined('ABSPATH')) exit;
?>
<div class="tcr-shortcode-outer">
    <form id="tcr-shortcode-form">
        <h3 class="tcr-sc-main-head"><?php esc_html_e('Insert a shortcode', TCR_ADMIN_TEXT_DOMAIN); ?></h3>
        <div class="tcr-shortcode-inner">
            <div class="tcr-sc-type-select-wrap">
                <label><?php esc_html_e('Type', TCR_ADMIN_TEXT_DOMAIN); ?>
                    <select id="tcr-sc-type-select" name="tcr-sc-type-select">
                        <option value=""><?php esc_html_e('Please select', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="columns"><?php esc_html_e('Columns', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="layouts"><?php esc_html_e('Layouts', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="blog"><?php esc_html_e('Blog', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="portfolio"><?php esc_html_e('Portfolio', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="quotes"><?php esc_html_e('Quotes', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="boxes"><?php esc_html_e('Boxes', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="section_breaks"><?php esc_html_e('Section Break', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="buttons"><?php esc_html_e('Buttons', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="lists"><?php esc_html_e('Lists', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="menus"><?php esc_html_e('Menus', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="tables"><?php esc_html_e('Tables', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="dropcaps"><?php esc_html_e('Dropcaps', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="tabs"><?php esc_html_e('Tabs', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="toggles"><?php esc_html_e('Toggles', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="accordion"><?php esc_html_e('Accordion', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="cycle"><?php esc_html_e('Cycle', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="image"><?php esc_html_e('Image', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="image_frames"><?php esc_html_e('Image Frames', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="galleria"><?php esc_html_e('Galleria', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="fancy_headers"><?php esc_html_e('Fancy Headers', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="impact_headers"><?php esc_html_e('Impact Headers', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        <option value="note_block"><?php esc_html_e('Note Block', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                    </select>
                </label>
            </div>
            <div id="tcr-sc-options-columns" class="tcr-sc-options">
                <div class="tcr-sc-var-select-wrap">
                    <label><?php esc_html_e('Variation', TCR_ADMIN_TEXT_DOMAIN); ?>
                        <select id="tcr-sc-select-columns" name="tcr-sc-select-columns">
                            <option value="one_half"><?php esc_html_e('One Half', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_third"><?php esc_html_e('One Third', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_fourth"><?php esc_html_e('One Fourth', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_fifth"><?php esc_html_e('One Fifth', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_sixth"><?php esc_html_e('One Sixth', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="two_thirds"><?php esc_html_e('Two Thirds', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="three_fourths"><?php esc_html_e('Three Fourths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="two_fifths"><?php esc_html_e('Two Fifths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="three_fifths"><?php esc_html_e('Three Fifths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="four_fifths"><?php esc_html_e('Four Fifths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="five_sixths"><?php esc_html_e('Five Sixths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        </select>
                    </label>
                </div>
                <div class="tcr-sc-option">
                	<div class="tcr-clearfix tcr-sc-columns-last-wrap">
                        <label for="tcr-sc-columns-last"><?php esc_html_e('"Last" column?', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                        <input type="checkbox" id="tcr-sc-columns-last" name="tcr-sc-columns-last" class="tcr-option-toggle-yn" />
                    </div>
                </div>
                <div class="tcr-sc-option">
                	<div class="tcr-clearfix tcr-sc-columns-content-wrap">
                        <label for="tcr-sc-columns-content"><?php esc_html_e('Content', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                        <textarea rows="8" cols="50" id="tcr-sc-columns-content" name="tcr-sc-columns-content"></textarea>
                    </div>
                </div>
            </div>
            <div id="tcr-sc-options-layouts" class="tcr-sc-options">
                <div class="tcr-sc-var-select-wrap">
                    <label><?php esc_html_e('Variation', TCR_ADMIN_TEXT_DOMAIN); ?>
                        <select id="tcr-sc-select-layouts" name="tcr-sc-select-layouts">
                            <option value=""><?php esc_html_e('Please select', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="two_column"><?php esc_html_e('Two Column Layout', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="three_column"><?php esc_html_e('Three Column Layout', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="four_column"><?php esc_html_e('Four Column Layout', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="five_column"><?php esc_html_e('Five Column Layout', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="six_column"><?php esc_html_e('Six Column Layout', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_third_two_thirds"><?php esc_html_e('One Third / Two Thirds', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="two_thirds_one_third"><?php esc_html_e('Two Third / One Thirds', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_fourth_three_fourths"><?php esc_html_e('One Fourth / Three Fourths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="three_fourths_one_fourth"><?php esc_html_e('Three Fourths / One Fourth', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="two_fourths_one_half"><?php esc_html_e('Two Fourths / One Half', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_fourth_one_half_one_fourth"><?php esc_html_e('One Fourth / One Half / One Fourth', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_half_two_fourths"><?php esc_html_e('One Half / Two Fourths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="four_fifths_one_fifth"><?php esc_html_e('Four Fifths / One Fifth', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_fifth_four_fifths"><?php esc_html_e('One Fifth / Four Fifths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="two_fifths_three_fifths"><?php esc_html_e('Two Fifths / Three Fifths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="three_fifths_two_fifths"><?php esc_html_e('Three Fifths / Two Fifths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_sixth_five_sixths"><?php esc_html_e('One Sixth / Five Sixths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="five_sixth_one_sixths"><?php esc_html_e('Five Sixths / One Sixth', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="three_sixths_one_half"><?php esc_html_e('Three Sixths / One Half', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="one_half_three_sixths"><?php esc_html_e('One Half / Three Sixths', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        </select>
                    </label>
                </div>
                <div class="tcr-sc-option">
                    <?php for ($i = 1; $i <= 6; $i++) : ?>
                        <div id="tcr-sc-layout-content-wrap-<?php echo $i; ?>" class="tcr-sc-layout-content-wrap">
                            <label id="tcr-sc-layout-content-label-<?php echo $i; ?>" for="tcr-sc-layout-content-<?php echo $i; ?>"><?php printf(esc_html__('Column %d content', TCR_ADMIN_TEXT_DOMAIN), $i); ?></label>
                            <textarea rows="8" cols="50" id="tcr-sc-layout-content-<?php echo $i; ?>"></textarea>
                        </div>
                    <?php endfor; ?>
                </div>
            </div>
            <div id="tcr-sc-options-blog" class="tcr-sc-options">
                <?php tcr_render_shortcode_blog_options(); ?>
            </div>
            <div id="tcr-sc-options-portfolio" class="tcr-sc-options">
                <?php tcr_render_shortcode_portfolio_options(); ?>
            </div>
            <div id="tcr-sc-options-quotes" class="tcr-sc-options">
                <div class="tcr-sc-var-select-wrap">
                    <label><?php esc_html_e('Variation', TCR_ADMIN_TEXT_DOMAIN); ?>
                        <select id="tcr-sc-select-quotes" name="tcr-sc-select-quotes">
                            <option value=""><?php esc_html_e('Please select', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="blockquote"><?php esc_html_e('Blockquote', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                            <option value="pullquote"><?php esc_html_e('Pullquote', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                        </select>
                    </label>
                </div>
                <div id="tcr-sc-options-blockquote" class="tcr-hidden">
                    <?php tcr_render_shortcode_blockquote_options(); ?>
                    <?php tcr_shortcode_preview_html(); ?>
                </div>
                <div id="tcr-sc-options-pullquote" class="tcr-hidden">
                    <?php tcr_render_shortcode_pullquote_options(); ?>
                    <?php tcr_shortcode_preview_html(); ?>
                </div>
            </div>
            <div id="tcr-sc-options-boxes" class="tcr-sc-options">
                <?php tcr_render_shortcode_box_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-section_breaks" class="tcr-sc-options">
                <?php tcr_render_shortcode_section_break_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-buttons" class="tcr-sc-options">
                <?php tcr_render_shortcode_button_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-lists" class="tcr-sc-options">
                <?php tcr_render_shortcode_list_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-menus" class="tcr-sc-options">
                <?php tcr_render_shortcode_menu_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-tables" class="tcr-sc-options">
                <?php tcr_render_shortcode_table_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-dropcaps" class="tcr-sc-options">
                <?php tcr_render_shortcode_dropcap_options(); ?>
            </div>
            <div id="tcr-sc-options-tabs" class="tcr-sc-options">
                <?php tcr_render_shortcode_tabs_options(); ?>
            	<div class="tcr-clearfix">
                    <div id="tcr-sc-add-tab" class="tcr-button tcr-orange tcr-add"><span></span><?php esc_html_e('Add a new tab', TCR_ADMIN_TEXT_DOMAIN); ?></div>
                </div>
                <div id="tcr-sc-tabs-wrap">
                    <!-- If anything changes below, shortcodes.js must also be changed -->
                    <div class="tcr-sc-pane">
                        <div class="tcr-sc-pane-remove" title="<?php esc_attr_e('Remove tab', TCR_ADMIN_TEXT_DOMAIN); ?>">X</div>
                        <div class="tcr-sc-pane-outer tcr-clearfix">
                            <div class="tcr-sc-pane-label">
                                <h4><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></h4>
                            </div>
                            <div class="tcr-sc-pane-inner">
                                <input type="text" />
                            </div>
                        </div>
                        <div class="tcr-sc-pane-outer tcr-clearfix">
                            <div class="tcr-sc-pane-label">
                                <h4><?php esc_html_e('Content', TCR_ADMIN_TEXT_DOMAIN); ?></h4>
                            </div>
                            <div class="tcr-sc-pane-inner">
                                <textarea></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="tcr-sc-options-toggles" class="tcr-sc-options">
                <?php tcr_render_shortcode_toggle_options(); ?>
                <div class="tcr-clearfix">
                    <div id="tcr-sc-add-toggle" class="tcr-button tcr-orange tcr-add"><span></span><?php esc_html_e('Add a new toggle', TCR_ADMIN_TEXT_DOMAIN); ?></div>
                </div>
                <div id="tcr-sc-toggles-wrap">
                    <!-- If anything changes below, shortcodes.js must also be changed -->
                    <div class="tcr-sc-pane">
                        <div class="tcr-sc-pane-remove" title="<?php esc_attr_e('Remove toggle', TCR_ADMIN_TEXT_DOMAIN); ?>">X</div>
                        <div class="tcr-sc-pane-outer tcr-clearfix">
                            <div class="tcr-sc-pane-label">
                                <h4><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></h4>
                            </div>
                            <div class="tcr-sc-pane-inner">
                                <input type="text" />
                            </div>
                        </div>
                        <div class="tcr-sc-pane-outer tcr-clearfix">
                            <div class="tcr-sc-pane-label">
                                <h4><?php esc_html_e('Content', TCR_ADMIN_TEXT_DOMAIN); ?></h4>
                            </div>
                            <div class="tcr-sc-pane-inner">
                                <textarea></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="tcr-sc-options-accordion" class="tcr-sc-options">
                <?php tcr_render_shortcode_accordion_options(); ?>
            	<div class="tcr-clearfix">
                    <div id="tcr-sc-add-accordion" class="tcr-button tcr-orange tcr-add"><span></span><?php esc_html_e('Add a new accordion toggle', TCR_ADMIN_TEXT_DOMAIN); ?></div>
                </div>
                <div id="tcr-sc-accordions-wrap">
                    <!-- If anything changes below, shortcodes.js must also be changed -->
                    <div class="tcr-sc-pane">
                        <div class="tcr-sc-pane-remove" title="<?php esc_attr_e('Remove toggle', TCR_ADMIN_TEXT_DOMAIN); ?>">X</div>
                        <div class="tcr-sc-pane-outer tcr-clearfix">
                            <div class="tcr-sc-pane-label">
                                <h4><?php esc_html_e('Title', TCR_ADMIN_TEXT_DOMAIN); ?></h4>
                            </div>
                            <div class="tcr-sc-pane-inner">
                                <input type="text" />
                            </div>
                        </div>
                        <div class="tcr-sc-pane-outer tcr-clearfix">
                            <div class="tcr-sc-pane-label">
                                <h4><?php esc_html_e('Content', TCR_ADMIN_TEXT_DOMAIN); ?></h4>
                            </div>
                            <div class="tcr-sc-pane-inner">
                                <textarea></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="tcr-sc-options-cycle" class="tcr-sc-options">
            	<div class="tcr-clearfix">
                    <div id="tcr-sc-add-cycle" class="tcr-button tcr-orange tcr-add"><span></span><?php esc_html_e('Add a new slide', TCR_ADMIN_TEXT_DOMAIN); ?></div>
                </div>
                <div id="tcr-sc-cycle-slides-wrap">
                    <!-- If anything changes below, shortcodes.js must also be changed -->
                    <div class="tcr-sc-pane">
                        <div class="tcr-sc-pane-remove" title="<?php esc_attr_e('Remove slide', TCR_ADMIN_TEXT_DOMAIN); ?>">X</div>
                        <div class="tcr-sc-pane-outer tcr-clearfix">
                            <div class="tcr-sc-pane-label">
                                <h4><?php esc_html_e('Content', TCR_ADMIN_TEXT_DOMAIN); ?></h4>
                            </div>
                            <div class="tcr-sc-pane-inner">
                                <textarea></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <?php tcr_render_shortcode_cycle_options(); ?>
            </div>
            <div id="tcr-sc-options-image" class="tcr-sc-options">
                <?php tcr_render_shortcode_image_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-image_frames" class="tcr-sc-options">
                <?php tcr_render_shortcode_image_frames_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-galleria" class="tcr-sc-options">
                <?php tcr_render_shortcode_galleria_options(); ?>
            </div>
            <div id="tcr-sc-options-fancy_headers" class="tcr-sc-options">
                <?php tcr_render_shortcode_fancy_header_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-impact_headers" class="tcr-sc-options">
                <?php tcr_render_shortcode_impact_header_options(); ?>
                <?php tcr_shortcode_preview_html(); ?>
            </div>
            <div id="tcr-sc-options-note_block" class="tcr-sc-options">
                <?php tcr_render_shortcode_note_block_options(); ?>
            </div>
        </div>
        <div class="tcr-sc-insert-button-wrap tcr-clearfix">
            <a id="tcr-insert-close-shortcode" class="tcr-button tcr-blue"><?php esc_html_e('Insert & Close', TCR_ADMIN_TEXT_DOMAIN); ?></a>
            <a id="tcr-insert-shortcode" class="tcr-button tcr-blue"><?php esc_html_e('Insert', TCR_ADMIN_TEXT_DOMAIN); ?></a>
            <a id="tcr-close-shortcode" class="tcr-button tcr-light"><?php esc_html_e('Close', TCR_ADMIN_TEXT_DOMAIN); ?></a>
        </div>
        <input type="hidden" name="tcr-widget-target" id="tcr-widget-target" value="<?php if (isset($_GET['widget'])) echo esc_attr($_GET['widget']); ?>" />
    </form>
</div>