<?php
// Prevent direct script access
if (!defined('ABSPATH')) exit;
?>
<div class="wrap">
    <?php if (isset($_GET['message'])) : ?>
        <?php if ($_GET['message'] == 'reset') : ?>
            <div class="tcr-sucess-message"><p><?php esc_html_e('All options have been reset', TCR_ADMIN_TEXT_DOMAIN); ?></p></div>
        <?php elseif ($_GET['message'] == 'import') : ?>
            <div class="tcr-sucess-message"><p><?php esc_html_e('Import successful', TCR_ADMIN_TEXT_DOMAIN); ?></p></div>
        <?php endif; ?>
    <?php endif; ?>
    <?php if (!is_writeable(TCR_CACHE_DIR)) : ?>
        <div class="tcr-warning-message"><p class="tcr-warning"><?php printf(esc_html__('The cache directory %1$s is not writeable. Please make this directory writeable for the theme to work properly. %2$sFind out how%3$s.', TCR_ADMIN_TEXT_DOMAIN), '<code>' . TCR_CACHE_DIR . '</code>', '<a class="tcr-external-link" href="http://codex.wordpress.org/Changing_File_Permissions">', '</a>'); ?></p></div>
    <?php endif; ?>
    <noscript><p class="tcr-no-script"><span><?php esc_html_e('Please enable JavaScript to use the theme options panel.', TCR_ADMIN_TEXT_DOMAIN); ?></span></p></noscript>
    <form id="tcr">
        <div class="tcr-wrap tcr-clearfix">
            <input type="submit" class="tcr-hidden" /><!-- Prevent the enter key submitting the form -->

            <div class="tcr-panel-header">
            	<div class="tcr-panel-logo"></div>
                <div class="tcr-header-right">
                    <div class="tcr-header-right-top-bar">
                    	<div class="tcr-themecatcher-menu">
                        	<ul class="tcr-tc-menu">
                            	<li><a class="tcr-facebook tcr-tooltip" href="http://www.facebook.com/ThemeCatcher" title="<?php esc_attr_e('Find us on Facebook', TCR_ADMIN_TEXT_DOMAIN); ?>"><span></span></a></li>
                                <li><a class="tcr-support tcr-tooltip" href="http://themeforest.net/user/ThemeCatcher" title="<?php esc_attr_e('Get support', TCR_ADMIN_TEXT_DOMAIN); ?>"><span></span></a></li>
                                <li><a class="tcr-tc-portfolio tcr-tooltip" href="http://themeforest.net/user/ThemeCatcher/portfolio" title="<?php esc_attr_e('Our portfolio', TCR_ADMIN_TEXT_DOMAIN); ?>"><span></span></a></li>
                            </ul>
                        </div>
                        <div class="tcr-copy-info">
                            <p>&copy; <?php echo date('Y'); ?> <a href="http://www.themecatcher.net" class="tcr-top-tcr-link tcr-external-link">ThemeCatcher</a></p>
                        </div>
                    </div>
                    <div class="tcr-header-right-bottom-bar">
                        <h2><?php printf(__('%s Options Panel', TCR_ADMIN_TEXT_DOMAIN), TCR_NAME); ?><a class="tcr-site-link tcr-tooltip tcr-external-link" href="<?php echo home_url(); ?>" title="<?php esc_attr_e('View your website', TCR_ADMIN_TEXT_DOMAIN); ?>"><span></span></a></h2>
                    	<div class="tcr-top-save-button-wrap">
                        	 <a class="tcr-save tcr-button tcr-blue tcr-save-save"><span><?php esc_html_e('Save', TCR_ADMIN_TEXT_DOMAIN); ?></span></a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tcr-panel-left">
                <ul id="tcr-tabs-nav">
                    <li><span><?php esc_html_e('Global', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-global"></span></span></li>
                    <li><span><?php esc_html_e('Backgrounds', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-backgrounds"></span></span></li>
                    <li><span><?php esc_html_e('Blog', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-blog"></span></span></li>
                    <li><span><?php esc_html_e('Portfolio', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-portfolio"></span></span></li>
                    <li><span><?php esc_html_e('Footer', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-footer"></span></span></li>
                    <li><span><?php esc_html_e('Contact', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-contact"></span></span></li>
                    <li><span><?php esc_html_e('Advanced', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-advanced"></span></span></li>
                    <li><span><?php esc_html_e('Translate', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-translate"></span></span></li>
                </ul>
            </div>

            <div class="tcr-panel-right">

                <div id="tcr-tabs">
                    <div class="tcr-tab-1">
                    	<div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                                <li><span><?php esc_html_e('Layout', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-layout"></span></span></li>
                                <li><span><?php esc_html_e('Logo', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-brand"></span></span></li>
                                <li><span><?php esc_html_e('Colors', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-colors"></span></span></li>
                                <li><span><?php esc_html_e('Fonts', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-fonts"></span></span></li>
                                <li><span><?php esc_html_e('Analytics', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-analytics"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('General layout settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>

                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_layout"><?php esc_html_e('Layout', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose the default position of the content area and sidebar', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="general_layout" name="general_layout" class="tcr-layout-selector">
                                                <option value="left-sidebar" <?php selected($tcr['options']['general_layout'], 'left-sidebar'); ?>><?php esc_html_e('Left sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="full-width" <?php selected($tcr['options']['general_layout'], 'full-width'); ?>><?php esc_html_e('Full width', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right-sidebar"<?php selected($tcr['options']['general_layout'], 'right-sidebar'); ?> ><?php esc_html_e('Right sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose the default layout', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_page_layout"><?php esc_html_e('Page layout', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose the default position of the content area and sidebar for a page', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select name="general_page_layout" id="general_page_layout" class="tcr-layout-selector">
                                                <option value="left-sidebar" <?php selected($tcr['options']['general_page_layout'], 'left-sidebar'); ?>><?php esc_html_e('Left sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="full-width" <?php selected($tcr['options']['general_page_layout'], 'full-width'); ?>><?php esc_html_e('Full width', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right-sidebar" <?php selected($tcr['options']['general_page_layout'], 'right-sidebar'); ?>><?php esc_html_e('Right sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The default layout for pages', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_header_style"><?php esc_html_e('Header style', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Two header styles', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="general_header_style" name="general_header_style">
                                                <option value="standard-header" <?php selected($tcr['options']['general_header_style'], 'standard-header'); ?>><?php esc_html_e('Stretched', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="header-no-stretch" <?php selected($tcr['options']['general_header_style'], 'header-no-stretch'); ?>><?php esc_html_e('Not stretched', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The Stretched header is 100% of the page width, Not stretched is the same width as the content area', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_navigation_width"><?php esc_html_e('Navigation width', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('The width of the navigation wrapper in pixels', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                    	    <input type="text" name="general_navigation_width" id=general_navigation_width value="<?php echo esc_attr($tcr['options']['general_navigation_width']); ?>" class="tcr-width-50 tcr-range-slider"  data-from="0" data-to="1000" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Set width of the navigation, set to 0 to for automatic width', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_sticky_header"><?php esc_html_e('Sticky header', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('This will make the main navigation accessible all the time', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="general_sticky_header" id="general_sticky_header" <?php checked(true, $tcr['options']['general_sticky_header']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The header stays visible when scrolling down the page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_search"><?php esc_html_e('Search button', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Shows a search icon to toggle site search field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="general_search" id="general_search" <?php checked(true, $tcr['options']['general_search']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Show the search button in the header', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_intro_style"><?php esc_html_e('Intro style', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Page intro is the heading at the top of the content area', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="general_intro_style" name="general_intro_style">
                                                <option value="disabled" <?php selected($tcr['options']['general_intro_style'], 'disabled'); ?>><?php esc_html_e('Disabled', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="transparent-intro" <?php selected($tcr['options']['general_intro_style'], 'transparent-intro'); ?>><?php esc_html_e('Transparent', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="black-transparent-intro"<?php selected($tcr['options']['general_intro_style'], 'black-transparent-intro'); ?> ><?php esc_html_e('Transparent with black top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose a design for the intro section', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_content_style"><?php esc_html_e('Content style', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('The style of background which the content is on', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="general_content_style" name="general_content_style">
                                                <option value="plain-black" <?php selected($tcr['options']['general_content_style'], 'plain-black'); ?>><?php esc_html_e('Plain black', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="full-width-transparent" <?php selected($tcr['options']['general_content_style'], 'full-width-transparent'); ?>><?php esc_html_e('Transparent', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose the default content style, you can customize this per page in the Storm Options metabox', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_read_more_text"><?php esc_html_e('"Read More" text', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Read more, continue, see more, more, continue reading, etc', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_read_more_text" id="general_read_more_text" value="<?php echo _wp_specialchars($tcr['options']['general_read_more_text'], ENT_COMPAT, false, true); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The text of the "Read More" button for posts', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_breadcrumbs"><?php esc_html_e('Breadcrumbs', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Breadcrumbs are links at the top of the content area that show the location of the current page', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="general_breadcrumbs" id="general_breadcrumbs" <?php checked(true, $tcr['options']['general_breadcrumbs']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Enable breadcrumb navigation. Requires that the "Breadcrumbs Plus" plugin is installed.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->

                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Logo settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>

                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_logo"><?php esc_html_e('Logo image URL', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Your site logo is displayed in the header', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_logo" id="general_logo" value="<?php echo _wp_specialchars($tcr['options']['general_logo'], ENT_COMPAT, false, true); ?>" class="tcr-width-400" />
                                            <div class="tcr-upload-logo-button-wrap tcr-clearfix">
                                                <div id="general_logo_upload" class="tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="general_logo_upload_browse"></div></div>
                                                <div class="tcr-loading"></div>
                                            </div>
                                        </td>
                                        <td class="tcr-form-table-logo-image-td">
                                        	<div id="general_logo_upload_holder" class="tcr-clearfix tcr-upload-holder">
                                                <?php
                                                if (strlen($tcr['options']['general_logo']) && !preg_match('#http(s)?:\/\/#', $tcr['options']['general_logo'])) : ?>
                                                    <div class="tcr-uploaded-image tcr-logo"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div class="tcr-delete-uploaded-image" title="<?php esc_html_e('Delete image', TCR_ADMIN_TEXT_DOMAIN); ?>"></div></div></div><img src="<?php echo esc_url(TCR_URL . '/includes/timthumb.php?src=' . site_url() . $tcr['options']['general_logo'] . '&w=100&q=100'); ?>" alt="" /></div>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_logo_url"><?php esc_html_e('Logo link URL', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Where to go when user clicks your logo', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_logo_url" id="general_logo_url" value="<?php echo _wp_specialchars($tcr['options']['general_logo_url'], ENT_COMPAT, false, true); ?>" class="tcr-width-400" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The page that the logo should link to, if left blank it will link to the home page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_logo_top"><?php esc_html_e('Logo "top" position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('The number of pixels the logo will positioned at from the top of the header', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                    	    <input type="text" name="general_logo_top" id="general_logo_top" value="<?php echo esc_attr($tcr['options']['general_logo_top']); ?>" class="tcr-width-50 tcr-range-slider"  data-from="-50" data-to="100" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Set the CSS "top" position of the logo', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_logo_left"><?php esc_html_e('Logo "left" position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('The number of pixels the logo will positioned at from the left of the header', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="text" name="general_logo_left" id="general_logo_left" value="<?php echo esc_attr($tcr['options']['general_logo_left']); ?>" class="tcr-width-50 tcr-range-slider" data-from="-50" data-to="100" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Set the CSS "left" position of the logo', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_favicon"><?php esc_html_e('Favicon', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('The favicon image is shown in the browser tab next to the page title', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_favicon" id="general_favicon" value="<?php echo _wp_specialchars($tcr['options']['general_favicon'], ENT_COMPAT, false, true); ?>" class="tcr-width-400" />
                                            <div class="tcr-upload-favicon-button-wrap tcr-clearfix">
                                                <div id="general_favicon_upload" class="tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="general_favicon_upload_browse"></div></div>
                                                <div class="tcr-loading"></div>
                                            </div>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Enter the URL to your favicon or upload a file', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->

                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Change your colors', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_color_main"><?php esc_html_e('Main color', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose a color using the color picker or add the hex code in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_color_main" id="general_color_main" value="<?php echo esc_attr($tcr['options']['general_color_main']); ?>" class="tcr-colorpicker" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The main color used for links and some headings', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_color_heading"><?php esc_html_e('Heading color', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose a color using the color picker or add the hex code in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_color_heading" id="general_color_heading" value="<?php echo esc_attr($tcr['options']['general_color_heading']); ?>" class="tcr-colorpicker" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The color used for <h1> headings', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_color_subheading"><?php esc_html_e('Sub-heading color', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose a color using the color picker or add the hex code in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_color_subheading" id="general_color_subheading" value="<?php echo esc_attr($tcr['options']['general_color_subheading']); ?>" class="tcr-colorpicker" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The color used for <h2> sub-headings', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_color_background"><?php esc_html_e('Background color', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose a color using the color picker or add the hex code in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="general_color_background" id="general_color_background" value="<?php echo esc_attr($tcr['options']['general_color_background']); ?>" class="tcr-colorpicker" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The color of the site background', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->

                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Font settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_font"><?php esc_html_e('Choose a font', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a the font for your site. Examples are shown below', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td colspan="2" class="tcr-form-table-input-area-td tcr-form-table-font-selection-td">
                                            <select id="general_font" name="general_font">
                                                <option value=""><?php esc_html_e('No font replacement', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <?php $fonts = tcr_get_font_options(); ?>
                                                <?php if (!empty($fonts['cufon'])) : ?>
                                                    <optgroup label="<?php esc_attr_e('Cufon fonts', TCR_ADMIN_TEXT_DOMAIN); ?>">
                                                        <?php foreach ($fonts['cufon'] as $cufonKey => $cufonInfo) : ?>
                                                            <option value="<?php echo esc_attr($cufonKey); ?>" <?php selected($tcr['options']['general_font'], $cufonKey); ?>><?php echo esc_html($cufonInfo['family']); ?></option>
                                                        <?php endforeach; ?>
                                                    </optgroup>
                                                <?php endif; ?>
                                                <?php if (!empty($fonts['google'])) : ?>
                                                    <optgroup label="<?php esc_attr_e('Google fonts', TCR_ADMIN_TEXT_DOMAIN); ?>">
                                                        <?php foreach ($fonts['google'] as $googleKey => $googleInfo) : ?>
                                                            <option value="<?php echo esc_attr($googleKey); ?>" <?php selected($tcr['options']['general_font'], $googleKey); ?>><?php echo esc_html($googleInfo['family']); ?></option>
                                                        <?php endforeach; ?>
                                                    </optgroup>
                                                <?php endif; ?>
                                            </select>
                                            <?php if (!empty($fonts['cufon'])) : ?>
                                                <h3><?php esc_html_e('Cufon font previews', TCR_ADMIN_TEXT_DOMAIN); ?></h3>
                                                <div id="tcr-fonts-cufon">
                                                    <?php foreach ($fonts['cufon'] as $cufonKey => $cufonInfo) : ?>
                                                        <?php if (isset($cufonInfo['preview'])) : ?>
                                                            <img class="tcr-font-preview" data-tcr-font="<?php echo esc_attr($cufonKey); ?>" src="<?php echo TCR_URL . '/fonts/previews/' . $cufonInfo['preview']; ?>" alt="<?php echo esc_attr($cufonInfo['family']); ?>" title="<?php echo esc_attr($cufonInfo['family']); ?>" />
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if (!empty($fonts['google'])) : ?>
                                                <h3><?php esc_html_e('Google font previews', TCR_ADMIN_TEXT_DOMAIN); ?></h3>
                                                <div id="tcr-fonts-cufon">
                                                    <?php foreach ($fonts['google'] as $googleKey => $googleInfo) : ?>
                                                        <?php if (isset($googleInfo['preview'])) : ?>
                                                            <img class="tcr-font-preview" data-tcr-font="<?php echo esc_attr($googleKey); ?>" src="<?php echo TCR_URL . '/fonts/previews/' . $googleInfo['preview']; ?>" alt="<?php echo esc_attr($googleInfo['family']); ?>" title="<?php echo esc_attr($googleInfo['family']); ?>" />
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_font_selector"><?php esc_html_e('CSS selectors', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Find the CSS class / selector of the text you want to apply the font to and add it below', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="general_font_selector" id="general_font_selector"><?php echo _wp_specialchars($tcr['options']['general_font_selector'], ENT_NOQUOTES, false, true); ?></textarea>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Enter the CSS selectors you want to apply your chosen font to', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_font_fullscreen"><?php esc_html_e('Apply to background image captions', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="general_font_fullscreen" id="general_font_fullscreen" <?php checked(true, $tcr['options']['general_font_fullscreen']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The font will be applied to the full screen background caption titles', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_font_portfolio"><?php esc_html_e('Apply to portfolio item titles', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="general_font_portfolio" id="general_font_portfolio" <?php checked(true, $tcr['options']['general_font_portfolio']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The font will be applied to titles in the portfolio shortcode', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_font_serene"><?php esc_html_e('Apply to Serene caption titles', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="general_font_serene" id="general_font_serene" <?php checked(true, $tcr['options']['general_font_serene']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The font will be applied to titles in the Serene (full screen gallery) captions', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_font_fancybox"><?php esc_html_e('Apply to FancyBox caption titles', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="general_font_fancybox" id="general_font_fancybox" <?php checked(true, $tcr['options']['general_font_fancybox']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The font will be applied to titles in the FancyBox captions', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->

                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Add your analytics code', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-1-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="general_analytics"><?php esc_html_e('Analytics code', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Paste in the code from your analytics provider', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="general_analytics" id="general_analytics"><?php echo _wp_specialchars($tcr['options']['general_analytics'], ENT_NOQUOTES, false, true); ?></textarea>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('e.g. your Google Analytics code', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->

                    </div><!-- .tcr-tab-1 -->

                    <div class="tcr-tab-2">
                        <div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                                <li><span><?php esc_html_e('Images', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-image"></span></span></li>
                                <li><span><?php esc_html_e('Video', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-video"></span></span></li>
                                <li><span><?php esc_html_e('Audio', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-audio"></span></span></li>
                                <li><span><?php esc_html_e('Style', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-style"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Global page backgrounds', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-upload-image-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label><?php esc_html_e('Background images', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select image files from your computer', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <div class="tcr-upload-bg-button-wrap tcr-clearfix">
                                                <div id="background_upload" class="tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_upload_browse"></div></div>
                                                <div class="tcr-loading"></div>
                                            </div>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Upload your background image(s). We recommended 1920px wide by 1080px high with a file size of under 500kB.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-uploaded-images-table">
                                	<tr>
                                    	<td>
                                            <div id="background_backgrounds" class="tcr-clearfix tcr-upload-holder">
                                                <?php if (count($tcr['options']['background_backgrounds'])) : ?>
                                                    <?php foreach ($tcr['options']['background_backgrounds'] as $background) : ?>
                                                        <div class="tcr-uploaded-image tcr-bg-image" data-tcr-url="<?php echo esc_url($background['url']); ?>" data-tcr-file="<?php echo esc_url($background['file']); ?>" data-tcr-title="<?php echo esc_attr($background['title']); ?>" data-tcr-caption="<?php echo esc_attr($background['caption']); ?>" data-tcr-caption-position="<?php echo esc_attr($background['captionPosition']); ?>"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div title="<?php esc_attr_e('Delete image', TCR_ADMIN_TEXT_DOMAIN); ?>" class="tcr-delete-uploaded-image"></div><div title="<?php esc_attr_e('Edit caption', TCR_ADMIN_TEXT_DOMAIN); ?>" class="tcr-edit-background-image"></div></div></div><img src="<?php echo esc_url(TCR_URL . '/includes/timthumb.php?src=' . site_url() . $background['url'] . '&w=148&h=83&q=100'); ?>" alt="" /></div>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </div>
                                            <?php echo tcr_background_settings_form(); ?>
                                        </td>
                                    </tr>
                                </table>

                                <table class="tcr-form-table tcr-upload-image-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label><?php esc_html_e('Background image groups', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select image files from your computer', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <div id="tcr-add-background-group-button" class="tcr-button tcr-orange tcr-add"><span></span><?php esc_html_e('Add group', TCR_ADMIN_TEXT_DOMAIN); ?></div>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('You can save a group of images that can be set for a specific page. Choose a group in the metabox settings when adding/editing a post or page.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-uploaded-images-table">
                                	<tr>
                                    	<td>
                                    	    <div id="tcr-background-groups" class="tcr-clearfix">
                                    	        <?php // If making any changes to the HTML below, also change panel.js ?>
                                                <?php if (count($tcr['options']['background_groups'])) : ?>
                                                    <?php foreach ($tcr['options']['background_groups'] as $groupId => $group) : ?>
                                                        <div id="tcr-background-group-<?php echo $groupId; ?>" class="tcr-background-group tcr-upload-holder tcr-clearfix">
                                                            <div class="tcr-background-group-inner tcr-clearfix">
                                                                <div class="tcr-delete-background-group" title="<?php esc_attr_e('Delete group', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                                                                <div class="tcr-edit-background-group" title="<?php esc_attr_e('Edit group', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                                                                <div class="tcr-background-group-name">
                                                                    <span class="tcr-background-group-name-inner"><?php echo esc_html($group['name']); ?></span>
                                                                    <input type="text" class="tcr-background-group-name-input tcr-width-150" value="<?php echo _wp_specialchars($group['name'], ENT_COMPAT, false, true); ?>" />
                                                                </div>
                                                                <div class="tcr-background-group-settings">
                                                                    <div class="tcr-background-group-upload-wrap tcr-clearfix">
                                                                        <div class="tcr-swfupload-button tcr-background-group-upload"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_group_browse_<?php echo $groupId; ?>"></div></div>
                                                                        <div class="tcr-loading"></div>
                                                                    </div>
                                                        	        <div class="tcr-background-group-images tcr-clearfix">
                                                                    	<?php if (count($group['backgrounds'])) : ?>
                                                                            <?php foreach ($group['backgrounds'] as $background) : ?>
                                                                                <div class="tcr-uploaded-image tcr-bg-image" data-tcr-url="<?php echo esc_url($background['url']); ?>" data-tcr-file="<?php echo esc_url($background['file']); ?>" data-tcr-title="<?php echo esc_attr($background['title']); ?>" data-tcr-caption="<?php echo esc_attr($background['caption']); ?>" data-tcr-caption-position="<?php echo esc_attr($background['captionPosition']); ?>"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div title="<?php esc_attr_e('Delete image', TCR_ADMIN_TEXT_DOMAIN); ?>" class="tcr-delete-uploaded-image"></div><div title="<?php esc_attr_e('Edit caption', TCR_ADMIN_TEXT_DOMAIN); ?>" class="tcr-edit-background-image"></div></div></div><img src="<?php echo esc_url(TCR_URL . '/includes/timthumb.php?src=' . site_url() . $background['url'] . '&w=148&h=83&q=100'); ?>" alt="" /></div>
                                                                            <?php endforeach; ?>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                </table>

                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_speed"><?php esc_html_e('Transition speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="background_speed" id="background_speed" value="<?php echo esc_attr($tcr['options']['background_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="500" data-to="5000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Speed of the transition between background images, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_transition"><?php esc_html_e('Transition', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Type of animation between background images', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="background_transition" name="background_transition">
                                                <option value="none" <?php selected($tcr['options']['background_transition'], 'none'); ?>><?php esc_html_e('None', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="fade" <?php selected($tcr['options']['background_transition'], 'fade'); ?>><?php esc_html_e('Fade', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="fadeOutFadeIn" <?php selected($tcr['options']['background_transition'], 'fadeOutFadeIn'); ?>><?php esc_html_e('Fade Out / Fade In', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideDown"<?php selected($tcr['options']['background_transition'], 'slideDown'); ?> ><?php esc_html_e('Slide Down', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideRight"<?php selected($tcr['options']['background_transition'], 'slideRight'); ?> ><?php esc_html_e('Slide Right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideUp"<?php selected($tcr['options']['background_transition'], 'slideUp'); ?> ><?php esc_html_e('Slide Up', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideLeft"<?php selected($tcr['options']['background_transition'], 'slideLeft'); ?> ><?php esc_html_e('Slide Left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="carouselRight"<?php selected($tcr['options']['background_transition'], 'carouselRight'); ?> ><?php esc_html_e('Carousel Right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="carouselLeft"<?php selected($tcr['options']['background_transition'], 'carouselLeft'); ?> ><?php esc_html_e('Carousel Left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose the transition animation', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_position"><?php esc_html_e('Position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('This option will be noticeable when scrolling down a page', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="background_position" name="background_position">
                                                <option value="fixed" <?php selected($tcr['options']['background_position'], 'fixed'); ?>><?php esc_html_e('Fixed', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="absolute" <?php selected($tcr['options']['background_position'], 'absolute'); ?>><?php esc_html_e('Absolute', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The image will be always showing (Fixed) or positioned at the top of the page (Absolute)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_fit_landscape"><?php esc_html_e('Fit landscape', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="background_fit_landscape" id="background_fit_landscape" <?php checked(true, $tcr['options']['background_fit_landscape']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Prevent landscape images from being cropped by locking them at 100% width', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_fit_portrait"><?php esc_html_e('Fit portrait', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="background_fit_portrait" id="background_fit_portrait" <?php checked(true, $tcr['options']['background_fit_portrait']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Prevent portrait images from being cropped by locking them at 100% height', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_fit_always"><?php esc_html_e('Fit always', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="background_fit_always" id="background_fit_always" <?php checked(true, $tcr['options']['background_fit_always']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Prevent images from ever being cropped', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_position_x"><?php esc_html_e('Horizontal position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Useful when showing a focal point of the images', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<select id="background_position_x" name="background_position_x">
                                                <option value="left" <?php selected($tcr['options']['background_position_x'], 'left'); ?>><?php esc_html_e('Left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center" <?php selected($tcr['options']['background_position_x'], 'center'); ?>><?php esc_html_e('Center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right" <?php selected($tcr['options']['background_position_x'], 'right'); ?>><?php esc_html_e('Right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('How the image is aligned horizontally in the browser if it is not a perfect fit', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_position_y"><?php esc_html_e('Vertical position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Useful when showing a focal point of the images', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<select id="background_position_y" name="background_position_y">
                                                <option value="top" <?php selected($tcr['options']['background_position_y'], 'top'); ?>><?php esc_html_e('Top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center" <?php selected($tcr['options']['background_position_y'], 'center'); ?>><?php esc_html_e('Center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="bottom" <?php selected($tcr['options']['background_position_y'], 'bottom'); ?>><?php esc_html_e('Bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('How the image is aligned vertically in the browser if it is not a perfect fit', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_easing"><?php esc_html_e('Transition easing', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Enhances the animation', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<select id="background_easing" name="background_easing">
                                                <option value="swing" <?php selected($tcr['options']['background_easing'], 'swing'); ?>>swing</option>
                                                <option value="easeInQuad" <?php selected($tcr['options']['background_easing'], 'easeInQuad'); ?>>easeInQuad</option>
                                                <option value="easeOutQuad" <?php selected($tcr['options']['background_easing'], 'easeOutQuad'); ?>>easeOutQuad</option>
                                                <option value="easeInOutQuad" <?php selected($tcr['options']['background_easing'], 'easeInOutQuad'); ?>>easeInOutQuad</option>
                                                <option value="easeInCubic" <?php selected($tcr['options']['background_easing'], 'easeInCubic'); ?>>easeInCubic</option>
                                                <option value="easeOutCubic" <?php selected($tcr['options']['background_easing'], 'easeOutCubic'); ?>>easeOutCubic</option>
                                                <option value="easeInOutCubic" <?php selected($tcr['options']['background_easing'], 'easeInOutCubic'); ?>>easeInOutCubic</option>
                                                <option value="easeInQuart" <?php selected($tcr['options']['background_easing'], 'easeInQuart'); ?>>easeInQuart</option>
                                                <option value="easeOutQuart" <?php selected($tcr['options']['background_easing'], 'easeOutQuart'); ?>>easeOutQuart</option>
                                                <option value="easeInOutQuart" <?php selected($tcr['options']['background_easing'], 'easeInOutQuart'); ?>>easeInOutQuart</option>
                                                <option value="easeInQuint" <?php selected($tcr['options']['background_easing'], 'easeInQuint'); ?>>easeInQuint</option>
                                                <option value="easeOutQuint" <?php selected($tcr['options']['background_easing'], 'easeOutQuint'); ?>>easeOutQuint</option>
                                                <option value="easeInOutQuint" <?php selected($tcr['options']['background_easing'], 'easeInOutQuint'); ?>>easeInOutQuint</option>
                                                <option value="easeInSine" <?php selected($tcr['options']['background_easing'], 'easeInSine'); ?>>easeInSine</option>
                                                <option value="easeOutSine" <?php selected($tcr['options']['background_easing'], 'easeOutSine'); ?>>easeOutSine</option>
                                                <option value="easeInOutSine" <?php selected($tcr['options']['background_easing'], 'easeInOutSine'); ?>>easeInOutSine</option>
                                                <option value="easeInExpo" <?php selected($tcr['options']['background_easing'], 'easeInExpo'); ?>>easeInExpo</option>
                                                <option value="easeOutExpo" <?php selected($tcr['options']['background_easing'], 'easeOutExpo'); ?>>easeOutExpo</option>
                                                <option value="easeInOutExpo" <?php selected($tcr['options']['background_easing'], 'easeInOutExpo'); ?>>easeInOutExpo</option>
                                                <option value="easeInCirc" <?php selected($tcr['options']['background_easing'], 'easeInCirc'); ?>>easeInCirc</option>
                                                <option value="easeOutCirc" <?php selected($tcr['options']['background_easing'], 'easeOutCirc'); ?>>easeOutCirc</option>
                                                <option value="easeInOutCirc" <?php selected($tcr['options']['background_easing'], 'easeInOutCirc'); ?>>easeInOutCirc</option>
                                                <option value="easeInElastic" <?php selected($tcr['options']['background_easing'], 'easeInElastic'); ?>>easeInElastic</option>
                                                <option value="easeOutElastic" <?php selected($tcr['options']['background_easing'], 'easeOutElastic'); ?>>easeOutElastic</option>
                                                <option value="easeInOutElastic" <?php selected($tcr['options']['background_easing'], 'easeInOutElastic'); ?>>easeInOutElastic</option>
                                                <option value="easeInBack" <?php selected($tcr['options']['background_easing'], 'easeInBack'); ?>>easeInBack</option>
                                                <option value="easeOutBack" <?php selected($tcr['options']['background_easing'], 'easeOutBack'); ?>>easeOutBack</option>
                                                <option value="easeInOutBack" <?php selected($tcr['options']['background_easing'], 'easeInOutBack'); ?>>easeInOutBack</option>
                                                <option value="easeInBounce" <?php selected($tcr['options']['background_easing'], 'easeInBounce'); ?>>easeInBounce</option>
                                                <option value="easeOutBounce" <?php selected($tcr['options']['background_easing'], 'easeOutBounce'); ?>>easeOutBounce</option>
                                                <option value="easeInOutBounce" <?php selected($tcr['options']['background_easing'], 'easeInOutBounce'); ?>>easeInOutBounce</option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The easing function to use for the transition', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_hide_speed"><?php esc_html_e('Content hide speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="text" name="background_hide_speed" id="background_hide_speed" value="<?php echo esc_attr($tcr['options']['background_hide_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="3000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Speed that the page content is hidden at, when activating full screen mode', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_show_speed"><?php esc_html_e('Content show speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="text" name="background_show_speed" id="background_show_speed" value="<?php echo esc_attr($tcr['options']['background_show_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="5000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Speed that the page content is shown at, when closing full screen mode', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_control_speed"><?php esc_html_e('Control fade in speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="text" name="background_control_speed" id="background_control_speed" value="<?php echo esc_attr($tcr['options']['background_control_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="5000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The speed that the controls fade in when going to full screen mode, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_save"><?php esc_html_e('Save last background', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Never miss an image when navigating pages', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="checkbox" class="tcr-toggle-yn" name="background_save" id="background_save" <?php checked(true, $tcr['options']['background_save']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, the background that was last active will be the starting point for the slideshow when going to another page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_slideshow"><?php esc_html_e('Slideshow', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Auto rotation of the images', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="checkbox" class="tcr-toggle" name="background_slideshow" id="background_slideshow" <?php checked(true, $tcr['options']['background_slideshow']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, the images will be rotated through in a slideshow', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_slideshow_auto"><?php esc_html_e('Start slideshow automatically', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="background_slideshow_auto" id="background_slideshow_auto" <?php checked(true, $tcr['options']['background_slideshow_auto']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, the slideshow will start automatically', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_slideshow_speed"><?php esc_html_e('Slideshow pause time', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="background_slideshow_speed" id="background_slideshow_speed" value="<?php echo esc_attr($tcr['options']['background_slideshow_speed']); ?>" class="tcr-range-slider tcr-width-75" data-from="1000" data-to="30000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The time that each image in the slideshow is shown for, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_random"><?php esc_html_e('Randomize', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Mix them up', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="background_random" id="background_random" <?php checked(true, $tcr['options']['background_random']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, the backgrounds will appear in random order', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_keyboard"><?php esc_html_e('Keyboard controls', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Gives user keyboard control', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="background_keyboard" id="background_keyboard" <?php checked(true, $tcr['options']['background_keyboard']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, in maximize mode the Right and Left arrow keys can be use to move through the images and the Esc key will return to normal mode', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_caption_position"><?php esc_html_e('Caption position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="background_caption_position" name="background_caption_position">
                                                <option value="random" <?php selected($tcr['options']['background_caption_position'], 'random'); ?>><?php esc_html_e('Random', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left top" <?php selected($tcr['options']['background_caption_position'], 'left top'); ?>><?php esc_html_e('left top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left center" <?php selected($tcr['options']['background_caption_position'], 'left center'); ?>><?php esc_html_e('left center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left bottom" <?php selected($tcr['options']['background_caption_position'], 'left bottom'); ?>><?php esc_html_e('left bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center top" <?php selected($tcr['options']['background_caption_position'], 'center top'); ?>><?php esc_html_e('center top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center center" <?php selected($tcr['options']['background_caption_position'], 'center center'); ?>><?php esc_html_e('center center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center bottom" <?php selected($tcr['options']['background_caption_position'], 'center bottom'); ?>><?php esc_html_e('center bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right top" <?php selected($tcr['options']['background_caption_position'], 'right top'); ?>><?php esc_html_e('right top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right center" <?php selected($tcr['options']['background_caption_position'], 'right center'); ?>><?php esc_html_e('right center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right bottom" <?php selected($tcr['options']['background_caption_position'], 'right bottom'); ?>><?php esc_html_e('right bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The default caption position', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_caption_speed"><?php esc_html_e('Caption fade speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="background_caption_speed" id="background_caption_speed" value="<?php echo esc_attr($tcr['options']['background_caption_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="5000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The speed of the caption fade animation, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_bullets"><?php esc_html_e('Bullet navigation', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('A navigation method to switch to any image on full screen mode', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="background_bullets" id="background_bullets" <?php checked(true, $tcr['options']['background_bullets']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, in full screen mode you can change images using bullet navigation', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_low_quality"><?php esc_html_e('Low quality transitions', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('A performance enhancer, if required', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="background_low_quality" id="background_low_quality" <?php checked(true, $tcr['options']['background_low_quality']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, the transitions will be lower quality which improves performance', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_breaker"><?php esc_html_e('Show breaker', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('A breaker borders the bottom of the image', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="background_breaker" id="background_breaker" <?php checked(true, $tcr['options']['background_breaker']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, a breaker image is used between the background and the rest of the page, works well with "Absolute" position', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_breaker_on_max"><?php esc_html_e('Show breaker in full screen mode', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="background_breaker_on_max" id="background_breaker_on_max" <?php checked(true, $tcr['options']['background_breaker_on_max']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('When active, the breaker will also be shown in full screen mode', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Video', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_video"><?php esc_html_e('Video URL', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Enter the URL including http://', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="background_video" id="background_video" value="<?php echo esc_attr($tcr['options']['background_video']); ?>" class="tcr-width-400" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Enter the URL of a YouTube or Vimeo video. The background video will show instead of the background images, except on tablets and mobile devices.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label><?php esc_html_e('Video dimensions', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Ensures best scaling', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <div class="tcr-background-video-width">
                                        	    <label for="background_video_width"><?php esc_html_e('Width', TCR_ADMIN_TEXT_DOMAIN); ?> <input type="text" name="background_video_width" id="background_video_width" value="<?php echo esc_attr($tcr['options']['background_video_width']); ?>" class="tcr-width-50" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            </div>
                                            <div class="tcr-background-video-height">
                                            	<label for="background_video_height"><?php esc_html_e('Height', TCR_ADMIN_TEXT_DOMAIN); ?> <input type="text" name="background_video_height" id="background_video_height" value="<?php echo esc_attr($tcr['options']['background_video_height']); ?>" class="tcr-width-50" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            </div>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php printf(esc_html__('Please enter the dimensions of the original video for accurate scaling. This information will be fetched from Vimeo automatically, for YouTube please %sfind the dimensions manually%s.', TCR_ADMIN_TEXT_DOMAIN), '<a href="' . TCR_ADMIN_URL . '/images/video_dimensions_from_youtube.jpg" class="tcr-external-link">', '</a>'); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_video_autostart"><?php esc_html_e('Auto-start video', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="checkbox" class="tcr-toggle" name="background_video_autostart" id="background_video_autostart" <?php checked(true, $tcr['options']['background_video_autostart']); ?> value="1" />

                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Start the video automatically', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_video_complete"><?php esc_html_e('When video finishes', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="background_video_complete" name="background_video_complete">
                                        		<option value="none" <?php selected($tcr['options']['background_video_complete'], 'none'); ?>><?php esc_html_e('Do nothing', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                        		<option value="restart" <?php selected($tcr['options']['background_video_complete'], 'restart'); ?>><?php esc_html_e('Restart video', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                        		<option value="hide" <?php selected($tcr['options']['background_video_complete'], 'hide'); ?>><?php esc_html_e('Hide video', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                        		<option value="redirect" <?php selected($tcr['options']['background_video_complete'], 'redirect'); ?>><?php esc_html_e('Redirect to another page', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose an action to take when the video has finished playing', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table id="background_video_redirect_wrap" class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_video_redirect"><?php esc_html_e('Redirect URL', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="background_video_redirect" id="background_video_redirect" value="<?php echo esc_attr($tcr['options']['background_video_redirect']); ?>" class="tcr-width-400" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Enter the URL to redirect to when the video has finished playing', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_video_start"><?php esc_html_e('Video start position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('The video will start at this number of seconds after the start', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="text" name="background_video_start" id="background_video_start" value="<?php echo esc_attr($tcr['options']['background_video_start']); ?>" class="tcr-width-50" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Skip playback to the specified number of seconds into the video', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Audio', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label><?php esc_html_e('Background music', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Upload audio files from your computer', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                    		<div class="tcr-add-audio-track-button-wrap tcr-clearfix">
                                                <div id="tcr-add-audio-track-button" class="tcr-button tcr-orange tcr-add"><span></span><?php esc_html_e('Add a music track', TCR_ADMIN_TEXT_DOMAIN); ?></div>
                                            </div>
                                            <div id="tcr-audio-tracks" class="tcr-clearfix">
                                                <?php // If making any changes to the HTML below, also change panel.js ?>
                                                <?php foreach ($tcr['options']['background_audio'] as $trackId => $track) : ?>
                                                    <div id="tcr-audio-track-<?php echo $trackId; ?>" class="tcr-audio-track tcr-clearfix">
                                                    	<div class="tcr-audio-track-inner">
                                                            <div class="tcr-delete-audio-track" title="<?php esc_attr_e('Delete track', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                                                            <div class="tcr-edit-audio-track" title="<?php esc_attr_e('Edit track', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                                                            <div class="tcr-drag-audio-track" title="<?php esc_attr_e('Move track', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                                                            <div class="tcr-audio-track-name">
                                                                <span class="tcr-audio-track-name-inner"><?php echo esc_html($track['name']); ?></span>
                                                                <input type="text" class="tcr-audio-track-name-input tcr-width-150" value="<?php echo _wp_specialchars($track['name'], ENT_COMPAT, false, true); ?>" />
                                                            </div>
                                                            <div class="tcr-audio-track-settings">
                                                                <table class="tcr-audio-track-settings">
                                                                	<tr class="tcr-audio-format-title">
                                                                		<th colspan="2"><?php esc_html_e('M4A file URL', TCR_ADMIN_TEXT_DOMAIN); ?></th>
                                                                    </tr>
                                                                    <tr class="tcr-audio-format">
                                                                		<td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-m4a" value="<?php echo _wp_specialchars($track['m4a'], ENT_COMPAT, false, true); ?>" /></td>
                                                                		<td class="tcr-audio-format-upload-td">
                                                                    		<div class="tcr-upload-audio-track-button-wrap tcr-clearfix">
                                                                                <div class="tcr-upload-audio-format-button tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_audio_format_m4a_<?php echo $trackId; ?>"></div></div>
                                                                                <div class="tcr-loading"></div>
                                                                            </div>
                                                                		</td>
                                                                	</tr>

                                                                	<tr class="tcr-audio-format-title">
                                                                		<th colspan="2"><?php esc_html_e('MP3 file URL', TCR_ADMIN_TEXT_DOMAIN); ?></th>
                                                                    </tr>
                                                                    <tr class="tcr-audio-format">
                                                                		<td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-mp3" value="<?php echo _wp_specialchars($track['mp3'], ENT_COMPAT, false, true); ?>" /></td>
                                                                		<td class="tcr-audio-format-upload-td">
                                                                			<div class="tcr-upload-audio-track-button-wrap tcr-clearfix">
                                                                                <div class="tcr-upload-audio-format-button tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_audio_format_mp3_<?php echo $trackId; ?>"></div></div>
                                                                                <div class="tcr-loading"></div>
                                                                            </div>
                                                                        </td>
                                                                	</tr>

                                                                	<tr class="tcr-audio-format-title">
                                                                		<th colspan="2"><?php esc_html_e('OGG file URL (optional)', TCR_ADMIN_TEXT_DOMAIN); ?></th>
                                                                    </tr>
                                                                    <tr class="tcr-audio-format">
                                                                		<td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-ogg" value="<?php echo _wp_specialchars($track['oga'], ENT_COMPAT, false, true); ?>" /></td>
                                                                		<td class="tcr-audio-format-upload-td">
                                                                        	<div class="tcr-upload-audio-track-button-wrap tcr-clearfix">
                                                                                <div class="tcr-upload-audio-format-button tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_audio_format_ogg_<?php echo $trackId; ?>"></div></div>
                                                                                <div class="tcr-loading"></div>
                                                                            </div>
                                                                        </td>
                                                                	</tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Either a .mp3 or .m4a file is required, uploading a .ogg version will increase browser support. You need to use the same chosen formats for every track you add. For example if you choose .m4a and .ogg for your first track, every other track should have both a .m4a and .ogg version.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_audio_random"><?php esc_html_e('Randomize music', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Mix them up', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="checkbox" class="tcr-toggle" name="background_audio_random" id="background_audio_random" <?php checked(true, $tcr['options']['background_audio_random']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Randomize the order of the tracks', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_audio_autostart"><?php esc_html_e('Auto-start music', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Start playing on page loading', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<input type="checkbox" class="tcr-toggle" name="background_audio_autostart" id="background_audio_autostart" <?php checked(true, $tcr['options']['background_audio_autostart']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Start the music track automatically', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_audio_complete"><?php esc_html_e('When music finishes', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                        	<select id="background_audio_complete" name="background_audio_complete">
                                        		<option value="none" <?php selected($tcr['options']['background_audio_complete'], 'none'); ?>><?php esc_html_e('Do nothing', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                        		<option value="restart" <?php selected($tcr['options']['background_audio_complete'], 'restart'); ?>><?php esc_html_e('Restart music', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose an action to take when the music has finished playing', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Style', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="background_overlay"><?php esc_html_e('Background overlay', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Pick a style', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="background_overlay" name="background_overlay" class="tcr-texture-selector">
                                            	<?php $options = tcr_get_background_overlay_options(); ?>
                                            	<?php foreach ($options as $value => $label) : ?>
                                            		<option value="<?php echo esc_attr($value);?>" <?php selected($tcr['options']['background_overlay'], $value); ?>><?php echo esc_html($label, TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            	<?php endforeach; ?>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose a style of background overlay. This is an semi transparent image that will repeat over your background for added effect', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->

                    </div><!-- .tcr-tab-2 -->

                    <div class="tcr-tab-3">
                    	<div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                                <li><span><?php esc_html_e('General', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-general"></span></span></li>
                                <li><span><?php esc_html_e('Images', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-image"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Blog settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_layout"><?php esc_html_e('Layout', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose a layout', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select name="blog_layout" id="blog_layout" class="tcr-layout-selector">
                                                <option value="left-sidebar" <?php selected($tcr['options']['blog_layout'], 'left-sidebar'); ?>><?php esc_html_e('Left sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="full-width" <?php selected($tcr['options']['blog_layout'], 'full-width'); ?>><?php esc_html_e('Full width', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right-sidebar" <?php selected($tcr['options']['blog_layout'], 'right-sidebar'); ?>><?php esc_html_e('Right sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose the layout for the main Blog page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_single_layout"><?php esc_html_e('Single layout', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose a layout', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select name="blog_single_layout" id="blog_single_layout" class="tcr-layout-selector">
                                                <option value="left-sidebar" <?php selected($tcr['options']['blog_single_layout'], 'left-sidebar'); ?>><?php esc_html_e('Left sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="full-width" <?php selected($tcr['options']['blog_single_layout'], 'full-width'); ?>><?php esc_html_e('Full width', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right-sidebar" <?php selected($tcr['options']['blog_single_layout'], 'right-sidebar'); ?>><?php esc_html_e('Right sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose the page layout of a single blog post', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_show_date_circle"><?php esc_html_e('Show date circle', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle bc-toggle-yn" name="blog_show_date_circle" id="blog_show_date_circle" <?php checked(true, $tcr['options']['blog_show_date_circle']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Show the post date circle next to the post title', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>

                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_show_author_description"><?php esc_html_e('Show author description', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="blog_show_author_description" id="blog_show_author_description" <?php checked(true, $tcr['options']['blog_show_author_description']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Show author description on author archive page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_show_single_nav"><?php esc_html_e('Single post navigation', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="blog_show_single_nav" id="blog_show_single_nav" <?php checked(true, $tcr['options']['blog_show_single_nav']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Show previous / next post navigation on single posts', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label><?php esc_html_e('Comments layout', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('How you would like to show comments and trackbacks', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <label><input type="radio" name="blog_comments_layout" <?php checked('tabs', $tcr['options']['blog_comments_layout']); ?> value="tabs" /> <?php esc_html_e('Comments and trackbacks in separate tabs', TCR_ADMIN_TEXT_DOMAIN); ?></label><br />
                                            <label><input type="radio" name="blog_comments_layout" <?php checked('mixed', $tcr['options']['blog_comments_layout']); ?> value="mixed" /> <?php esc_html_e('Comments and trackbacks mixed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose a method of displaying comments and trackbacks', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_title"><?php esc_html_e('Blog page title', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Give your blog a name; Blog, news, etc', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="blog_title" id="blog_title" value="<?php echo _wp_specialchars($tcr['options']['blog_title'], ENT_COMPAT, false, true); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The title of the main Blog page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_subtitle"><?php esc_html_e('Blog page subtitle', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="blog_subtitle" id="blog_subtitle" value="<?php echo _wp_specialchars($tcr['options']['blog_subtitle'], ENT_COMPAT, false, true); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The subtitle of the main Blog page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Single Post Images', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_single_featured_image"><?php esc_html_e('Featured image', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Show featured image? Featured images can be set in the post', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="blog_single_featured_image" id="blog_single_featured_image" <?php checked(true, $tcr['options']['blog_single_featured_image']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Display the featured image when viewing a single blog post, you can override this per post in the post metabox settings', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_single_featured_image_type"><?php esc_html_e('Featured image type', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose how the featured image is displayed', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select name="blog_single_featured_image_type" id="blog_single_featured_image_type">
                                                <option value="full" <?php selected($tcr['options']['blog_single_featured_image_type'], 'full'); ?>><?php esc_html_e('Full width', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left" <?php selected($tcr['options']['blog_single_featured_image_type'], 'left'); ?>><?php esc_html_e('Float left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right" <?php selected($tcr['options']['blog_single_featured_image_type'], 'right'); ?>><?php esc_html_e('Float right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The featured image type when viewing single posts', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_scale_featured_height"><?php esc_html_e('Scale featured image height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Ensures consistency in image display', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="blog_scale_featured_height" id="blog_scale_featured_height" <?php checked(true, $tcr['options']['blog_scale_featured_height']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('When the featured image is resized the height will be scaled automatically', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_fixed_featured_height"><?php esc_html_e('Fixed featured image height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="blog_fixed_featured_height" id="blog_fixed_featured_height" value="<?php echo _wp_specialchars($tcr['options']['blog_fixed_featured_height'], ENT_COMPAT, false, true); ?>" class="tcr-range-slider tcr-width-50" data-from="50" data-to="500" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('If the Scale option is off this height will be used', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_single_featured_float_width"><?php esc_html_e('Float featured image width', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="blog_single_featured_float_width" id="blog_single_featured_float_width" value="<?php echo _wp_specialchars($tcr['options']['blog_single_featured_float_width'], ENT_COMPAT, false, true); ?>" class="tcr-range-slider tcr-width-50" data-from="10" data-to="500" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The width of floating featured image for single posts', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_single_featured_float_height"><?php esc_html_e('Float featured image height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="blog_single_featured_float_height" id="blog_single_featured_float_height" value="<?php echo _wp_specialchars($tcr['options']['blog_single_featured_float_height'], ENT_COMPAT, false, true); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="500" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The height of floating featured image for single posts, set to 0 to be scaled automatically from the image dimensions', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Blog Archive Images', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_featured_image"><?php esc_html_e('Featured image', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Show featured image? Featured images can be set in your post', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="blog_featured_image" id="blog_featured_image" <?php checked(true, $tcr['options']['blog_featured_image']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Display the featured image when viewing the blog archive pages', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_featured_image_type"><?php esc_html_e('Featured image type', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose how the featured image is displayed', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select name="blog_featured_image_type" id="blog_featured_image_type">
                                                <option value="below" <?php selected($tcr['options']['blog_featured_image_type'], 'below'); ?>><?php esc_html_e('Below title (full width)', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="above" <?php selected($tcr['options']['blog_featured_image_type'], 'above'); ?>><?php esc_html_e('Above title (full width)', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left" <?php selected($tcr['options']['blog_featured_image_type'], 'left'); ?>><?php esc_html_e('Float left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right" <?php selected($tcr['options']['blog_featured_image_type'], 'right'); ?>><?php esc_html_e('Float right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The featured image type when viewing the blog archive pages, also the default for the blog shortcode', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_featured_float_width"><?php esc_html_e('Float featured image width', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="blog_featured_float_width" id="blog_featured_float_width" value="<?php echo _wp_specialchars($tcr['options']['blog_featured_float_width'], ENT_COMPAT, false, true); ?>" class="tcr-range-slider tcr-width-50" data-from="10" data-to="500" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The width of floating featured image for blog archive pages, also the default for the blog shortcode', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-3-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="blog_featured_float_height"><?php esc_html_e('Float featured image height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="blog_featured_float_height" id="blog_featured_float_height" value="<?php echo _wp_specialchars($tcr['options']['blog_featured_float_height'], ENT_COMPAT, false, true); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="500" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The height of floating featured image for blog archive pages, also the default for the blog shortcode, set to 0 to be scaled automatically from the image dimensions', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->
                    </div><!-- .tcr-tab-3 -->

                    <div class="tcr-tab-4">
                    	<div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                                <li><span><?php esc_html_e('General', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-general"></span></span></li>
                                <li><span><?php esc_html_e('Full Screen', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-fullscreen"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Portfolio settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_single_layout"><?php esc_html_e('Single layout', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Choose a layout', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select name="portfolio_single_layout" id="portfolio_single_layout" class="tcr-layout-selector">
                                                <option value="left-sidebar" <?php selected($tcr['options']['portfolio_single_layout'], 'left-sidebar'); ?>><?php esc_html_e('Left sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="full-width" <?php selected($tcr['options']['portfolio_single_layout'], 'full-width'); ?>><?php esc_html_e('Full width', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right-sidebar" <?php selected($tcr['options']['portfolio_single_layout'], 'right-sidebar'); ?>><?php esc_html_e('Right sidebar', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Choose the page layout when viewing a single portfolio item', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_show_single_nav"><?php esc_html_e('Single navigation', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Show or hide navigation on single item', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_show_single_nav" id="portfolio_show_single_nav" <?php checked(true, $tcr['options']['portfolio_show_single_nav']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Show previous / next post navigation on single portfolio items', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_featured_image"><?php esc_html_e('Featured image', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Show featured image? Featured images can be set in your portfolio post', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_featured_image" id="portfolio_featured_image" <?php checked(true, $tcr['options']['portfolio_featured_image']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Display the featured image when viewing a single portfolio item, you can override this per item in the portfolio metabox settings', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_scale_featured_height"><?php esc_html_e('Scale featured image height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Ensures consistency in image display', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="portfolio_scale_featured_height" id="portfolio_scale_featured_height" <?php checked(true, $tcr['options']['portfolio_scale_featured_height']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('When the featured image is resized the height will be scaled automatically', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_fixed_featured_height"><?php esc_html_e('Fixed featured image height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_fixed_featured_height" id="portfolio_fixed_featured_height" value="<?php echo _wp_specialchars($tcr['options']['portfolio_fixed_featured_height'], ENT_COMPAT, false, true); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="500" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('If the Scale option is off this height will be used', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_video_width"><?php esc_html_e('Video width', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_video_width" id="portfolio_video_width" value="<?php echo esc_attr($tcr['options']['portfolio_video_width']); ?>" class="tcr-range-slider tcr-width-50" data-from="100" data-to="1000" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The width of the video lightbox for Video portfolio items', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_video_height"><?php esc_html_e('Video height', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_video_height" id="portfolio_video_height" value="<?php echo esc_attr($tcr['options']['portfolio_video_height']); ?>" class="tcr-range-slider tcr-width-50" data-from="100" data-to="1000" /> <?php echo _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN); ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The height of the video lightbox for Video portfolio items', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_comments"><?php esc_html_e('Allow comments', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="portfolio_comments" id="portfolio_comments" <?php checked(true, $tcr['options']['portfolio_comments']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Allow visitors to comment on portfolio items', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_rewrite_slug"><?php esc_html_e('Portfolio rewrite slug', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('How the page name is displayed in the URL', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_rewrite_slug" id="portfolio_rewrite_slug" value="<?php echo esc_attr($tcr['options']['portfolio_rewrite_slug']); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e("You can change the portfolio URL slug here, its 'portfolio' by default. You should not have it with the same name as one of your pages.", TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Serene (full screen gallery) settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_speed"><?php esc_html_e('Transition speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_speed" id="portfolio_speed" value="<?php echo esc_attr($tcr['options']['portfolio_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="500" data-to="5000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Speed of the transition between images, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_transition"><?php esc_html_e('Transition', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Type of animation between background images', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="portfolio_transition" name="portfolio_transition">
                                                <option value="none" <?php selected($tcr['options']['portfolio_transition'], 'none'); ?>><?php esc_html_e('None', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="fade" <?php selected($tcr['options']['portfolio_transition'], 'fade'); ?>><?php esc_html_e('Fade', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="fadeOutFadeIn" <?php selected($tcr['options']['portfolio_transition'], 'fadeOutFadeIn'); ?>><?php esc_html_e('Fade Out / Fade In', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideDown"<?php selected($tcr['options']['portfolio_transition'], 'slideDown'); ?> ><?php esc_html_e('Slide Down', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideRight"<?php selected($tcr['options']['portfolio_transition'], 'slideRight'); ?> ><?php esc_html_e('Slide Right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideUp"<?php selected($tcr['options']['portfolio_transition'], 'slideUp'); ?> ><?php esc_html_e('Slide Up', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="slideLeft"<?php selected($tcr['options']['portfolio_transition'], 'slideLeft'); ?> ><?php esc_html_e('Slide Left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="carouselRight" <?php selected($tcr['options']['portfolio_transition'], 'carouselRight'); ?>><?php esc_html_e('Carousel Right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="carouselLeft" <?php selected($tcr['options']['portfolio_transition'], 'carouselLeft'); ?>><?php esc_html_e('Carousel Left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Choose the transition animation', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_fit_landscape"><?php esc_html_e('Fit landscape', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_fit_landscape" id="portfolio_fit_landscape" <?php checked(true, $tcr['options']['portfolio_fit_landscape']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Prevent landscape images from being cropped by locking them at 100% width', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_fit_portrait"><?php esc_html_e('Fit portrait', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_fit_portrait" id="portfolio_fit_portrait" <?php checked(true, $tcr['options']['portfolio_fit_portrait']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Prevent portrait images from being cropped by locking them at 100% height', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-2-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_fit_always"><?php esc_html_e('Fit always', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_fit_always" id="portfolio_fit_always" <?php checked(true, $tcr['options']['portfolio_fit_always']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Prevent images from ever being cropped', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_position_x"><?php esc_html_e('Horizontal position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Useful when showing a focal point of the images', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="portfolio_position_x" name="portfolio_position_x">
                                                <option value="left" <?php selected($tcr['options']['portfolio_position_x'], 'left'); ?>><?php esc_html_e('Left', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center" <?php selected($tcr['options']['portfolio_position_x'], 'center'); ?>><?php esc_html_e('Center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right" <?php selected($tcr['options']['portfolio_position_x'], 'right'); ?>><?php esc_html_e('Right', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('How the image is aligned horizontally in the browser if it is not a perfect fit', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_position_y"><?php esc_html_e('Vertical position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Useful when showing a focal point of the images', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="portfolio_position_y" name="portfolio_position_y">
                                                <option value="top" <?php selected($tcr['options']['portfolio_position_y'], 'top'); ?>><?php esc_html_e('Top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center" <?php selected($tcr['options']['portfolio_position_y'], 'center'); ?>><?php esc_html_e('Center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="bottom" <?php selected($tcr['options']['portfolio_position_y'], 'bottom'); ?>><?php esc_html_e('Bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('How the image is aligned vertically in the browser if it is not a perfect fit', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_easing"><?php esc_html_e('Transition easing', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Enhances the animation', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="portfolio_easing" name="portfolio_easing">
                                                <option value="swing" <?php selected($tcr['options']['portfolio_easing'], 'swing'); ?>>swing</option>
                                                <option value="easeInQuad" <?php selected($tcr['options']['portfolio_easing'], 'easeInQuad'); ?>>easeInQuad</option>
                                                <option value="easeOutQuad" <?php selected($tcr['options']['portfolio_easing'], 'easeOutQuad'); ?>>easeOutQuad</option>
                                                <option value="easeInOutQuad" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutQuad'); ?>>easeInOutQuad</option>
                                                <option value="easeInCubic" <?php selected($tcr['options']['portfolio_easing'], 'easeInCubic'); ?>>easeInCubic</option>
                                                <option value="easeOutCubic" <?php selected($tcr['options']['portfolio_easing'], 'easeOutCubic'); ?>>easeOutCubic</option>
                                                <option value="easeInOutCubic" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutCubic'); ?>>easeInOutCubic</option>
                                                <option value="easeInQuart" <?php selected($tcr['options']['portfolio_easing'], 'easeInQuart'); ?>>easeInQuart</option>
                                                <option value="easeOutQuart" <?php selected($tcr['options']['portfolio_easing'], 'easeOutQuart'); ?>>easeOutQuart</option>
                                                <option value="easeInOutQuart" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutQuart'); ?>>easeInOutQuart</option>
                                                <option value="easeInQuint" <?php selected($tcr['options']['portfolio_easing'], 'easeInQuint'); ?>>easeInQuint</option>
                                                <option value="easeOutQuint" <?php selected($tcr['options']['portfolio_easing'], 'easeOutQuint'); ?>>easeOutQuint</option>
                                                <option value="easeInOutQuint" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutQuint'); ?>>easeInOutQuint</option>
                                                <option value="easeInSine" <?php selected($tcr['options']['portfolio_easing'], 'easeInSine'); ?>>easeInSine</option>
                                                <option value="easeOutSine" <?php selected($tcr['options']['portfolio_easing'], 'easeOutSine'); ?>>easeOutSine</option>
                                                <option value="easeInOutSine" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutSine'); ?>>easeInOutSine</option>
                                                <option value="easeInExpo" <?php selected($tcr['options']['portfolio_easing'], 'easeInExpo'); ?>>easeInExpo</option>
                                                <option value="easeOutExpo" <?php selected($tcr['options']['portfolio_easing'], 'easeOutExpo'); ?>>easeOutExpo</option>
                                                <option value="easeInOutExpo" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutExpo'); ?>>easeInOutExpo</option>
                                                <option value="easeInCirc" <?php selected($tcr['options']['portfolio_easing'], 'easeInCirc'); ?>>easeInCirc</option>
                                                <option value="easeOutCirc" <?php selected($tcr['options']['portfolio_easing'], 'easeOutCirc'); ?>>easeOutCirc</option>
                                                <option value="easeInOutCirc" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutCirc'); ?>>easeInOutCirc</option>
                                                <option value="easeInElastic" <?php selected($tcr['options']['portfolio_easing'], 'easeInElastic'); ?>>easeInElastic</option>
                                                <option value="easeOutElastic" <?php selected($tcr['options']['portfolio_easing'], 'easeOutElastic'); ?>>easeOutElastic</option>
                                                <option value="easeInOutElastic" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutElastic'); ?>>easeInOutElastic</option>
                                                <option value="easeInBack" <?php selected($tcr['options']['portfolio_easing'], 'easeInBack'); ?>>easeInBack</option>
                                                <option value="easeOutBack" <?php selected($tcr['options']['portfolio_easing'], 'easeOutBack'); ?>>easeOutBack</option>
                                                <option value="easeInOutBack" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutBack'); ?>>easeInOutBack</option>
                                                <option value="easeInBounce" <?php selected($tcr['options']['portfolio_easing'], 'easeInBounce'); ?>>easeInBounce</option>
                                                <option value="easeOutBounce" <?php selected($tcr['options']['portfolio_easing'], 'easeOutBounce'); ?>>easeOutBounce</option>
                                                <option value="easeInOutBounce" <?php selected($tcr['options']['portfolio_easing'], 'easeInOutBounce'); ?>>easeInOutBounce</option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The easing function to use for the transition', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_control_speed"><?php esc_html_e('Control fade speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_control_speed" id="portfolio_control_speed" value="<?php echo esc_attr($tcr['options']['portfolio_control_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="0" data-to="5000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The speed that the controls fade at when going to full screen mode, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_slideshow"><?php esc_html_e('Slideshow', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Auto rotation of the image', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_slideshow" id="portfolio_slideshow" <?php checked(true, $tcr['options']['portfolio_slideshow']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('When active, the images will be rotated through in a slideshow', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_slideshow_auto"><?php esc_html_e('Start slideshow automatically', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="portfolio_slideshow_auto" id="portfolio_slideshow_auto" <?php checked(true, $tcr['options']['portfolio_slideshow_auto']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('When active, the slideshow will start automatically', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_slideshow_speed"><?php esc_html_e('Slideshow pause time', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_slideshow_speed" id="portfolio_slideshow_speed" value="<?php echo esc_attr($tcr['options']['portfolio_slideshow_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="1000" data-to="30000"  data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The time that each image in the slideshow is shown for, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_keyboard"><?php esc_html_e('Keyboard controls', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('User can control with the keyboard', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_keyboard" id="portfolio_keyboard" <?php checked(true, $tcr['options']['portfolio_keyboard']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('When active, the Right and Left arrow keys can be use to move through the images and the Esc key will close the gallery', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_caption_position"><?php esc_html_e('Caption position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Where to disply the image caption', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select id="portfolio_caption_position" name="portfolio_caption_position">
                                                <option value="random" <?php selected($tcr['options']['background_caption_position'], 'random'); ?>><?php esc_html_e('Random', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left top" <?php selected($tcr['options']['portfolio_caption_position'], 'left top'); ?>><?php esc_html_e('left top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left center" <?php selected($tcr['options']['portfolio_caption_position'], 'left center'); ?>><?php esc_html_e('left center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="left bottom" <?php selected($tcr['options']['portfolio_caption_position'], 'left bottom'); ?>><?php esc_html_e('left bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center top" <?php selected($tcr['options']['portfolio_caption_position'], 'center top'); ?>><?php esc_html_e('center top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center center" <?php selected($tcr['options']['portfolio_caption_position'], 'center center'); ?>><?php esc_html_e('center center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="center bottom" <?php selected($tcr['options']['portfolio_caption_position'], 'center bottom'); ?>><?php esc_html_e('center bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right top" <?php selected($tcr['options']['portfolio_caption_position'], 'right top'); ?>><?php esc_html_e('right top', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right center" <?php selected($tcr['options']['portfolio_caption_position'], 'right center'); ?>><?php esc_html_e('right center', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="right bottom" <?php selected($tcr['options']['portfolio_caption_position'], 'right bottom'); ?>><?php esc_html_e('right bottom', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('The default caption position', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_caption_speed"><?php esc_html_e('Caption fade speed', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Select a value using the slider or enter it manually in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="portfolio_caption_speed" id="portfolio_caption_speed" value="<?php echo esc_attr($tcr['options']['portfolio_caption_speed']); ?>" class="tcr-range-slider tcr-width-50" data-from="100" data-to="5000" data-step="100" data-dimension="<?php echo _x('ms', 'milliseconds', TCR_ADMIN_TEXT_DOMAIN); ?>" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The speed of the caption fade animation, in milliseconds (1000 = 1 second)', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_bullets"><?php esc_html_e('Bullet navigation', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('A navigation method to switch to any image on full screen mode', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="portfolio_bullets" id="portfolio_bullets" <?php checked(true, $tcr['options']['portfolio_bullets']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('When active, you can change images using bullet navigation', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-4-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="portfolio_low_quality"><?php esc_html_e('Low quality transitions', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('A performance enhancer, if required', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle-yn" name="portfolio_low_quality" id="portfolio_low_quality" <?php checked(true, $tcr['options']['portfolio_low_quality']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('When active, the transitions will be lower quality which improves performance', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->
                    </div><!-- .tcr-tab-4 -->

                    <div class="tcr-tab-5">
                    	<div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                                <li><span><?php esc_html_e('General', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-general"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Footer settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-5-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="footer_left_content"><?php esc_html_e('Footer left column content', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('For example; copyright information', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="footer_left_content" id="footer_left_content"><?php echo _wp_specialchars($tcr['options']['footer_left_content'], ENT_NOQUOTES, false, true); ?></textarea>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Enter the content for the footer left column', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-5-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="footer_top_link"><?php esc_html_e('"Top" link', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Show / hide a button to return to the top of the page', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="checkbox" class="tcr-toggle" name="footer_top_link" id="footer_top_link" <?php checked(true, $tcr['options']['footer_top_link']); ?> value="1" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Displays a link to scroll to the top of the page', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-5-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="footer_position"><?php esc_html_e('Footer position', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <select name="footer_position" id="footer_position">
                                                <option value="fixed" <?php selected($tcr['options']['footer_position'], 'fixed'); ?>><?php esc_html_e('Fixed', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                <option value="absolute" <?php selected($tcr['options']['footer_position'], 'absolute'); ?>><?php esc_html_e('Absolute', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                            </select>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Fixed footer will always at the bottom of the screen. Absolute will be shown at the bottom (after) of all the page content.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->
                    </div><!-- .tcr-tab-5 -->


                    <div class="tcr-tab-6">
                    	<div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                                <li><span><?php esc_html_e('General', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-general"></span></span></li>
                                <li><span><?php esc_html_e('Forms', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-quform"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Contact settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-6-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="contact_phone"><?php esc_html_e('Phone', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="contact_phone_number" id="contact_phone_number" value="<?php echo _wp_specialchars($tcr['options']['contact_phone_number'], ENT_COMPAT, false, true); ?>" class="tcr-width-300" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The business phone number', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-6-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="contact_fax"><?php esc_html_e('Fax', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="contact_fax_number" id="contact_fax_number" value="<?php echo _wp_specialchars($tcr['options']['contact_fax_number'], ENT_COMPAT, false, true); ?>" class="tcr-width-300" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The business fax number', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-6-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="contact_email"><?php esc_html_e('Email', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <input type="text" name="contact_email" id="contact_email" value="<?php echo _wp_specialchars($tcr['options']['contact_email'], ENT_COMPAT, false, true); ?>" class="tcr-width-300" />
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The business email address', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-6-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="contact_address"><?php esc_html_e('Address', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="contact_address" id="contact_address"><?php echo _wp_specialchars($tcr['options']['contact_address'], ENT_NOQUOTES, false, true); ?></textarea>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The business address - HTML is allowed, new lines will be converted automatically to <br />', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-6-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="contact_map"><?php esc_html_e('Map HTML', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Add an map image or link. Make sure the size is correct', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="contact_map" id="contact_map"><?php echo _wp_specialchars($tcr['options']['contact_map'], ENT_NOQUOTES, false, true); ?></textarea>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('The HTML for the map, e.g. Google maps embed code. The map frame should be 395px wide on a page without a sidebar or 218px on a page with a sidebar.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                <table class="tcr-form-table tcr-tab-6-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="contact_quform_id"><?php esc_html_e('Contact page template form', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <?php if (function_exists('iphorm')) : ?>
                                                <?php $forms = iphorm_get_all_forms(); ?>
                                                <?php if (count($forms)) : ?>
                                                    <select id="contact_quform_id" name="contact_quform_id">
                                                    <?php foreach ($forms as $form) : ?>
                                                        <option value="<?php echo $form['id']; ?>" <?php selected($tcr['options']['contact_quform_id'], $form['id']); ?>><?php echo esc_html($form['name']); ?><?php if ($form['active'] == 0) echo ' (' . esc_html__('inactive', TCR_ADMIN_TEXT_DOMAIN) . ')'; ?></option>
                                                    <?php endforeach; ?>
                                                    <option value="" <?php selected($tcr['options']['contact_quform_id'], ''); ?>><?php esc_html_e('None', TCR_ADMIN_TEXT_DOMAIN); ?></option>
                                                    </select>
                                                <?php else : ?>
                                                    <p class="tcr-warning"><?php esc_html_e('No forms found, you must create or import one first.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                                <?php endif; ?>
                                            <?php else : ?>
                                                <p class="tcr-warning"><?php esc_html_e('You must install and activate the Quform plugin first.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                            <?php endif; ?>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                            <p class="tcr-description"><?php esc_html_e('Choose the Quform form to use on the contact page template.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Form settings', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <?php if (function_exists('iphorm')) : ?>
                                    <div class="tcr-manage-forms"><?php esc_html_e('The theme forms are controlled by the Quform plugin, you can add or edit forms using the buttons below.', TCR_ADMIN_TEXT_DOMAIN); ?></div>
                                    <div class="tcr-manage-forms-buttons tcr-clearfix">
                                        <a href="admin.php?page=iphorm_forms" class="tcr-button tcr-blue tcr-external-link"><?php esc_html_e('View forms', TCR_ADMIN_TEXT_DOMAIN); ?></a>
                                        <a href="admin.php?page=iphorm_form_builder" class="tcr-button tcr-blue tcr-external-link"><?php esc_html_e('Create a new form', TCR_ADMIN_TEXT_DOMAIN); ?></a>
                                    </div>
                                <?php else : ?>
                                    <p class="tcr-warning"><?php esc_html_e('The theme forms are controlled by Quform, please install and activate this plugin.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                <?php endif; ?>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->
                    </div><!-- .tcr-tab-6 -->

                    <div class="tcr-tab-7">
                    	<div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                        	    <li><span><?php esc_html_e('Custom CSS', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-edit"></span></span></li>
                        	    <li><span><?php esc_html_e('Custom JS', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-edit"></span></span></li>
                                <li><span><?php esc_html_e('Import', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-import"></span></span></li>
                                <li><span><?php esc_html_e('Export', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-export"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                            	<h2 class="tcr-panel-section-header"><?php esc_html_e('Custom CSS', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-7-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="advanced_custom_css"><?php esc_html_e('CSS', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="advanced_custom_css" id="advanced_custom_css"><?php echo _wp_specialchars($tcr['options']['advanced_custom_css'], ENT_NOQUOTES, false, true); ?></textarea>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('Enter any custom CSS to apply to your website', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->

                            <div class="tcr-sub-tab">
                            	<h2 class="tcr-panel-section-header"><?php esc_html_e('Custom JavaScript', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-7-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="advanced_custom_js"><?php esc_html_e('JavaScript', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="advanced_custom_js" id="advanced_custom_js"><?php echo _wp_specialchars($tcr['options']['advanced_custom_js'], ENT_NOQUOTES, false, true); ?></textarea>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php printf(esc_html__('Enter any custom JavaScript to apply to your website. %1$s$%2$s is the jQuery object, code will executed inside a %3$s function.', TCR_ADMIN_TEXT_DOMAIN), '<code>', '</code>', '<code>$(document).ready()</code>'); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->

                            <div class="tcr-sub-tab">
                                <h2 class="tcr-panel-section-header"><?php esc_html_e('Import', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-7-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="advanced_import"><?php esc_html_e('Import options', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Paste exported options in the field', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <textarea name="advanced_import" id="advanced_import"></textarea>
                                            <div id="tcr-import-status"></div>
                                            <div class="tcr-clearfix"><a id="tcr-start-import" class="tcr-button tcr-blue"><?php esc_html_e('Import', TCR_ADMIN_TEXT_DOMAIN); ?></a></div>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('To Import your theme options, paste exported data into the box and click Import', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->

                            <div class="tcr-sub-tab">
                            	<h2 class="tcr-panel-section-header"><?php esc_html_e('Export', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-7-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label for="advanced_export"><?php esc_html_e('Export options', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Useful for backing up your settings or if you are moving site', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td">
                                            <div class="tcr-clearfix"><a id="tcr-start-export" class="tcr-button tcr-blue"><?php esc_html_e('Export', TCR_ADMIN_TEXT_DOMAIN); ?></a></div>
                                            <div id="tcr-export-textarea-wrap" class="tcr-hidden">
                                                <textarea name="advanced_export" id="advanced_export"></textarea>
                                            </div>
                                        </td>
                                        <td class="tcr-form-table-desc-td">
                                        	<p class="tcr-description"><?php esc_html_e('You can backup or transfer your theme options by exporting, click Export to get started. Highlight the text in the box and do a copy/paste into a blank .txt file to save your options.', TCR_ADMIN_TEXT_DOMAIN); ?></p>
                                        </td>
                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->
                    </div><!-- .tcr-tab-7 -->

                    <div class="tcr-tab-8">
                    	<div class="tcr-sub-tabs-wrap">
                        	<ul class="tcr-sub-tabs-nav">
                                <li><span><?php esc_html_e('Translations', TCR_ADMIN_TEXT_DOMAIN); ?><span class="tcr-icon tcr-translate"></span></span></li>
                            </ul>
                        </div>

                        <div class="tcr-sub-tabs">
                            <div class="tcr-sub-tab">
                            	<h2 class="tcr-panel-section-header"><?php esc_html_e('Translations', TCR_ADMIN_TEXT_DOMAIN); ?></h2>
                                <table class="tcr-form-table tcr-tab-8-form-table">
                                    <tr class="tcr-settings-sub-head">
                                        <th colspan="2">
                                            <label><?php esc_html_e('Add translations', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                            <span class="tcr-tip-icon" title="<?php esc_attr_e('Use the fields (left) to translate the text (right)', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                        </th>
                                    </tr>
                                    <tr class="tcr-content-row">
                                        <td class="tcr-form-table-input-area-td tcr-translation-table-area-td">
                                            <table class="tcr-translations-table">
                                                <tr>
                                                	<th class="tcr-translations-translation-th">
                                                        <label><?php esc_html_e('Translation', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                                        <span class="tcr-tip-icon" title="<?php esc_attr_e('Add new translation', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                                    </th>
                                                    <th class="tcr-translations-default-th">
                                                        <label><?php esc_html_e('Default', TCR_ADMIN_TEXT_DOMAIN); ?></label>
                                                        <span class="tcr-tip-icon" title="<?php esc_attr_e('Current text', TCR_ADMIN_TEXT_DOMAIN); ?>"></span>
                                                    </th>
                                                </tr>
                                                <?php
                                                    $translations = tcr_get_default_translations();
                                                    foreach ($translations as $key => $translation) : ?>
                                                    <tr>
                                                    	<td class="tcr-translations-translation-td">
                                                            <input type="text" class="tcr-width-300" name="<?php echo $key; ?>" value="<?php echo _wp_specialchars($tcr['options'][$key], ENT_COMPAT, false, true); ?>" />
                                                        </td>
                                                        <td class="tcr-translations-default-td">
                                                            <?php echo _wp_specialchars($translation, ENT_COMPAT, false, true); ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                                <tr >
                                                    <td class="tcr-translations-reset-td" colspan="2"><a id="tcr-reset-translations" class="tcr-button tcr-light"><span><?php esc_html_e('Reset all translations', TCR_ADMIN_TEXT_DOMAIN); ?></span></a></td>
                                                </tr>
                                            </table>
                                        </td>

                                    </tr>
                                </table>
                            </div><!-- .tcr-sub-tab -->
                        </div><!-- .tcr-sub-tabs -->
                    </div><!-- .tcr-tab-8 -->

                </div><!-- #tcr-tabs -->

                <div class="tcr-buttons tcr-clearfix">
                    <a class="tcr-save tcr-button tcr-blue tcr-save-save"><span><?php esc_html_e('Save', TCR_ADMIN_TEXT_DOMAIN); ?></span></a>
                    <a id="tcr-reset-options" class="tcr-reset tcr-button tcr-light"><span><?php esc_html_e('Reset', TCR_ADMIN_TEXT_DOMAIN); ?></span></a>
                </div>
            </div><!-- .tcr-panel-right -->
            <div id="tcr-options-saved"><span><span class="tcr-save-icon"></span><?php esc_html_e('Options saved', TCR_ADMIN_TEXT_DOMAIN); ?></span></div>
        </div><!-- .tcr-wrap -->
    </form>
    <script type="text/javascript">
    //<![CDATA[
        jQuery(document).ready(function ($) {
            ThemeCatcher.init(<?php echo json_encode($tcr['options']); ?>);
        });
    //]]>
    </script>
</div>