<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * PORTFOLIO METABOX
 */
$config = array(
    'id' => 'tcr_portfolio',
    'title' => __('Portfolio Item Options', TCR_ADMIN_TEXT_DOMAIN),
    'types' => array('portfolio'),
    'callback' => '',
    'context' => 'normal',
    'priority' => 'high'
);

$options = array(
    array(
        'name' => 'type',
        'title' => __('Type', TCR_ADMIN_TEXT_DOMAIN),
        'tooltip' => __('A Portfolio type will link to the portfolio page. A Link type will link to a specified URL.', TCR_ADMIN_TEXT_DOMAIN),
		'description' => __('Choose a Type based on the content that you are displaying on this post.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => 'image',
        'options' => array(
            'image' => __('Image', TCR_ADMIN_TEXT_DOMAIN),
            'video' => __('Video', TCR_ADMIN_TEXT_DOMAIN),
            'portfolio' => __('Portfolio', TCR_ADMIN_TEXT_DOMAIN),
            'link' => __('Link', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'name' => 'image',
        'title' => __('Lightbox image (optional)', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Choose an image to display in the lightbox. If not set, the featured image will be used.', TCR_ADMIN_TEXT_DOMAIN),
        'tooltip' => __('You can choose another image to show in the lightbox, instead of the post featured image.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'upload',
        'default' => array()
    ),
    array(
        'name' => 'title',
        'title' => __('Image title', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('The title is shown when hovering the bullet navigation in Serene (Full Screen) gallery', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text'
    ),
    array(
        'name' => 'caption_position',
        'title' => __('Caption position', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'random' => __('Random', TCR_ADMIN_TEXT_DOMAIN),
            'left top' => __('left top', TCR_ADMIN_TEXT_DOMAIN),
            'left center' => __('left center', TCR_ADMIN_TEXT_DOMAIN),
            'left bottom' => __('left bottom', TCR_ADMIN_TEXT_DOMAIN),
            'center top' => __('center top', TCR_ADMIN_TEXT_DOMAIN),
            'center center' => __('center center', TCR_ADMIN_TEXT_DOMAIN),
            'center bottom' => __('center bottom', TCR_ADMIN_TEXT_DOMAIN),
            'right top' => __('right top', TCR_ADMIN_TEXT_DOMAIN),
            'right center' => __('right center', TCR_ADMIN_TEXT_DOMAIN),
            'right bottom' => __('right bottom', TCR_ADMIN_TEXT_DOMAIN)
        ),
        'description' => __('Only applies to Serene (Full Screen) gallery', TCR_ADMIN_TEXT_DOMAIN),
        'tooltip' => __('The Default option will inherit from the theme options panel', TCR_ADMIN_TEXT_DOMAIN)
    ),
    array(
        'name' => 'caption',
        'title' => __('Caption HTML', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'textarea',
        'description' => __('Enter the caption HTML, here is an example:', TCR_ADMIN_TEXT_DOMAIN) . '<pre class="tcr-meta-box-field-example">&lt;h1&gt;Sample Title&lt;/h1&gt;
&lt;p&gt;Sample description.&lt;/p&gt;</pre>'),
    array(
        'name' => 'video',
        'title' => __('Video URL', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Enter the URL for the video', TCR_ADMIN_TEXT_DOMAIN),
        'tooltip' => __('Enter the full URL including http://', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'class' => 'tcr-width-400'
    ),
    array(
        'name' => 'video_width',
        'title' => __('Video width', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('This will override the global width set in the Portfolio &rarr; General tab of the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'pixel'
    ),
    array(
        'name' => 'video_height',
        'title' => __('Video height', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('This will override the global height set in the Portfolio &rarr; General tab of the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'pixel'
    ),
    array(
        'name' => 'link',
        'title' => __('Link URL', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Enter the URL to link to. Include http://', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text'
    ),
    array(
        'name' => 'link_target',
        'title' => __('Link target', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Specify how the link will be opened in the browser', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'options' => array(
            '' => __('Open the link in the current window', TCR_ADMIN_TEXT_DOMAIN),
            '_blank' => __('Open the link in a new window or tab', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'name' => 'show_title',
        'title' => __('Show title', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The default is set in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => '',
        'toggle' => 'yn'
    ),
    array(
        'name' => 'show_description',
        'title' => __('Show description', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The default is set in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => '',
        'toggle' => 'yn'
    ),
    array(
        'name' => 'show_read_more',
        'title' => __('Show "Read More" button', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The default is set in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => '',
        'toggle' => 'yn'
    ),
    array(
        'name' => 'read_more',
        'title' => __('"Read More" button text', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'description' => __('Leave blank to use the default', TCR_ADMIN_TEXT_DOMAIN),
        'default' => ''
    )
);

new MetaboxGenerator($config, $options);

/**
 * PAGE GENERAL METABOX
 */
$config = array(
    'id' => 'tcr_general',
    'title' => sprintf(__('%s Options', TCR_ADMIN_TEXT_DOMAIN), TCR_NAME),
    'types' => array('page'),
    'callback' => '',
    'context' => 'normal',
    'priority' => 'high'
);

$options = array(
    array(
        'name' => 'layout',
        'title' => __('Layout', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Select a layout for this page', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Choose the page layout, the Default option will use your setting from the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'left-sidebar' => __('Left sidebar', TCR_ADMIN_TEXT_DOMAIN),
            'full-width' => __('Full width', TCR_ADMIN_TEXT_DOMAIN),
            'right-sidebar' => __('Right sidebar', TCR_ADMIN_TEXT_DOMAIN)
        ),
        'class' => 'tcr-layout-selector'
    ),
	array(
        'name' => 'content_style',
        'title' => __('Content style', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The style of background which the content is on', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'plain-black' => __('Plain black', TCR_ADMIN_TEXT_DOMAIN),
            'full-width-transparent' => __('Transparent', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'name' => 'skip_url',
        'title' => __('Skip intro URL', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('The URL of the "Skip intro" button for the "Intro Page" template', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'class' => 'tcr-width-400'
    ),
	array(
        'title' =>  __('Intro settings', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'subtitle',
	    'class' => 'tcr-intro-settings'
    ),
    array(
        'name' => 'intro_style',
        'title' => __('Intro style', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Page intro is the heading at the top of the content area', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'disabled' => __('Disabled', TCR_ADMIN_TEXT_DOMAIN),
            'transparent-intro' => __('Transparent', TCR_ADMIN_TEXT_DOMAIN),
            'black-transparent-intro' => __('Transparent with black top', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'name' => 'intro_title',
        'title' => __('Intro title', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-400'
    ),
    array(
        'name' => 'intro_subtitle',
        'title' => __('Intro subtitle', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-400'
    ),

    array(
        'title' =>  __('Background settings', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'subtitle'
    ),
    array(
        'name' => 'backgrounds',
        'title' => __('Background images', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Select image files from your computer', TCR_ADMIN_TEXT_DOMAIN),
		'description' => __('Upload your background image(s) that are specific to this page.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'upload',
        'render' => 'bgupload',
        'default' => array()
    ),
    array(
        'name' => 'background_group',
        'title' => __('Background image group', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('You can create groups in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
		'description' => __('Choose a group of images to use that are specific to this page. If any images are uploaded above, they will be used instead of the chosen group.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => tcr_get_background_group_options()
    ),
    array(
        'name' => 'always_show_captions',
        'title' => __('Show captions', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Always show the background image captions', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Only applies to the "Left Note Block" or "Intro Page" page templates. Remember to add captions to images, by hovering the uploaded image thumbnail and clicking the cog icon.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'toggle',
        'default' => '1',
        'toggle' => 'yn'
    ),
    array(
        'name' => 'overlay',
        'title' => __('Background overlay', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Pick an overlay style', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('The first texture option will use the setting from the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => tcr_get_background_overlay_options(true),
        'class' => 'tcr-texture-selector'
    ),
    array(
        'name' => 'background_video',
        'title' => __('Background video URL', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Enter the full URL including http://', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Enter the URL of a YouTube or Vimeo video. The background video will show instead of the background images, except on tablets and mobile devices.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'class' => 'tcr-width-400'
    ),
    array(
        'name' => 'background_video_width',
        'title' => __('Background video width', TCR_ADMIN_TEXT_DOMAIN),
        'description' => sprintf(__('Please enter the width of the original video for accurate scaling. This information will be fetched from Vimeo automatically, for YouTube please %sfind the dimensions manually%s.', TCR_ADMIN_TEXT_DOMAIN), '<a href="' . TCR_ADMIN_URL . '/images/video_dimensions_from_youtube.jpg" class="tcr-external-link">', '</a>'),
        'type' => 'pixel',
        'class' => 'tcr-width-50'
    ),
    array(
        'name' => 'background_video_height',
        'title' => __('Background video height', TCR_ADMIN_TEXT_DOMAIN),
        'description' => sprintf(__('Please enter the height of the original video for accurate scaling. This information will be fetched from Vimeo automatically, for YouTube please %sfind the dimensions manually%s.', TCR_ADMIN_TEXT_DOMAIN), '<a href="' . TCR_ADMIN_URL . '/images/video_dimensions_from_youtube.jpg" class="tcr-external-link">', '</a>'),
        'type' => 'pixel',
        'class' => 'tcr-width-50'
    ),
    array(
        'name' => 'background_video_autostart',
        'title' => __('Auto-start video', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Start the video automatically', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => ''
    ),
    array(
        'name' => 'background_video_complete',
        'title' => __('When video finishes', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Choose an action to take when the video has finished playing', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'none' => __('Do nothing', TCR_ADMIN_TEXT_DOMAIN),
            'restart' => __('Restart video', TCR_ADMIN_TEXT_DOMAIN),
            'hide' => __('Hide video', TCR_ADMIN_TEXT_DOMAIN),
            'redirect' => __('Redirect to another page', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'name' => 'background_video_redirect',
        'title' => __('Redirect URL', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Enter the URL to redirect to when the video has finished playing', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-400'
    ),
    array(
        'name' => 'background_video_start',
        'title' => __('Video start position', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Skip playback to the specified number of seconds into the video, if empty it will use the setting from the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'tooltip' => __('The video will start at this number of seconds after the start', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-50'
    ),
	array(
        'title' =>  __('Audio settings', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'subtitle'
    ),
    array(
        'name' => 'audio',
        'title' => __('Music tracks', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Upload audio files from your computer', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Either a .mp3 or .m4a file is required, uploading a .ogg version will increase browser support. You need to use the same chosen formats for every track you add. For example if you choose .m4a and .ogg for your first track, every other track should have both a .m4a and .ogg version.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'upload',
        'render' => 'audioupload',
        'default' => array()
    ),
    array(
        'name' => 'audio_random',
        'title' => __('Randomize tracks', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The default is set in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Randomize the order of the tracks', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => ''
    ),
    array(
        'name' => 'audio_autostart',
        'title' => __('Auto-start music', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The default is set in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Start the music automatically', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => ''
    ),
    array(
        'name' => 'audio_complete',
        'title' => __('When music finishes', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Choose an action to take when the music has finished playing', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'none' => __('Do nothing', TCR_ADMIN_TEXT_DOMAIN),
            'restart' => __('Restart music', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
);

new MetaboxGenerator($config, $options);

/**
 * POST/PORTFOLIO GENERAL METABOX
 */
$config = array(
    'id' => 'tcr_general',
    'title' => sprintf(__('%s Options', TCR_ADMIN_TEXT_DOMAIN), TCR_NAME),
    'types' => array('post', 'portfolio'),
    'callback' => '',
    'context' => 'normal',
    'priority' => 'high'
);

$options = array(
    array(
        'name' => 'layout',
        'title' => __('Layout', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Select a layout for this page', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Choose the page layout, the Default option will use your setting from the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'left-sidebar' => __('Left sidebar', TCR_ADMIN_TEXT_DOMAIN),
            'full-width' => __('Full width', TCR_ADMIN_TEXT_DOMAIN),
            'right-sidebar' => __('Right sidebar', TCR_ADMIN_TEXT_DOMAIN)
        ),
        'class' => 'tcr-layout-selector'
    ),
	array(
        'name' => 'content_style',
        'title' => __('Content style', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The style of background which the content is on', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'plain-black' => __('Plain black', TCR_ADMIN_TEXT_DOMAIN),
            'full-width-transparent' => __('Transparent', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
	array(
        'title' =>  __('Intro settings', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'subtitle',
	    'class' => 'tcr-intro-settings'
    ),
    array(
        'name' => 'intro_style',
        'title' => __('Intro style', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Page intro is the heading at the top of the content area', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'disabled' => __('Disabled', TCR_ADMIN_TEXT_DOMAIN),
            'transparent-intro' => __('Transparent', TCR_ADMIN_TEXT_DOMAIN),
            'black-transparent-intro' => __('Transparent with black top', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'name' => 'intro_title',
        'title' => __('Intro title', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-400'
    ),
    array(
        'name' => 'intro_subtitle',
        'title' => __('Intro subtitle', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-400'
    ),
	array(
        'title' =>  __('Featured image settings', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'subtitle'
    ),
    array(
        'name' => 'featured_image',
        'title' => __('Featured image', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Show / hide featured image', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Display the featured image at the top of the post', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => ''
    ),
    array(
        'name' => 'featured_image_type',
        'title' => __('Featured image type', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Choose a layout type for the featured image', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'full' => __('Full width', TCR_ADMIN_TEXT_DOMAIN),
            'left' => __('Float left', TCR_ADMIN_TEXT_DOMAIN),
            'right' => __('Float right', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'title' =>  __('Background settings', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'subtitle'
    ),
    array(
        'name' => 'backgrounds',
        'title' => __('Background images', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Select image files from your computer', TCR_ADMIN_TEXT_DOMAIN),
		'description' => __('Upload your background image(s) that are specific to this page.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'upload',
        'render' => 'bgupload',
        'default' => array()
    ),
    array(
        'name' => 'background_group',
        'title' => __('Background image group', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('You can create groups in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
		'description' => __('Choose a group of images to use that are specific to this page. If any images are uploaded above, they will be used instead of the chosen group.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => tcr_get_background_group_options()
    ),
    array(
        'name' => 'overlay',
        'title' => __('Background overlay', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Pick an overlay style', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('The first texture option will use the setting from the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => tcr_get_background_overlay_options(true),
        'class' => 'tcr-texture-selector'
    ),
    array(
        'name' => 'background_video',
        'title' => __('Background video URL', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Enter the full URL including http://', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Enter the URL of a YouTube or Vimeo video. The background video will show instead of the background images, except on tablets and mobile devices.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'class' => 'tcr-width-400'
    ),
    array(
        'name' => 'background_video_width',
        'title' => __('Background video width', TCR_ADMIN_TEXT_DOMAIN),
        'description' => sprintf(__('Please enter the width of the original video for accurate scaling. This information will be fetched from Vimeo automatically, for YouTube please %sfind the dimensions manually%s.', TCR_ADMIN_TEXT_DOMAIN), '<a href="' . TCR_ADMIN_URL . '/images/video_dimensions_from_youtube.jpg" class="tcr-external-link">', '</a>'),
        'type' => 'pixel',
        'class' => 'tcr-width-50'
    ),
    array(
        'name' => 'background_video_height',
        'title' => __('Background video height', TCR_ADMIN_TEXT_DOMAIN),
        'description' => sprintf(__('Please enter the height of the original video for accurate scaling. This information will be fetched from Vimeo automatically, for YouTube please %sfind the dimensions manually%s.', TCR_ADMIN_TEXT_DOMAIN), '<a href="' . TCR_ADMIN_URL . '/images/video_dimensions_from_youtube.jpg" class="tcr-external-link">', '</a>'),
        'type' => 'pixel',
        'class' => 'tcr-width-50'
    ),
    array(
        'name' => 'background_video_autostart',
        'title' => __('Auto-start video', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Start the video automatically', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => ''
    ),
    array(
        'name' => 'background_video_complete',
        'title' => __('When video finishes', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Choose an action to take when the video has finished playing', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'none' => __('Do nothing', TCR_ADMIN_TEXT_DOMAIN),
            'restart' => __('Restart video', TCR_ADMIN_TEXT_DOMAIN),
            'hide' => __('Hide video', TCR_ADMIN_TEXT_DOMAIN),
            'redirect' => __('Redirect to another page', TCR_ADMIN_TEXT_DOMAIN)
        )
    ),
    array(
        'name' => 'background_video_redirect',
        'title' => __('Redirect URL', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Enter the URL to redirect to when the video has finished playing', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-400'
    ),
    array(
        'name' => 'background_video_start',
        'title' => __('Video start position', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Skip playback to the specified number of seconds into the video, if empty it will use the setting from the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'tooltip' => __('The video will start at this number of seconds after the start', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'text',
        'default' => '',
        'class' => 'tcr-width-50'
    ),
	array(
        'title' =>  __('Audio settings', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'subtitle'
    ),
    array(
        'name' => 'audio',
        'title' => __('Music tracks', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('Upload audio files from your computer', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Either a .mp3 or .m4a file is required, uploading a .ogg version will increase browser support. You need to use the same chosen formats for every track you add. For example if you choose .m4a and .ogg for your first track, every other track should have both a .m4a and .ogg version.', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'upload',
        'render' => 'audioupload',
        'default' => array()
    ),
    array(
        'name' => 'audio_random',
        'title' => __('Randomize tracks', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The default is set in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Randomize the order of the tracks', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => ''
    ),
    array(
        'name' => 'audio_autostart',
        'title' => __('Auto-start music', TCR_ADMIN_TEXT_DOMAIN),
		'tooltip' => __('The default is set in the theme options panel', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Start the music automatically', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'tritoggle',
        'default' => ''
    ),
    array(
        'name' => 'audio_complete',
        'title' => __('When music finishes', TCR_ADMIN_TEXT_DOMAIN),
        'description' => __('Choose an action to take when the music has finished playing', TCR_ADMIN_TEXT_DOMAIN),
        'type' => 'select',
        'default' => '',
        'options' => array(
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            'none' => __('Do nothing', TCR_ADMIN_TEXT_DOMAIN),
            'restart' => __('Restart music', TCR_ADMIN_TEXT_DOMAIN)
        )
    )
);

new MetaboxGenerator($config, $options);
