<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Generates the HTML for the shortcode dialog
 */
class ShortcodeOptionsGenerator extends OptionsGenerator
{
    protected $config;
    protected $options;

    public function __construct($config, $options)
    {
        $this->config = $config;
        $this->options = $options;
    }

    public function render()
    {
        if (isset($this->config['title'])) {
            echo '<h3>' . $this->config['title'] . '</h3>';
        }

        foreach ($this->options as $option) {
            if (method_exists($this, $option['type'])) {
                $option['default'] = array_key_exists('default', $option) ? $option['default'] : '';
                $option['value'] = $option['default'];
                $tooltip = isset($option['tooltip']) ? '<span class="tcr-tooltip-wrap"><span class="tcr-tooltip-content">' . $option['tooltip'] . '</span></span>' : '';
                $optional = (isset($option['optional']) && $option['optional']) ? ' <span class="tcr-sc-optional">' . esc_html__('(optional)', TCR_ADMIN_TEXT_DOMAIN) . '</span>' : '';

                $data = array(
                    'name' => $option['name'],
                    'type' => $option['type'],
                    'default' => $option['default'],
                    'selector' => 'tcr-sc-' . $this->config['shortcode'] . '-' . $option['name']
                );

                $wrapClasses = array();
                if (isset($option['wrap_class'])) {
                    $wrapClasses = explode(' ', $option['wrap_class']);
                }

                $option['name'] = $data['selector'];

                echo '<div class="tcr-shortcode-field-outer tcr-clearfix ' . join(' ', $wrapClasses) . '" data-config="' . esc_attr(json_encode($data)) . '">';
                echo '<div class="tcr-shortcode-field-label"><h4>' . $option['label'] . $optional . '</h4>' . $tooltip . '</div>';
                echo '<div class="tcr-shortcode-field-inner tcr-clearfix">';
                echo $this->{$option['type']}($option);
                if (isset($option['description']) && $option['description']) {
                    echo '<p class="tcr-shortcode-field-description">' . $option['description'] . '</p>';
                }
                if (isset($option['after_description']) && $option['after_description']) {
                    echo $option['after_description'];
                }
                echo '</div>';
                echo '</div>';
            }
        }
    }
}