<?php

// Prevent direct script access
if (!defined('ABSPATH')) exit;

/**
 * Generates the HTML for options
 */
class OptionsGenerator
{
    public function select($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => '',
            'class' => '',
            'options' => array(),
            'attributes' => array()
        )));

        $name = esc_attr($name);

        $classes = array('tcr-option-select');
        if (strlen($class)) {
            $classes[] = $class;
        }

        $atts = is_array($attributes) ? join(' ', $attributes) : '';

        echo '<select id="' . $name . '" name="' . $name . '" class="' . join(' ', $classes) . '" ' . $atts . '>';
        if (is_array($options)) {
            foreach ($options as $key => $label) {
                echo '<option value="' . _wp_specialchars($key, ENT_COMPAT, false, true) . '" ' . selected($value, $key, false) . '>' . _wp_specialchars($label, ENT_NOQUOTES, true, false) . '</option>';
            }
        }
        echo '</select>';
    }

    public function multiselect($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => array(),
            'class' => '',
            'options' => array(),
            'attributes' => array()
        )));

        $name = esc_attr($name);

        $classes = array('tcr-option-select');
        if (strlen($class)) {
            $classes[] = $class;
        }

        $atts = is_array($attributes) ? join(' ', $attributes) : '';

        echo '<select id="' . $name . '" name="' . $name . '" class="' . join(' ', $classes) . '" multiple="multiple" ' . $atts . '>';
        if (is_array($options)) {
            foreach ($options as $key => $label) {
                echo '<option value="' . _wp_specialchars($key, ENT_COMPAT, false, true) . '" ' . selected($value, $key, false) . '>' . _wp_specialchars($label, ENT_NOQUOTES, true, false) . '</option>';
            }
        }
        echo '</select>';
    }

    public function text($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => '',
            'class' => '',
            'attributes' => ''
        )));

        $name = esc_attr($name);

        $classes = array('tcr-option-text');
        if (strlen($class)) {
            $classes[] = $class;
        }

        echo '<input type="text" name="' . $name . '" id="' . $name . '" value="' . _wp_specialchars($value, ENT_COMPAT, false, true) . '"  class="' . join(' ', $classes) . '" ' . $attributes . ' />';
    }

    public function pixel($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => '',
            'class' => '',
            'attributes' => ''
        )));

        $name = esc_attr($name);

        $classes = array('tcr-option-text tcr-width-50');
        if (strlen($class)) {
            $classes[] = $class;
        }

        echo '<input type="text" name="' . $name . '" id="' . $name . '" value="' . _wp_specialchars($value, ENT_COMPAT, false, true) . '"  class="' . join(' ', $classes) . '" ' . $attributes . ' /> ' . _x('px', 'pixels', TCR_ADMIN_TEXT_DOMAIN);
    }

    public function textarea($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => '',
            'class' => '',
            'rows' => '8',
            'cols' => '50'
        )));

        $name = esc_attr($name);

        $classes = array('tcr-option-textarea');
        if (strlen($class)) {
            $classes[] = $class;
        }

        echo '<textarea name="' . $name . '" id="' . $name . '" class="' . join(' ', $classes) . '" rows="' . $rows . '" cols="' . $cols . '">' . _wp_specialchars($value, ENT_NOQUOTES, false, true) . '</textarea>';
    }

    public function upload($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => array(),
            'class' => ''
        )));

        $name = esc_attr($name);

        echo '<div class="tcr-upload-bg-button-wrap tcr-clearfix">';
        echo '<div id="'.$name.'_upload_button" class="tcr-swfupload-button">' . __('Upload', TCR_ADMIN_TEXT_DOMAIN) . '<div id="'.$name.'_upload_browse"></div></div>';
        echo '<div class="tcr-loading"></div>';
        echo '</div>';
        echo '<div id="'.$name.'_uploaded" class="tcr-clearfix tcr-upload-holder">';

        if (is_array($value)) {
            foreach ($value as $upload) {
                echo '<div class="tcr-uploaded-image" data-tcr-url="' . esc_url($upload['url']) . '" data-tcr-file="' . esc_url($upload['file']) . '"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div title="' . esc_attr__('Delete image', TCR_ADMIN_TEXT_DOMAIN) . '" class="tcr-delete-uploaded-image"></div></div></div><img src="' . esc_url(TCR_URL . '/includes/timthumb.php?src=' . site_url() . $upload['url'] . '&w=148&h=83&q=100') . '" alt="" /></div>';
            }
        }

        echo '</div>';
        echo '<div class="tcr-hidden"><textarea name="' . $name . '" id="' . $name . '">' . esc_html(json_encode($value)) . '</textarea></div>';
    }

    public function bgupload($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => array(),
            'class' => ''
        )));

        $name = esc_attr($name);

        echo '<div class="tcr-upload-bg-button-wrap tcr-clearfix">';
        echo '<div id="'.$name.'_upload_button" class="tcr-swfupload-button">' . __('Upload', TCR_ADMIN_TEXT_DOMAIN) . '<div id="'.$name.'_upload_browse"></div></div>';
        echo '<div class="tcr-loading"></div>';
        echo '</div>';
        echo '<div id="'.$name.'_uploaded" class="tcr-clearfix tcr-upload-holder">';

        if (is_array($value)) {
            foreach ($value as $upload) {
                echo '<div class="tcr-uploaded-image tcr-bg-image" data-tcr-url="' . esc_url($upload['url']) . '" data-tcr-file="' . esc_url($upload['file']) . '" data-tcr-title="' . esc_attr($upload['title']) . '" data-tcr-caption="' . esc_attr($upload['caption']) . '" data-tcr-caption-position="' . esc_attr($upload['captionPosition']) . '"><div class="tcr-uploaded-image-hover"><div class="tcr-uploaded-image-hover-inner"><div title="' . esc_attr__('Delete image', TCR_ADMIN_TEXT_DOMAIN) . '" class="tcr-delete-uploaded-image"></div><div title="' . esc_attr__('Edit caption', TCR_ADMIN_TEXT_DOMAIN) . '" class="tcr-edit-background-image"></div></div></div><img src="' . esc_url(TCR_URL . '/includes/timthumb.php?src=' . site_url() . $upload['url'] . '&w=148&h=83&q=100') . '" alt="" /></div>';
            }
        }

        echo '</div>';
        echo '<div class="tcr-hidden"><textarea name="' . $name . '" id="' . $name . '">' . esc_html(json_encode($value)) . '</textarea></div>';
        echo tcr_background_settings_form();
    }

    public function audioupload($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => array(),
            'class' => ''
        )));

        $name = esc_attr($name);
        // If making any changes to the HTML below, also change metaboxes.js ?>

        <div class="tcr-add-audio-track-button-wrap tcr-clearfix">
            <div id="tcr-add-audio-track-button" class="tcr-button tcr-orange tcr-add"><span></span><?php esc_html_e('Add a music track', TCR_ADMIN_TEXT_DOMAIN); ?></div>
        </div>
        <div id="tcr-audio-tracks" class="tcr-clearfix">
            <?php foreach ($value as $trackId => $track) : ?>
                <div id="tcr-audio-track-<?php echo $trackId; ?>" class="tcr-audio-track tcr-clearfix">
                	<div class="tcr-audio-track-inner">
                        <div class="tcr-delete-audio-track" title="<?php esc_attr_e('Delete track', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                        <div class="tcr-edit-audio-track" title="<?php esc_attr_e('Edit track', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                        <div class="tcr-drag-audio-track" title="<?php esc_attr_e('Move track', TCR_ADMIN_TEXT_DOMAIN); ?>"></div>
                        <div class="tcr-audio-track-name">
                            <span class="tcr-audio-track-name-inner"><?php echo esc_html($track['name']); ?></span>
                            <input type="text" class="tcr-audio-track-name-input tcr-width-300" value="<?php echo _wp_specialchars($track['name'], ENT_COMPAT, false, true); ?>" />
                        </div>
                        <div class="tcr-audio-track-settings">
                            <table class="tcr-audio-track-settings">
                            	<tr class="tcr-audio-format-title">
                            		<th colspan="2"><?php esc_html_e('M4A file URL', TCR_ADMIN_TEXT_DOMAIN); ?></th>
                                </tr>
                                <tr class="tcr-audio-format">
                            		<td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-m4a" value="<?php echo _wp_specialchars($track['m4a'], ENT_COMPAT, false, true); ?>" /></td>
                            		<td class="tcr-audio-format-upload-td">
                                		<div class="tcr-upload-audio-track-button-wrap tcr-clearfix">
                                            <div class="tcr-upload-audio-format-button tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_audio_format_m4a_<?php echo $trackId; ?>"></div></div>
                                            <div class="tcr-loading"></div>
                                        </div>
                            		</td>
                            	</tr>

                            	<tr class="tcr-audio-format-title">
                            		<th colspan="2"><?php esc_html_e('MP3 file URL', TCR_ADMIN_TEXT_DOMAIN); ?></th>
                                </tr>
                                <tr class="tcr-audio-format">
                            		<td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-mp3" value="<?php echo _wp_specialchars($track['mp3'], ENT_COMPAT, false, true); ?>" /></td>
                            		<td class="tcr-audio-format-upload-td">
                            			<div class="tcr-upload-audio-track-button-wrap tcr-clearfix">
                                            <div class="tcr-upload-audio-format-button tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_audio_format_mp3_<?php echo $trackId; ?>"></div></div>
                                            <div class="tcr-loading"></div>
                                        </div>
                                    </td>
                            	</tr>

                            	<tr class="tcr-audio-format-title">
                            		<th colspan="2"><?php esc_html_e('OGG file URL (optional)', TCR_ADMIN_TEXT_DOMAIN); ?></th>
                                </tr>
                                <tr class="tcr-audio-format">
                            		<td class="tcr-audio-format-url-td"><input type="text" class="tcr-audio-format-input tcr-audio-format-ogg" value="<?php echo _wp_specialchars($track['oga'], ENT_COMPAT, false, true); ?>" /></td>
                            		<td class="tcr-audio-format-upload-td">
                                    	<div class="tcr-upload-audio-track-button-wrap tcr-clearfix">
                                            <div class="tcr-upload-audio-format-button tcr-swfupload-button"><?php esc_html_e('Upload', TCR_ADMIN_TEXT_DOMAIN); ?><div id="background_audio_format_ogg_<?php echo $trackId; ?>"></div></div>
                                            <div class="tcr-loading"></div>
                                        </div>
                                    </td>
                            	</tr>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="tcr-hidden"><textarea name="<?php echo $name; ?>" id="<?php echo $name; ?>"><?php echo esc_html(json_encode($value)); ?></textarea></div>
        <?php
    }

    public function toggle($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => '',
            'class' => '',
            'toggle' => ''
        )));

        $name = esc_attr($name);

        if ($toggle == 'yn') {
            $classes = array('tcr-option-toggle-yn');
        } else {
            $classes = array('tcr-option-toggle');
        }

        if (strlen($class)) {
            $classes[] = $class;
        }

        echo '<input type="checkbox" class="' . join(' ', $classes) . '" name="' . $name . '" id="' . $name . '" value="1" ' . checked($value, 1, false) . ' />';
    }

    public function tritoggle($config)
    {
        extract(wp_parse_args($config, array(
            'name' => '',
            'value' => '',
            'class' => '',
            'toggle' => ''
        )));

        $name = esc_attr($name);

        if ($toggle == 'yn') {
            $classes = array('tcr-option-tritoggle-yn');
        } else {
            $classes = array('tcr-option-tritoggle');
        }

        $config['class'] = join(' ', $classes);

        $config['options'] = array(
            '1' => __('On', TCR_ADMIN_TEXT_DOMAIN),
            '' => __('Default', TCR_ADMIN_TEXT_DOMAIN),
            '0' => __('Off', TCR_ADMIN_TEXT_DOMAIN)
        );

        $this->select($config);
    }
}